/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.client.retry;

import java.util.concurrent.CompletableFuture;
import o.a.c.sidecar.client.shaded.client.HttpResponse;
import o.a.c.sidecar.client.shaded.client.exception.RetriesExhaustedException;
import o.a.c.sidecar.client.shaded.client.retry.RetryAction;
import o.a.c.sidecar.client.shaded.client.retry.RetryPolicy;
import o.a.c.sidecar.client.shaded.common.request.Request;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.HttpResponseStatus;

public class CreateRestoreJobRetryPolicy
extends RetryPolicy {
    private final RetryPolicy delegate;

    public CreateRestoreJobRetryPolicy(RetryPolicy delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
        if (response != null && (response.statusCode() == HttpResponseStatus.CONFLICT.code() || response.statusCode() == HttpResponseStatus.BAD_REQUEST.code())) {
            this.logger.error("Request exhausted. response={}, attempts={}", (Object)response, (Object)attempts);
            responseFuture.completeExceptionally(RetriesExhaustedException.of(attempts, request, response));
        } else {
            this.delegate.onResponse(responseFuture, request, response, throwable, attempts, canRetryOnADifferentHost, retryAction);
        }
    }
}

