/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.http.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.io.vertx.core.AsyncResult;
import o.a.c.sidecar.client.shaded.io.vertx.core.Closeable;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.MultiMap;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.HttpClientOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.HttpVersion;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.RequestOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.WebSocket;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.WebSocketConnectOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.WebsocketVersion;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.EndpointKey;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.Http1xClientConnection;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.HttpChannelConnector;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.HttpClientConnection;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.WebSocketEndpoint;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.CloseFuture;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.VertxInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.future.PromiseInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetClient;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetClientOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.ProxyOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.SSLOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.SocketAddress;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.NetClientBuilder;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.NetClientImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.ProxyFilter;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.pool.ConnectionManager;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.pool.ConnectionPool;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.pool.Endpoint;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.pool.EndpointProvider;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.ClientMetrics;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.HttpClientMetrics;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.Metrics;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.MetricsProvider;

public class HttpClientBase
implements MetricsProvider,
Closeable {
    protected final VertxInternal vertx;
    protected final HttpClientOptions options;
    private final ConnectionManager<EndpointKey, HttpClientConnection> webSocketCM;
    protected final NetClientImpl netClient;
    protected final HttpClientMetrics metrics;
    private final boolean keepAlive;
    private final boolean pipelining;
    protected final CloseFuture closeFuture;
    private Predicate<SocketAddress> proxyFilter;
    private final Function<ContextInternal, ContextInternal> contextProvider;

    public HttpClientBase(VertxInternal vertx, HttpClientOptions options, CloseFuture closeFuture) {
        this.vertx = vertx;
        this.metrics = vertx.metricsSPI() != null ? vertx.metricsSPI().createHttpClientMetrics(options) : null;
        this.options = new HttpClientOptions(options);
        this.closeFuture = closeFuture;
        List<HttpVersion> alpnVersions = options.getAlpnVersions();
        if (alpnVersions == null || alpnVersions.isEmpty()) {
            switch (options.getProtocolVersion()) {
                case HTTP_2: {
                    alpnVersions = Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1);
                    break;
                }
                default: {
                    alpnVersions = Collections.singletonList(options.getProtocolVersion());
                }
            }
        }
        this.keepAlive = options.isKeepAlive();
        this.pipelining = options.isPipelining();
        if (!this.keepAlive && this.pipelining) {
            throw new IllegalStateException("Cannot have pipelining with no keep alive");
        }
        this.proxyFilter = options.getNonProxyHosts() != null ? ProxyFilter.nonProxyHosts(options.getNonProxyHosts()) : ProxyFilter.DEFAULT_PROXY_FILTER;
        this.netClient = (NetClientImpl)new NetClientBuilder(vertx, new NetClientOptions(options).setHostnameVerificationAlgorithm(options.isVerifyHost() ? "HTTPS" : "").setProxyOptions(null).setApplicationLayerProtocols(alpnVersions.stream().map(HttpVersion::alpnName).collect(Collectors.toList()))).metrics(this.metrics).closeFuture(closeFuture).build();
        this.webSocketCM = this.webSocketConnectionManager();
        int eventLoopSize = options.getPoolEventLoopSize();
        if (eventLoopSize > 0) {
            ContextInternal[] eventLoops = new ContextInternal[eventLoopSize];
            for (int i = 0; i < eventLoopSize; ++i) {
                eventLoops[i] = vertx.createEventLoopContext();
            }
            AtomicInteger idx = new AtomicInteger();
            this.contextProvider = ctx -> {
                int i = idx.getAndIncrement();
                return eventLoops[i % eventLoopSize];
            };
        } else {
            this.contextProvider = ConnectionPool.EVENT_LOOP_CONTEXT_PROVIDER;
        }
        closeFuture.add(this.netClient);
    }

    public NetClient netClient() {
        return this.netClient;
    }

    private ConnectionManager<EndpointKey, HttpClientConnection> webSocketConnectionManager() {
        return new ConnectionManager<EndpointKey, HttpClientConnection>();
    }

    Function<ContextInternal, ContextInternal> contextProvider() {
        return this.contextProvider;
    }

    protected final int getPort(RequestOptions request) {
        Integer port = request.getPort();
        if (port != null) {
            return port;
        }
        SocketAddress server = request.getServer();
        if (server != null && server.isInetSocket()) {
            return server.port();
        }
        return this.options.getDefaultPort();
    }

    private ProxyOptions getProxyOptions(ProxyOptions proxyOptions) {
        if (proxyOptions == null) {
            proxyOptions = this.options.getProxyOptions();
        }
        return proxyOptions;
    }

    protected final String getHost(RequestOptions request) {
        String host = request.getHost();
        if (host != null) {
            return host;
        }
        SocketAddress server = request.getServer();
        if (server != null && server.isInetSocket()) {
            return server.host();
        }
        return this.options.getDefaultHost();
    }

    protected final ProxyOptions resolveProxyOptions(ProxyOptions proxyOptions, SocketAddress addr) {
        proxyOptions = this.getProxyOptions(proxyOptions);
        if (this.proxyFilter != null && !this.proxyFilter.test(addr)) {
            proxyOptions = null;
        }
        return proxyOptions;
    }

    HttpClientMetrics metrics() {
        return this.metrics;
    }

    public void webSocket(WebSocketConnectOptions connectOptions, Handler<AsyncResult<WebSocket>> handler) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        promise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                ((WebSocket)ar.result()).resume();
            }
            handler.handle((AsyncResult<WebSocket>)ar);
        });
        this.webSocket(connectOptions, promise);
    }

    Future<WebSocket> webSocket(ContextInternal ctx, WebSocketConnectOptions connectOptions) {
        PromiseInternal<WebSocket> promise = ctx.promise();
        this.webSocket(connectOptions, promise);
        return promise.andThen(ar -> {
            if (ar.succeeded()) {
                ((WebSocket)ar.result()).resume();
            }
        });
    }

    private void webSocket(WebSocketConnectOptions connectOptions, PromiseInternal<WebSocket> promise) {
        ContextInternal ctx = promise.context();
        int port = this.getPort(connectOptions);
        String host = this.getHost(connectOptions);
        SocketAddress addr = SocketAddress.inetSocketAddress(port, host);
        final ProxyOptions proxyOptions = this.resolveProxyOptions(connectOptions.getProxyOptions(), addr);
        final EndpointKey key = new EndpointKey(connectOptions.isSsl() != null ? connectOptions.isSsl().booleanValue() : this.options.isSsl(), proxyOptions, addr, addr);
        ContextInternal eventLoopContext = ctx.isEventLoopContext() ? ctx : this.vertx.createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        EndpointProvider<HttpClientConnection> provider = new EndpointProvider<HttpClientConnection>(){

            @Override
            public Endpoint<HttpClientConnection> create(ContextInternal ctx, Runnable dispose) {
                int maxPoolSize = HttpClientBase.this.options.getMaxWebSockets();
                ClientMetrics metrics = HttpClientBase.this.metrics != null ? HttpClientBase.this.metrics.createEndpointMetrics(key.serverAddr, maxPoolSize) : null;
                HttpChannelConnector connector = new HttpChannelConnector(HttpClientBase.this, HttpClientBase.this.netClient, proxyOptions, metrics, HttpVersion.HTTP_1_1, key.ssl, false, key.peerAddr, key.serverAddr);
                return new WebSocketEndpoint(null, maxPoolSize, connector, dispose);
            }
        };
        this.webSocketCM.getConnection(eventLoopContext, key, provider, ar -> {
            if (ar.succeeded()) {
                Http1xClientConnection conn = (Http1xClientConnection)ar.result();
                long timeout = Math.max(connectOptions.getTimeout(), 0L);
                if (connectOptions.getIdleTimeout() >= 0L) {
                    timeout = connectOptions.getIdleTimeout();
                }
                conn.toWebSocket(ctx, connectOptions.getURI(), connectOptions.getHeaders(), connectOptions.getAllowOriginHeader(), connectOptions.getVersion(), connectOptions.getSubProtocols(), timeout, connectOptions.isRegisterWriteHandlers(), this.options.getMaxWebSocketFrameSize(), promise);
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    public Future<WebSocket> webSocket(int port, String host, String requestURI) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(port, host, requestURI, promise);
        return promise.future();
    }

    public Future<WebSocket> webSocket(String host, String requestURI) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(host, requestURI, promise);
        return promise.future();
    }

    public Future<WebSocket> webSocket(String requestURI) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(requestURI, promise);
        return promise.future();
    }

    public Future<WebSocket> webSocket(WebSocketConnectOptions options) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(options, (Handler<AsyncResult<WebSocket>>)promise);
        return promise.future();
    }

    public Future<WebSocket> webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocketAbs(url, headers, version, subProtocols, promise);
        return promise.future();
    }

    public void webSocket(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(new WebSocketConnectOptions().setURI(requestURI).setHost(host).setPort(port), handler);
    }

    public void webSocket(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), host, requestURI, handler);
    }

    public void webSocket(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, handler);
    }

    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<WebSocket>> handler) {
        WebSocketConnectOptions options = new WebSocketConnectOptions().setAbsoluteURI(url).setHeaders(headers).setVersion(version).setSubProtocols(subProtocols);
        this.webSocket(options, handler);
    }

    @Override
    public void close(Promise<Void> completion) {
        this.webSocketCM.close();
        completion.complete();
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.netClient.close(handler);
    }

    public Future<Void> close() {
        return this.netClient.close();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.getMetrics() != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    public Future<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        return this.netClient.updateSSLOptions(options, force);
    }

    public HttpClientBase proxyFilter(Predicate<SocketAddress> filter) {
        this.proxyFilter = filter;
        return this;
    }

    public HttpClientOptions options() {
        return this.options;
    }

    public VertxInternal vertx() {
        return this.vertx;
    }
}

