/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.streams.impl;

import java.util.Objects;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.Pump;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.ReadStream;
import o.a.c.sidecar.client.shaded.io.vertx.core.streams.WriteStream;

public class PumpImpl<T>
implements Pump {
    private final ReadStream<T> readStream;
    private final WriteStream<T> writeStream;
    private final Handler<T> dataHandler;
    private final Handler<Void> drainHandler;
    private int pumped;

    public PumpImpl(ReadStream<T> rs, WriteStream<T> ws, int maxWriteQueueSize) {
        this(rs, ws);
        this.writeStream.setWriteQueueMaxSize(maxWriteQueueSize);
    }

    public PumpImpl(ReadStream<T> rs, WriteStream<T> ws) {
        Objects.requireNonNull(rs);
        Objects.requireNonNull(ws);
        this.readStream = rs;
        this.writeStream = ws;
        this.drainHandler = v -> this.readStream.resume();
        this.dataHandler = data -> {
            this.writeStream.write(data);
            this.incPumped();
            if (this.writeStream.writeQueueFull()) {
                this.readStream.pause();
                this.writeStream.drainHandler(this.drainHandler);
            }
        };
    }

    @Override
    public PumpImpl setWriteQueueMaxSize(int maxSize) {
        this.writeStream.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public PumpImpl start() {
        this.readStream.handler(this.dataHandler);
        return this;
    }

    @Override
    public PumpImpl stop() {
        this.writeStream.drainHandler(null);
        this.readStream.handler(null);
        return this;
    }

    @Override
    public synchronized int numberPumped() {
        return this.pumped;
    }

    private synchronized void incPumped() {
        ++this.pumped;
    }
}

