/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.BulkWriteDownInstanceTest;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.ResiliencyTestBase;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.distributed.api.ICluster;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.yaml.ServiceConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SidecarConfigurationImpl;
import org.apache.cassandra.sidecar.server.Server;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkWriteDownSidecarTest
extends SharedClusterSparkIntegrationTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkWriteDownSidecarTest.class);
    Set<Server> downSidecars = new HashSet<Server>();
    List<Server> sidecarServerList = new ArrayList<Server>();

    BulkWriteDownSidecarTest() {
    }

    @ParameterizedTest(name="{index} => instanceDownCount={0} {1}")
    @MethodSource(value={"testInputs"})
    void testHandlingOfDownedSidecarInstances(int instanceDownCount, TestConsistencyLevel cl) throws Exception {
        this.stopSidecarInstancesForTest(instanceDownCount);
        QualifiedName tableName = ResiliencyTestBase.uniqueTestTableFullName("spark_test", cl.readCL, cl.writeCL);
        SparkSession spark = this.getOrCreateSparkSession();
        Dataset<Row> df = DataGenerationUtils.generateCourseData(spark, 1000);
        DataFrameWriter dfWriter = this.bulkWriterDataFrameWriter(df, tableName).option(WriterOptions.BULK_WRITER_CL.name(), cl.writeCL.name());
        if (BulkWriteDownInstanceTest.isFailureExpected(instanceDownCount, cl)) {
            this.sparkTestUtils.assertExpectedBulkWriteFailure(cl.writeCL.name(), (DataFrameWriter<Row>)dfWriter);
        } else {
            dfWriter.save();
            this.sparkTestUtils.validateWrites(df.collectAsList(), this.queryAllData(tableName, cl.readCL));
        }
    }

    protected void startSidecar(ICluster<? extends IInstance> cluster) throws InterruptedException {
        for (IInstance instance : cluster) {
            LOGGER.info("Starting Sidecar instance for Cassandra instance {}", (Object)instance.config().num());
            Server server = this.startSidecarWithInstances(Collections.singleton(instance));
            this.sidecarServerList.add(server);
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.sidecarServerList.size()).as("Each Cassandra Instance will be managed by a single Sidecar instance", new Object[0])).isEqualTo(cluster.size());
        this.server = this.sidecarServerList.get(0);
    }

    protected Function<SidecarConfigurationImpl.Builder, SidecarConfigurationImpl.Builder> configurationOverrides() {
        return builder -> {
            ServiceConfigurationImpl conf = this.sidecarServerList.isEmpty() ? ServiceConfigurationImpl.builder().host("localhost").port(0).build() : ServiceConfigurationImpl.builder().host("localhost" + (this.sidecarServerList.size() + 1)).port(this.sidecarServerList.get(0).actualPort()).build();
            builder.serviceConfiguration((ServiceConfiguration)conf);
            return builder;
        };
    }

    protected void stopSidecar() throws InterruptedException {
        for (Server server : this.sidecarServerList) {
            if (!this.downSidecars.add(server)) continue;
            CountDownLatch closeLatch = new CountDownLatch(1);
            server.close().onSuccess(res -> closeLatch.countDown());
            if (closeLatch.await(60L, TimeUnit.SECONDS)) continue;
            this.logger.error("Close event timed out.");
        }
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3);
        BulkWriteDownInstanceTest.testConsistencyLevels().forEach(consistencyLevel -> {
            QualifiedName tableName = ResiliencyTestBase.uniqueTestTableFullName("spark_test", consistencyLevel.readCL, consistencyLevel.writeCL);
            this.createTestTable(tableName, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().nodesPerDc(3);
    }

    void stopSidecarInstancesForTest(int instanceDownCount) throws Exception {
        Assertions.assertThat(this.sidecarServerList).isNotEmpty();
        block0: while (instanceDownCount > this.downSidecars.size()) {
            for (Server server : this.sidecarServerList) {
                if (!this.downSidecars.add(server)) continue;
                server.close().toCompletionStage().toCompletableFuture().get(30L, TimeUnit.SECONDS);
                continue block0;
            }
        }
    }

    static Stream<Arguments> testInputs() {
        return IntStream.rangeClosed(0, 2).mapToObj(instanceDownCount -> new AbstractMap.SimpleEntry<Integer, List<TestConsistencyLevel>>(instanceDownCount, BulkWriteDownInstanceTest.testConsistencyLevels())).flatMap(pair -> ((List)pair.getValue()).stream().map(cl -> Arguments.of((Object[])new Object[]{pair.getKey(), cl})));
    }
}

