/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.shrink;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.analytics.shrink.LeavingTestBase;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.distributed.api.ICluster;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class LeavingMultiDCFailureTest
extends LeavingTestBase {
    LeavingMultiDCFailureTest() {
    }

    @ParameterizedTest(name="{index} => {0}")
    @MethodSource(value={"multiDCTestInputs"})
    void testLeavingFailureScenario(TestConsistencyLevel cl) {
        QualifiedName table = LeavingMultiDCFailureTest.uniqueTestTableFullName("spark_test", cl.readCL, cl.writeCL);
        this.bulkWriterDataFrameWriter((Dataset<Row>)this.df, table).option(WriterOptions.BULK_WRITER_CL.name(), cl.writeCL.name()).save();
        this.validateData(table, cl.readCL, 1000);
        this.validateNodeSpecificData(table, this.generateExpectedInstanceData((ICluster<? extends IInstance>)this.cluster, this.leavingNodes, 1000), false);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3_DC2_RF3);
        LeavingMultiDCFailureTest.multiDCTestInputs().forEach(arguments -> {
            QualifiedName tableName = LeavingMultiDCFailureTest.uniqueTestTableFullName("spark_test", arguments.get());
            this.createTestTable(tableName, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
    }

    protected void beforeClusterShutdown() {
        this.completeTransitionsAndValidateWrites(BBHelperLeavingNodesMultiDCFailure.transitionalStateEnd, LeavingMultiDCFailureTest.multiDCTestInputs());
        Assertions.assertThat((boolean)this.areLeavingNodesPartOfCluster(this.cluster.get(1), this.leavingNodes)).isTrue();
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return LeavingMultiDCFailureTest.clusterConfig().dcCount(2).nodesPerDc(5).requestFeature(Feature.NETWORK).instanceInitializer(BBHelperLeavingNodesMultiDCFailure::install);
    }

    @Override
    protected int leavingNodesPerDc() {
        return 1;
    }

    @Override
    protected CountDownLatch transitioningStateStart() {
        return BBHelperLeavingNodesMultiDCFailure.transitionalStateStart;
    }

    public static class BBHelperLeavingNodesMultiDCFailure {
        static final CountDownLatch transitionalStateStart = new CountDownLatch(2);
        static final CountDownLatch transitionalStateEnd = new CountDownLatch(2);

        public static void install(ClassLoader cl, Integer nodeNumber) {
            if (nodeNumber > 8) {
                TypePool typePool = TypePool.Default.of((ClassLoader)cl);
                TypeDescription description = typePool.describe("org.apache.cassandra.service.StorageService").resolve();
                new ByteBuddy().rebase(description, ClassFileLocator.ForClassLoader.of((ClassLoader)cl)).method((ElementMatcher)ElementMatchers.named((String)"unbootstrap")).intercept((Implementation)MethodDelegation.to(BBHelperLeavingNodesMultiDCFailure.class)).make((TypeResolutionStrategy)TypeResolutionStrategy.Lazy.INSTANCE, typePool).load(cl, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }

        public static void unbootstrap(@SuperCall Callable<?> orig) throws Exception {
            transitionalStateStart.countDown();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)transitionalStateEnd, (long)2L, (TimeUnit)TimeUnit.MINUTES);
            throw new UnsupportedOperationException("Simulate leave failure");
        }
    }
}

