/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.shrink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.ResiliencyTestBase;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.analytics.TestUninterruptibles;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.ICluster;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.distributed.api.NodeToolResult;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.utils.ClusterUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LeavingTestBase
extends ResiliencyTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeavingTestBase.class);
    List<? extends IInstance> leavingNodes;
    Dataset<Row> df;
    private Map<? extends IInstance, Set<String>> expectedInstanceData;

    LeavingTestBase() {
    }

    protected void runLeavingTestScenario(TestConsistencyLevel cl) {
        QualifiedName table = LeavingTestBase.uniqueTestTableFullName("spark_test", cl.readCL, cl.writeCL);
        this.bulkWriterDataFrameWriter(this.df, table).option(WriterOptions.BULK_WRITER_CL.name(), cl.writeCL.name()).save();
        this.validateData(table, cl.readCL, 1000);
        this.validateNodeSpecificData(table, this.expectedInstanceData, false);
    }

    @Override
    protected void beforeTestStart() {
        super.beforeTestStart();
        SparkSession spark = this.getOrCreateSparkSession();
        this.df = DataGenerationUtils.generateCourseData(spark, 1000);
        this.expectedInstanceData = this.generateExpectedInstanceData((ICluster<? extends IInstance>)this.cluster, this.leavingNodes, 1000);
    }

    protected void afterClusterProvisioned() {
        ClusterBuilderConfiguration configuration = this.testClusterConfiguration();
        IInstance seed = this.cluster.getFirstRunningInstance();
        this.leavingNodes = this.decommissionNodes((ICluster<? extends IInstance>)this.cluster, this.leavingNodesPerDc(), configuration.dcCount);
        TestUninterruptibles.awaitUninterruptiblyOrThrow(this.transitioningStateStart(), 4L, TimeUnit.MINUTES);
        this.leavingNodes.forEach(instance -> this.cluster.awaitRingState(seed, instance, "Leaving"));
    }

    protected void completeTransitionsAndValidateWrites(CountDownLatch transitionalStateEnd, Stream<Arguments> testInputs) {
        for (int i = 0; i < this.leavingNodesPerDc(); ++i) {
            transitionalStateEnd.countDown();
        }
        testInputs.forEach(arguments -> {
            TestConsistencyLevel cl = (TestConsistencyLevel)arguments.get()[0];
            QualifiedName tableName = LeavingTestBase.uniqueTestTableFullName("spark_test", cl.readCL, cl.writeCL);
            this.validateData(tableName, cl.readCL, 1000);
            this.validateNodeSpecificData(tableName, this.expectedInstanceData, false);
        });
    }

    protected abstract CountDownLatch transitioningStateStart();

    protected abstract int leavingNodesPerDc();

    protected static Stream<Arguments> singleDCTestInputs() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.ONE, ConsistencyLevel.ALL)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.QUORUM, ConsistencyLevel.QUORUM)}));
    }

    protected static Stream<Arguments> multiDCTestInputs() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.ALL, ConsistencyLevel.ONE)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.LOCAL_QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.EACH_QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.QUORUM, ConsistencyLevel.QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.ONE, ConsistencyLevel.ALL)}));
    }

    protected List<IInstance> decommissionNodes(ICluster<? extends IInstance> cluster, int leavingNodesPerDC, int numDcs) {
        ArrayList<IInstance> leavingNodes = new ArrayList<IInstance>();
        for (int i = 0; i < leavingNodesPerDC * numDcs; ++i) {
            IInstance node = cluster.get(cluster.size() - i);
            new Thread(() -> {
                NodeToolResult decommission = node.nodetoolResult(new String[]{"decommission"});
                if (decommission.getRc() != 0 || decommission.getError() != null) {
                    LOGGER.error("Failed to decommission instance={}", (Object)node.config().num(), (Object)decommission.getError());
                }
                decommission.asserts().success();
            }).start();
            leavingNodes.add(node);
        }
        return leavingNodes;
    }

    protected boolean areLeavingNodesPartOfCluster(IInstance seed, List<? extends IInstance> leavingNodes) {
        Set leavingAddresses = leavingNodes.stream().map(node -> node.broadcastAddress().getAddress().getHostAddress()).collect(Collectors.toSet());
        ClusterUtils.ring((IInstance)seed).forEach(i -> leavingAddresses.remove(i.getAddress()));
        return leavingAddresses.isEmpty();
    }
}

