/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.trans.DeleteTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.trans.UpdateTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.DeleteQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.UpdateQuery;

public class UpdateAction
extends BaseSQLAction {
    protected Query query;

    public UpdateAction(Query query, DbAdapter adapter, EntityResolver entityResolver) {
        super(adapter, entityResolver);
        this.query = query;
    }

    protected QueryAssembler createTranslator(Connection connection) {
        QueryAssembler translator;
        if (this.query instanceof UpdateQuery) {
            translator = new UpdateTranslator();
        } else if (this.query instanceof DeleteQuery) {
            translator = new DeleteTranslator();
        } else {
            throw new CayenneRuntimeException("Can't make a translator for query " + this.query);
        }
        translator.setAdapter(this.getAdapter());
        translator.setQuery(this.query);
        translator.setEntityResolver(this.getEntityResolver());
        translator.setConnection(connection);
        return translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        QueryAssembler translator = this.createTranslator(connection);
        PreparedStatement statement = translator.createStatement();
        try {
            int count = statement.executeUpdate();
            QueryLogger.logUpdateCount(count);
            observer.nextCount(this.query, count);
        }
        finally {
            statement.close();
        }
    }
}

