/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.conf.DBCPDataSourceProperties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

class DBCPDataSourceBuilder {
    static final String DRIVER_CLASS_NAME = "driverClassName";
    static final String URL = "url";
    static final String USER_NAME = "username";
    static final String PASSWORD = "password";
    static final String MAX_ACTIVE = "maxActive";
    static final String MIN_IDLE = "minIdle";
    static final String MAX_IDLE = "maxIdle";
    static final String MAX_WAIT = "maxWait";
    static final String VALIDATION_QUERY = "validationQuery";
    static final String TEST_ON_BORROW = "testOnBorrow";
    static final String TEST_ON_RETURN = "testOnReturn";
    static final String TEST_IDLE = "testWhileIdle";
    static final String TIME_BETWEEN_EVICTIONS = "timeBetweenEvictionRunsMillis";
    static final String NUM_TEST_PER_EVICTION = "numTestsPerEvictionRun";
    static final String MIN_EVICTABLE_TIME = "minEvictableIdleTimeMillis";
    static final String EXHAUSTED_ACTION = "whenExhaustedAction";
    static final String AUTO_COMMIT = "defaultAutoCommit";
    static final String READ_ONLY = "defaultReadOnly";
    static final String TRANSACTION_ISOLATION = "defaultTransactionIsolation";
    static final String CONNECTION_NOWRAP = "accessToUnderlyingConnectionAllowed";
    static final String CATALOG = "defaultCatalog";
    static final String POOL_PS = "poolPreparedStatements";
    static final String PS_MAX_ACTIVE = "ps.maxActive";
    static final String PS_MAX_IDLE = "ps.maxIdle";
    static final String PS_MAX_TOTAL = "ps.maxTotal";
    static final String PS_MAX_WAIT = "ps.maxWait";
    static final String PS_MIN_EVICTABLE_TIME = "ps.minEvictableIdleTimeMillis";
    static final String PS_NUM_TEST_PER_EVICTION = "ps.numTestsPerEvictionRun";
    static final String PS_TEST_ON_BORROW = "ps.testOnBorrow";
    static final String PS_TEST_ON_RETURN = "ps.testOnReturn";
    static final String PS_TEST_IDLE = "ps.testWhileIdle";
    static final String PS_TIME_BETWEEN_EVICTIONS = "ps.timeBetweenEvictionRunsMillis";
    static final String PS_EXHAUSTED_ACTION = "ps.whenExhaustedAction";
    private DBCPDataSourceProperties config;

    DBCPDataSourceBuilder(DBCPDataSourceProperties properties) {
        this.config = properties;
    }

    DataSource createDataSource() {
        boolean connectionNoWrap = this.config.getBoolean(CONNECTION_NOWRAP, false);
        ObjectPool connectionPool = this.createConnectionPool();
        PoolingDataSource dataSource = new PoolingDataSource(connectionPool);
        dataSource.setAccessToUnderlyingConnectionAllowed(connectionNoWrap);
        return dataSource;
    }

    private void loadDriverClass() {
        String driver = this.config.getString(DRIVER_CLASS_NAME, true);
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Error loading driver " + driver, e);
        }
    }

    private ObjectPool createConnectionPool() {
        ConnectionFactory factory = this.createConnectionFactory();
        GenericObjectPool.Config poolConfig = this.createConnectionPoolConfig();
        KeyedObjectPoolFactory statementPool = this.createPreparedStatementPool();
        String validationQuery = this.config.getString(VALIDATION_QUERY);
        boolean defaultReadOnly = this.config.getBoolean(READ_ONLY, false);
        boolean defaultAutoCommit = this.config.getBoolean(AUTO_COMMIT, false);
        int defaultTransactionIsolation = this.config.getTransactionIsolation(TRANSACTION_ISOLATION, 8);
        String defaultCatalog = this.config.getString(CATALOG);
        GenericObjectPool connectionPool = new GenericObjectPool(null, poolConfig);
        new PoolableConnectionFactory(factory, (ObjectPool)connectionPool, statementPool, validationQuery, defaultReadOnly ? Boolean.TRUE : Boolean.FALSE, defaultAutoCommit, defaultTransactionIsolation, defaultCatalog, null);
        return connectionPool;
    }

    private ConnectionFactory createConnectionFactory() {
        this.loadDriverClass();
        String url = this.config.getString(URL, true);
        String userName = this.config.getString(USER_NAME);
        String password = this.config.getString(PASSWORD);
        return new DriverManagerConnectionFactory(url, userName, password);
    }

    private KeyedObjectPoolFactory createPreparedStatementPool() {
        if (!this.config.getBoolean(POOL_PS, false)) {
            return null;
        }
        int maxActive = this.config.getInt(PS_MAX_ACTIVE, 8);
        byte whenExhaustedAction = this.config.getWhenExhaustedAction(PS_EXHAUSTED_ACTION, (byte)1);
        long maxWait = this.config.getLong(PS_MAX_WAIT, -1L);
        int maxIdle = this.config.getInt(PS_MAX_IDLE, 8);
        int maxTotal = this.config.getInt(PS_MAX_TOTAL, 1);
        boolean testOnBorrow = this.config.getBoolean(PS_TEST_ON_BORROW, false);
        boolean testOnReturn = this.config.getBoolean(PS_TEST_ON_RETURN, false);
        long timeBetweenEvictionRunsMillis = this.config.getLong(PS_TIME_BETWEEN_EVICTIONS, -1L);
        int numTestsPerEvictionRun = this.config.getInt(PS_NUM_TEST_PER_EVICTION, 3);
        long minEvictableIdleTimeMillis = this.config.getLong(PS_MIN_EVICTABLE_TIME, 1800000L);
        boolean testWhileIdle = this.config.getBoolean(PS_TEST_IDLE, false);
        return new GenericKeyedObjectPoolFactory(null, maxActive, whenExhaustedAction, maxWait, maxIdle, maxTotal, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    private GenericObjectPool.Config createConnectionPoolConfig() {
        GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
        poolConfig.maxIdle = this.config.getInt(MAX_IDLE, 8);
        poolConfig.minIdle = this.config.getInt(MIN_IDLE, 0);
        poolConfig.maxActive = this.config.getInt(MAX_ACTIVE, 8);
        poolConfig.maxWait = this.config.getLong(MAX_WAIT, -1L);
        poolConfig.testOnBorrow = this.config.getBoolean(TEST_ON_BORROW, false);
        poolConfig.testOnReturn = this.config.getBoolean(TEST_ON_RETURN, false);
        poolConfig.testWhileIdle = this.config.getBoolean(TEST_IDLE, false);
        poolConfig.timeBetweenEvictionRunsMillis = this.config.getLong(TIME_BETWEEN_EVICTIONS, -1L);
        poolConfig.numTestsPerEvictionRun = this.config.getInt(NUM_TEST_PER_EVICTION, 3);
        poolConfig.minEvictableIdleTimeMillis = this.config.getLong(MIN_EVICTABLE_TIME, 1800000L);
        poolConfig.whenExhaustedAction = this.config.getWhenExhaustedAction(EXHAUSTED_ACTION, (byte)1);
        return poolConfig;
    }
}

