/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.action.CreateDataMapEntityListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateEntityListenerUndoableEdit
extends CayenneUndoableEdit {
    private ObjEntity objEntity;
    private EntityListener listener;

    public CreateEntityListenerUndoableEdit(ObjEntity objEntity, EntityListener listener) {
        this.objEntity = objEntity;
        this.listener = listener;
    }

    public String getPresentationName() {
        return "Create Entity Listener";
    }

    public void redo() throws CannotRedoException {
        CreateDataMapEntityListenerAction action = (CreateDataMapEntityListenerAction)this.actionManager.getAction(CreateDataMapEntityListenerAction.getActionName());
        action.createEntityListener(this.objEntity, this.listener);
    }

    public void undo() throws CannotUndoException {
        RemoveEntityListenerAction action = (RemoveEntityListenerAction)this.actionManager.getAction(RemoveEntityListenerAction.getActionName());
        action.removeEntityListener(this.objEntity, this.listener.getClassName());
    }
}

