/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.Factory;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;

public class MapDigraph
implements Digraph,
Serializable {
    public static final Factory HASHMAP_FACTORY = new HashMapFactory();
    public static final Factory TREEMAP_FACTORY = new TreeMapFactory();
    private Factory mapFactory;
    private Map graph;
    private int size;

    public MapDigraph() {
        this(null);
    }

    public MapDigraph(Factory mapFactory) {
        this.mapFactory = mapFactory != null ? mapFactory : HASHMAP_FACTORY;
        this.graph = this.createMap();
    }

    public boolean addVertex(Object vertex) {
        if (this.graph.containsKey(vertex)) {
            return false;
        }
        this.graph.put(vertex, this.createMap());
        return true;
    }

    public boolean addAllVertices(Collection vertices) {
        if (this.graph.keySet().containsAll(vertices)) {
            return false;
        }
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            this.addVertex(i.next());
        }
        return true;
    }

    public Object putArc(Object origin, Object destination, Object arc) {
        Map destinations = (Map)this.graph.get(origin);
        if (destinations == null) {
            destinations = this.createMap();
            this.graph.put(origin, destinations);
        }
        this.addVertex(destination);
        Object oldArc = destinations.put(destination, arc);
        if (oldArc == null) {
            ++this.size;
        }
        return oldArc;
    }

    public Object getArc(Object origin, Object destination) {
        Map destinations = (Map)this.graph.get(origin);
        if (destinations == null) {
            return null;
        }
        return destinations.get(destination);
    }

    public boolean removeVertex(Object vertex) {
        Map dst = (Map)this.graph.remove(vertex);
        if (dst != null) {
            this.size -= dst.size();
        } else {
            return false;
        }
        this.removeIncoming(vertex);
        return true;
    }

    public boolean removeAllVertices(Collection vertices) {
        boolean modified = false;
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            modified |= this.removeVertex(i.next());
        }
        return modified;
    }

    public Object removeArc(Object origin, Object destination) {
        Map destinations = (Map)this.graph.get(origin);
        if (destinations == null) {
            return null;
        }
        Object arc = destinations.remove(destination);
        if (arc != null) {
            --this.size;
        }
        return arc;
    }

    public boolean removeIncoming(Object vertex) {
        boolean modified = false;
        for (Map destinations : this.graph.values()) {
            Object arc = destinations.remove(vertex);
            if (arc != null) {
                --this.size;
            }
            modified |= arc != null;
        }
        return modified;
    }

    public boolean removeOutgoing(Object vertex) {
        Map destinations = (Map)this.graph.remove(vertex);
        if (destinations != null) {
            this.size -= destinations.size();
        } else {
            return false;
        }
        boolean modified = !destinations.isEmpty();
        destinations.clear();
        return modified;
    }

    public Iterator vertexIterator() {
        return this.graph.keySet().iterator();
    }

    public ArcIterator arcIterator() {
        return new AllArcIterator();
    }

    public ArcIterator outgoingIterator(Object vertex) {
        if (!this.containsVertex(vertex)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new OutgoingArcIterator(vertex);
    }

    public ArcIterator incomingIterator(Object vertex) {
        if (!this.containsVertex(vertex)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new IncomingArcIterator(vertex);
    }

    public int order() {
        return this.graph.size();
    }

    public int size() {
        return this.size;
    }

    public int outgoingSize(Object vertex) {
        Map destinations = (Map)this.graph.get(vertex);
        if (destinations == null) {
            return 0;
        }
        return destinations.size();
    }

    public int incomingSize(Object vertex) {
        int count = 0;
        if (!this.graph.containsKey(vertex)) {
            return 0;
        }
        for (Map destinations : this.graph.values()) {
            count += destinations.containsKey(vertex) ? 1 : 0;
        }
        return count;
    }

    public boolean containsVertex(Object vertex) {
        return this.graph.containsKey(vertex);
    }

    public boolean containsAllVertices(Collection vertices) {
        return this.graph.keySet().containsAll(vertices);
    }

    public boolean hasArc(Object origin, Object destination) {
        Map destinations = (Map)this.graph.get(origin);
        if (destinations == null) {
            return false;
        }
        return destinations.containsKey(destination);
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    public boolean isOutgoingEmpty(Object vertex) {
        return this.outgoingSize(vertex) == 0;
    }

    public boolean isIncomingEmpty(Object vertex) {
        return this.incomingSize(vertex) == 0;
    }

    private Map createMap() {
        return (Map)this.mapFactory.create();
    }

    public static class TreeMapFactory
    implements Factory,
    Serializable {
        private Comparator comparator;

        public TreeMapFactory() {
        }

        public TreeMapFactory(Comparator mapComparator) {
            this.comparator = mapComparator;
        }

        public Object create() {
            if (this.comparator == null) {
                return new TreeMap();
            }
            return new TreeMap(this.comparator);
        }
    }

    public static class HashMapFactory
    implements Factory,
    Serializable {
        public Object create() {
            return new HashMap();
        }
    }

    private class IncomingArcIterator
    implements ArcIterator {
        private Object dst;
        private Object origin;
        private Object nextOrigin;
        private Object arc;
        private Object nextArc;
        private Iterator graphIt;

        private IncomingArcIterator(Object vertex) {
            this.dst = vertex;
            this.graphIt = MapDigraph.this.graph.entrySet().iterator();
            this.next();
        }

        public Object getOrigin() {
            return this.origin;
        }

        public Object getDestination() {
            return this.dst;
        }

        public boolean hasNext() {
            return this.nextArc != null;
        }

        public Object next() {
            this.origin = this.nextOrigin;
            this.arc = this.nextArc;
            this.nextArc = null;
            this.nextOrigin = null;
            while (this.graphIt.hasNext()) {
                Map.Entry entry = (Map.Entry)this.graphIt.next();
                Map destinations = (Map)entry.getValue();
                this.nextArc = destinations.get(this.dst);
                if (this.nextArc == null) continue;
                this.nextOrigin = entry.getKey();
                break;
            }
            return this.arc;
        }

        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }

    private class OutgoingArcIterator
    implements ArcIterator {
        private Object origin;
        private Iterator dstIt;
        private Map.Entry entry;

        private OutgoingArcIterator(Object vertex) {
            this.origin = vertex;
            this.dstIt = ((Map)MapDigraph.this.graph.get(vertex)).entrySet().iterator();
        }

        public Object getOrigin() {
            return this.origin;
        }

        public Object getDestination() {
            if (this.entry == null) {
                return null;
            }
            return this.entry.getKey();
        }

        public boolean hasNext() {
            return this.dstIt.hasNext();
        }

        public Object next() {
            this.entry = (Map.Entry)this.dstIt.next();
            return this.entry.getValue();
        }

        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }

    private class AllArcIterator
    implements ArcIterator {
        private Iterator orgIterator;
        private Iterator dstIterator;
        private Object origin;
        private Object nextOrigin;
        private Object dst;
        private Object nextDst;
        private Object arc;
        private Object nextArc;

        private AllArcIterator() {
            this.orgIterator = MapDigraph.this.graph.entrySet().iterator();
            this.next();
        }

        public Object getOrigin() {
            return this.origin;
        }

        public Object getDestination() {
            return this.dst;
        }

        public boolean hasNext() {
            return this.nextArc != null;
        }

        public Object next() {
            this.origin = this.nextOrigin;
            this.dst = this.nextDst;
            this.arc = this.nextArc;
            if (this.dstIterator == null || !this.dstIterator.hasNext()) {
                this.nextOrigin = null;
                this.nextDst = null;
                this.nextArc = null;
                while (this.orgIterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.orgIterator.next();
                    this.dstIterator = ((Map)entry.getValue()).entrySet().iterator();
                    if (!this.dstIterator.hasNext()) continue;
                    this.nextOrigin = entry.getKey();
                    Map.Entry entry1 = (Map.Entry)this.dstIterator.next();
                    this.nextDst = entry1.getKey();
                    this.nextArc = entry1.getValue();
                    break;
                }
            } else {
                Map.Entry entry1 = (Map.Entry)this.dstIterator.next();
                this.nextDst = entry1.getKey();
                this.nextArc = entry1.getValue();
            }
            return this.arc;
        }

        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }
}

