/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.graph.ArcCreateOperation;
import org.apache.cayenne.graph.ArcDeleteOperation;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.NodeCreateOperation;
import org.apache.cayenne.graph.NodeDeleteOperation;
import org.apache.cayenne.graph.NodeDiff;
import org.apache.cayenne.graph.NodeIdChangeOperation;
import org.apache.cayenne.graph.NodePropertyChangeOperation;

public class GraphDiffCompressor {
    public GraphDiff compress(GraphDiff diff) {
        if (diff.isNoop()) {
            return diff;
        }
        CompressAction action = new CompressAction();
        diff.apply(action);
        return action.getCompressedDiff();
    }

    final class CompressAction
    implements GraphChangeHandler {
        private List<GraphDiff> compressed = new ArrayList<GraphDiff>();
        private Map<Object, List<NodeDiff>> diffsByNode = new HashMap<Object, List<NodeDiff>>();
        private Set<Object> deletedNodes;
        private Set<Object> createdNodes;

        CompressAction() {
        }

        GraphDiff getCompressedDiff() {
            if (this.deletedNodes != null) {
                for (Object nodeId : this.deletedNodes) {
                    NodeDiff diff;
                    Iterator<GraphDiff> it = this.compressed.iterator();
                    if (this.createdNodes != null && this.createdNodes.contains(nodeId)) {
                        while (it.hasNext()) {
                            diff = (NodeDiff)it.next();
                            if (!nodeId.equals(diff.getNodeId())) continue;
                            it.remove();
                        }
                        continue;
                    }
                    while (it.hasNext()) {
                        diff = (NodeDiff)it.next();
                        if (!nodeId.equals(diff.getNodeId()) || !(diff instanceof NodePropertyChangeOperation)) continue;
                        it.remove();
                    }
                }
            }
            return new CompoundDiff(this.compressed);
        }

        public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
            List<NodeDiff> diffs;
            if (targetNodeId != null && (diffs = this.diffsByNode.get(nodeId)) != null) {
                for (int i = diffs.size() - 1; i >= 0; --i) {
                    ArcDeleteOperation arcDiff;
                    NodeDiff diff = diffs.get(i);
                    if (!(diff instanceof ArcDeleteOperation) || !arcId.equals((arcDiff = (ArcDeleteOperation)diff).getArcId()) || !targetNodeId.equals(arcDiff.targetNodeId)) continue;
                    diffs.remove(i);
                    this.compressed.remove(arcDiff);
                    return;
                }
            }
            this.registerDiff(new ArcCreateOperation(nodeId, targetNodeId, arcId));
        }

        public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
            List<NodeDiff> diffs;
            if (targetNodeId != null && (diffs = this.diffsByNode.get(nodeId)) != null) {
                for (int i = diffs.size() - 1; i >= 0; --i) {
                    ArcCreateOperation arcDiff;
                    NodeDiff diff = diffs.get(i);
                    if (!(diff instanceof ArcCreateOperation) || !arcId.equals((arcDiff = (ArcCreateOperation)diff).getArcId()) || !targetNodeId.equals(arcDiff.targetNodeId)) continue;
                    diffs.remove(i);
                    this.compressed.remove(arcDiff);
                    return;
                }
            }
            this.registerDiff(new ArcDeleteOperation(nodeId, targetNodeId, arcId));
        }

        public void nodeCreated(Object nodeId) {
            this.registerDiff(new NodeCreateOperation(nodeId));
            if (this.createdNodes == null) {
                this.createdNodes = new HashSet<Object>();
            }
            this.createdNodes.add(nodeId);
        }

        public void nodeIdChanged(Object nodeId, Object newId) {
            this.registerDiff(new NodeIdChangeOperation(nodeId, newId));
        }

        public void nodeRemoved(Object nodeId) {
            this.registerDiff(new NodeDeleteOperation(nodeId));
            if (this.deletedNodes == null) {
                this.deletedNodes = new HashSet<Object>();
            }
            this.deletedNodes.add(nodeId);
        }

        public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
            List<NodeDiff> diffs = this.diffsByNode.get(nodeId);
            if (diffs != null) {
                for (int i = diffs.size() - 1; i >= 0; --i) {
                    NodePropertyChangeOperation propertyDiff;
                    NodeDiff diff = diffs.get(i);
                    if (!(diff instanceof NodePropertyChangeOperation) || !property.equals((propertyDiff = (NodePropertyChangeOperation)diff).getProperty())) continue;
                    propertyDiff.setNewValue(newValue);
                    return;
                }
            }
            this.registerDiff(new NodePropertyChangeOperation(nodeId, property, oldValue, newValue));
        }

        private void registerDiff(NodeDiff diff) {
            this.compressed.add(diff);
            List<NodeDiff> diffs = this.diffsByNode.get(diff.getNodeId());
            if (diffs == null) {
                diffs = new ArrayList<NodeDiff>();
                this.diffsByNode.put(diff.getNodeId(), diffs);
            }
            diffs.add(diff);
        }
    }
}

