/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.validator;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.ProjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicatedAttributesDialog
extends CayenneDialog {
    protected static DuplicatedAttributesDialog instance;
    static final String DELETE_ACTION = "delete";
    static final String RENAME_ACTION = "rename";
    public static final String CANCEL_RESULT = "cancel";
    public static final String PROCEEDED_RESULT = "proceeded";
    static String result;
    protected List<DuplicatedAttributeInfo> duplicatedAttributes;
    protected ObjEntity superEntity;
    protected ObjEntity entity;
    protected JTable attributesTable;
    protected JButton cancelButton;
    protected JButton proceedButton;

    public static synchronized void showDialog(CayenneModelerFrame editor, List<ObjAttribute> duplicatedAttributes, ObjEntity superEntity, ObjEntity entity) {
        if (instance == null) {
            instance = new DuplicatedAttributesDialog(editor);
            instance.centerWindow();
        }
        instance.setSuperEntity(superEntity);
        instance.setEntity(entity);
        instance.setDuplicatedAttributes(duplicatedAttributes);
        instance.updateTable();
        instance.setVisible(true);
    }

    protected DuplicatedAttributesDialog(CayenneModelerFrame editor) {
        super(editor, "Duplicated Attributes", true);
        result = CANCEL_RESULT;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.cancelButton = new JButton("Cancel");
        this.proceedButton = new JButton("Continue");
        this.attributesTable = new JTable();
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("fill:200dlu:grow", "pref, 3dlu, top:40dlu:grow"));
        builder.setDefaultDialogBorder();
        builder.addLabel("Select actions for duplicated attributes:", cc.xy(1, 1));
        builder.add((Component)new JScrollPane(this.attributesTable), cc.xy(1, 3));
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.cancelButton);
        buttons.add(this.proceedButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.setSize(450, 350);
    }

    private void initController() {
        this.setDefaultCloseOperation(2);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                result = DuplicatedAttributesDialog.CANCEL_RESULT;
                DuplicatedAttributesDialog.this.setVisible(false);
                DuplicatedAttributesDialog.this.dispose();
            }
        });
        this.proceedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DuplicatedAttributesDialog.this.applyChanges();
                result = DuplicatedAttributesDialog.PROCEEDED_RESULT;
                DuplicatedAttributesDialog.this.setVisible(false);
                DuplicatedAttributesDialog.this.dispose();
            }
        });
    }

    public static String getResult() {
        return result;
    }

    private void updateTable() {
        TableColumn actionColumn = this.attributesTable.getColumnModel().getColumn(3);
        JComboBox actionsCombo = CayenneWidgetFactory.createComboBox(new String[]{DELETE_ACTION, RENAME_ACTION}, false);
        actionColumn.setCellEditor(CayenneWidgetFactory.createCellEditor(actionsCombo));
    }

    private void applyChanges() {
        for (DuplicatedAttributeInfo attributeInfo : this.duplicatedAttributes) {
            if (attributeInfo.getAction().equals(DELETE_ACTION)) {
                this.entity.removeAttribute(attributeInfo.getName());
            }
            if (!attributeInfo.getAction().equals(RENAME_ACTION)) continue;
            ProjectUtil.setAttributeName(this.entity.getAttribute(attributeInfo.getName()), attributeInfo.getNewName());
        }
    }

    public void setDuplicatedAttributes(List<ObjAttribute> attributes) {
        if (this.duplicatedAttributes == null) {
            this.duplicatedAttributes = new LinkedList<DuplicatedAttributeInfo>();
        }
        this.duplicatedAttributes.clear();
        for (ObjAttribute attribute : attributes) {
            DuplicatedAttributeInfo attributeInfo = new DuplicatedAttributeInfo(attribute.getName(), attribute.getType(), ((ObjAttribute)this.superEntity.getAttribute(attribute.getName())).getType(), DELETE_ACTION);
            this.duplicatedAttributes.add(attributeInfo);
        }
        this.attributesTable.setModel(new DuplicatedAttributeTableModel(this.getMediator(), this, this.duplicatedAttributes));
    }

    public void setSuperEntity(ObjEntity superEntity) {
        this.superEntity = superEntity;
    }

    public void setEntity(ObjEntity entity) {
        this.entity = entity;
    }

    static {
        result = CANCEL_RESULT;
    }

    public class DuplicatedAttributeInfo {
        private String name;
        private String newName;
        private String type;
        private String parentType;
        private String action;

        DuplicatedAttributeInfo(String name, String type, String parentType, String action) {
            this.name = name;
            this.newName = name;
            this.type = type;
            this.parentType = parentType;
            this.action = action;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getParentType() {
            return this.parentType;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DuplicatedAttributeTableModel
    extends CayenneTableModel {
        static final int ATTRIBUTE_NAME = 0;
        static final int PARENT_TYPE = 1;
        static final int TYPE = 2;
        static final int ACTION = 3;

        public DuplicatedAttributeTableModel(ProjectController mediator, Object eventSource, List objectList) {
            super(mediator, eventSource, objectList);
        }

        @Override
        public void setUpdatedValueAt(Object newValue, int row, int column) {
            DuplicatedAttributeInfo attributeInfo = DuplicatedAttributesDialog.this.duplicatedAttributes.get(row);
            if (column == 0) {
                attributeInfo.setNewName(newValue.toString());
                attributeInfo.setAction(DuplicatedAttributesDialog.RENAME_ACTION);
                this.fireTableDataChanged();
            }
            if (column == 3) {
                attributeInfo.setAction(newValue.toString());
            }
        }

        @Override
        public Class<?> getElementsClass() {
            return DuplicatedAttributeInfo.class;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DuplicatedAttributeInfo attributeInfo = DuplicatedAttributesDialog.this.duplicatedAttributes.get(row);
            switch (col) {
                case 0: {
                    return attributeInfo.getNewName();
                }
                case 1: {
                    return attributeInfo.getParentType();
                }
                case 2: {
                    return attributeInfo.getType();
                }
                case 3: {
                    return attributeInfo.getAction();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 3 || column == 0;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type in super entity";
                }
                case 2: {
                    return "Type";
                }
                case 3: {
                    return "Action";
                }
            }
            return " ";
        }

        public Class getColumnClass(int column) {
            return String.class;
        }
    }
}

