/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.modeler.action.CreateDataMapEntityListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerForDataMapAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateDataMapEntityListenerUndoableEdit
extends CayenneUndoableEdit {
    private DataMap dataMap;
    private EntityListener listener;

    public CreateDataMapEntityListenerUndoableEdit(DataMap dataMap, EntityListener listener) {
        this.dataMap = dataMap;
        this.listener = listener;
    }

    public String getPresentationName() {
        return "Create Entity Listener";
    }

    public void redo() throws CannotRedoException {
        CreateDataMapEntityListenerAction action = (CreateDataMapEntityListenerAction)this.actionManager.getAction(CreateDataMapEntityListenerAction.getActionName());
        action.createMapListener(this.dataMap, this.listener);
    }

    public void undo() throws CannotUndoException {
        RemoveEntityListenerForDataMapAction action = (RemoveEntityListenerForDataMapAction)this.actionManager.getAction(RemoveEntityListenerForDataMapAction.getActionName());
        action.removeEntityListener(this.dataMap, this.listener.getClassName());
    }
}

