/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import org.apache.commons.collections.ComparatorUtils;

public interface CollectionFactory {
    public static final CollectionFactory ARRAYLIST_FACTORY = new ArrayListFactory();
    public static final CollectionFactory LINKEDLIST_FACTORY = new LinkedListFactory();
    public static final CollectionFactory HASHSET_FACTORY = new HashSetFactory();
    public static final CollectionFactory TREESET_FACTORY = new TreeSetFactory();

    public Collection create();

    public Collection createSingleton(Object var1);

    public Collection createEmpty();

    public static class TreeSetFactory
    extends HashSetFactory {
        private Comparator comparator = ComparatorUtils.NATURAL_COMPARATOR;

        public TreeSetFactory() {
        }

        public TreeSetFactory(Comparator comparator) {
            this.comparator = comparator;
        }

        public Collection create() {
            return new TreeSet(this.comparator);
        }
    }

    public static class HashSetFactory
    implements CollectionFactory,
    Serializable {
        public Collection create() {
            return new HashSet();
        }

        public Collection createSingleton(Object contents) {
            return Collections.singleton(contents);
        }

        public Collection createEmpty() {
            return Collections.EMPTY_SET;
        }
    }

    public static class LinkedListFactory
    extends ArrayListFactory {
        public Collection create() {
            return new LinkedList();
        }
    }

    public static class ArrayListFactory
    implements CollectionFactory,
    Serializable {
        public Collection create() {
            return new ArrayList();
        }

        public Collection createSingleton(Object contents) {
            return Collections.singletonList(contents);
        }

        public Collection createEmpty() {
            return Collections.EMPTY_LIST;
        }
    }
}

