/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeakSet
implements Set {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$util$WeakSet == null ? (class$org$scopemvc$util$WeakSet = WeakSet.class$("org.scopemvc.util.WeakSet")) : class$org$scopemvc$util$WeakSet);
    private final Set contents = new HashSet();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    static /* synthetic */ Class class$org$scopemvc$util$WeakSet;

    public boolean isEmpty() {
        this.processQueue();
        return this.contents.isEmpty();
    }

    public boolean retainAll(Collection collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object object) {
        this.processQueue();
        return this.contents.contains(WeakEntry.create(object));
    }

    public Object[] toArray(Object[] objectArray) {
        this.processQueue();
        return this.getEntrySet().toArray(objectArray);
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        this.processQueue();
        return this.getEntrySet().toArray();
    }

    public Iterator iterator() {
        this.processQueue();
        return new WeakIterator();
    }

    public boolean remove(Object object) {
        return this.contents.remove(WeakEntry.create(object));
    }

    public void clear() {
        this.contents.clear();
    }

    public int hashCode() {
        this.processQueue();
        return this.contents.hashCode();
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    public int size() {
        this.processQueue();
        return this.contents.size();
    }

    public boolean containsAll(Collection collection) {
        this.processQueue();
        return this.getEntrySet().containsAll(collection);
    }

    public boolean add(Object object) {
        return this.contents.add(WeakEntry.create(object, this.referenceQueue));
    }

    public boolean equals(Object object) {
        this.processQueue();
        return this.contents.equals(object);
    }

    private final Set getEntrySet() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.contents.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    private final void processQueue() {
        Reference reference = null;
        while ((reference = this.referenceQueue.poll()) != null) {
            this.contents.remove(reference);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WeakIterator
    implements Iterator {
        private final Iterator iterator;
        private boolean gotNext;
        private boolean hasNext;
        private Object next;

        WeakIterator() {
            this.iterator = WeakSet.this.contents.iterator();
            this.gotNext = true;
            this.hasNext = false;
            this.next = null;
        }

        public boolean hasNext() {
            if (this.gotNext) {
                this.next = null;
                this.hasNext = false;
                while (this.iterator.hasNext()) {
                    Reference reference = (Reference)this.iterator.next();
                    if (reference != null) {
                        this.next = reference.get();
                        if (this.next == null) continue;
                        this.hasNext = true;
                        break;
                    }
                    this.hasNext = true;
                    break;
                }
            }
            this.gotNext = false;
            return this.hasNext;
        }

        public Object next() {
            if (this.hasNext()) {
                Object object = this.next;
                this.next = null;
                this.gotNext = true;
                return object;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            this.next = null;
            this.gotNext = true;
            this.iterator.remove();
        }
    }

    static class WeakEntry
    extends WeakReference {
        private final int hashCode;

        private WeakEntry(Object object) {
            super(object);
            this.hashCode = object.hashCode();
        }

        private WeakEntry(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hashCode = object.hashCode();
        }

        static WeakEntry create(Object object) {
            if (object != null) {
                return new WeakEntry(object);
            }
            return null;
        }

        static WeakEntry create(Object object, ReferenceQueue referenceQueue) {
            if (object != null) {
                return new WeakEntry(object, referenceQueue);
            }
            return null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof WeakEntry)) {
                return false;
            }
            Object t = this.get();
            Object t2 = ((WeakEntry)object).get();
            if (t == null || t2 == null) {
                return false;
            }
            if (t == t2) {
                return true;
            }
            return t.equals(t2);
        }
    }
}

