/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.View;

public final class AWTUtilities {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$awt$AWTUtilities == null ? (class$org$scopemvc$view$awt$AWTUtilities = AWTUtilities.class$("org.scopemvc.view.awt.AWTUtilities")) : class$org$scopemvc$view$awt$AWTUtilities);
    static /* synthetic */ Class class$org$scopemvc$view$awt$AWTUtilities;

    private AWTUtilities() {
    }

    public static View findControlIssuer(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof View && ((View)((Object)component2)).getController() != null) {
                return (View)((Object)component2);
            }
            component2 = component2.getParent();
        }
        if (LOG.isInfoEnabled()) {
            LOG.warn("findControlIssuer: no Control Issuer for component: " + component);
        }
        return null;
    }

    public static void centreOnScreen(Window window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        Rectangle rectangle = AWTUtilities.getCenteredBounds(window.getSize());
        window.setLocation(rectangle.x, rectangle.y);
    }

    public static void centreOnWindow(Window window, Window window2) {
        if (window == null) {
            throw new IllegalArgumentException("Can't centre on a null parent.");
        }
        if (window2 == null) {
            throw new IllegalArgumentException("Can't centre a null Window.");
        }
        Dimension dimension = window.getSize();
        Dimension dimension2 = window2.getSize();
        Point point = new Point(0, 0);
        if (window.isShowing()) {
            point = window.getLocationOnScreen();
        }
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        window2.setLocation(n, n2);
    }

    public static void fitOnScreen(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width, dimension.height);
        Dimension dimension3 = window.getSize();
        Point point = window.getLocation();
        if (LOG.isDebugEnabled()) {
            LOG.debug("fitOnScreen: screenSize: " + dimension2);
            LOG.debug("fitOnScreen: windowSize: " + dimension3);
            LOG.debug("fitOnScreen: windowLocation: " + point);
        }
        Dimension dimension4 = new Dimension(dimension3);
        Point point2 = new Point(point);
        if (point.x < 0) {
            point2.x = 0;
        }
        if (point.y < 0) {
            point2.y = 0;
        }
        if (point2.x + dimension3.width > dimension2.width) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("fitOnScreen: too wide");
            }
            point2.x = point.x - (point.x + dimension3.width - dimension2.width);
            if (LOG.isDebugEnabled()) {
                LOG.debug("fitOnScreen: reposition: location: " + point2);
            }
            if (point2.x < 0) {
                dimension4.width += point2.x;
                point2.x = 0;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("fitOnScreen: reposition: size: " + dimension4);
                }
            }
        }
        if (point2.y + dimension3.height > dimension2.height) {
            point2.y = point.y - (point.y + dimension3.height - dimension2.height);
            if (point2.y < 0) {
                dimension4.height += point2.y;
                point2.y = 0;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("fitOnScreen: newWindowSize: " + dimension4);
            LOG.debug("fitOnScreen: newWindowLocation: " + point2);
        }
        window.setSize(dimension4);
        window.setLocation(point2);
    }

    private static Rectangle getCenteredBounds(Dimension dimension) {
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension2.width / 2 - dimension.width / 2;
        int n2 = dimension2.height / 2 - dimension.height / 2;
        return new Rectangle(n, n2, dimension.width, dimension.height);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

