/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import javax.swing.JTable;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.PropertyManager;
import org.scopemvc.core.Selector;
import org.scopemvc.util.convertor.StringConvertor;
import org.scopemvc.view.swing.SAbstractListModel;
import org.scopemvc.view.swing.STable;
import org.scopemvc.view.swing.STextCellEditor;

public class STableModel
extends SAbstractListModel
implements TableModel {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$STableModel == null ? (class$org$scopemvc$view$swing$STableModel = STableModel.class$("org.scopemvc.view.swing.STableModel")) : class$org$scopemvc$view$swing$STableModel);
    private Selector[] columnSelectors;
    private String[] columnNames;
    private boolean[] columnsEditable;
    private PropertyManager itemsManager;
    private JTable table;
    static /* synthetic */ Class class$org$scopemvc$view$swing$STableModel;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$swing$event$TableModelListener;

    public STableModel(JTable jTable) {
        if (jTable == null) {
            throw new IllegalArgumentException("Cannot create a model for a null parent JTable");
        }
        this.table = jTable;
    }

    public int getRowCount() {
        int n = this.getSize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getRowCount: result: " + n);
        }
        return n;
    }

    public int getColumnCount() {
        if (this.columnSelectors == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getColumnCount: result: 0");
            }
            return 0;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getColumnCount: result: " + this.columnSelectors.length);
        }
        return this.columnSelectors.length;
    }

    public String getColumnName(int n) {
        if (this.columnNames == null || n >= this.columnNames.length) {
            return String.valueOf((char)(65 + n));
        }
        return this.columnNames[n];
    }

    public Class getColumnClass(int n) {
        PropertyManager propertyManager = this.getItemsManager();
        Object object = this.getElementAt(0);
        Selector selector = this.getColumnSelector(n);
        if (propertyManager == null || object == null || selector == null) {
            LOG.warn("getColumnClass: no manager or row or selector for column " + n);
            return class$java$lang$Object == null ? (class$java$lang$Object = STableModel.class$("java.lang.Object")) : class$java$lang$Object;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getColumnClass: " + propertyManager.getPropertyClass(object, selector));
            }
            return propertyManager.getPropertyClass(object, selector);
        }
        catch (Exception exception) {
            LOG.warn("getColumnClass: can't get class for " + n, exception);
            return class$java$lang$Object == null ? (class$java$lang$Object = STableModel.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.columnsEditable != null && n2 < this.columnsEditable.length && !this.columnsEditable[n2]) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("isCellEditable(" + n + "," + n2 + "): user forced to false");
            }
            return false;
        }
        Object object = this.getElementAt(n);
        PropertyManager propertyManager = this.getItemsManager();
        Selector selector = this.getColumnSelector(n2);
        if (propertyManager == null || object == null || selector == null) {
            LOG.warn("isCellEditable(" + n + "," + n2 + "): found no manager or row or selector");
            return false;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("isCellEditable(" + n + "," + n2 + "): property is read-only: " + propertyManager.isReadOnly(object, selector));
            }
            if (!propertyManager.isReadOnly(object, selector)) {
                Class clazz = propertyManager.getPropertyClass(object, selector);
                TableCellEditor tableCellEditor = this.table.getDefaultEditor(clazz);
                if (tableCellEditor instanceof STextCellEditor) {
                    StringConvertor stringConvertor = ((STextCellEditor)((Object)tableCellEditor)).getStringConvertor();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("isCellEditable(" + n + "," + n2 + "): string convertor is: " + stringConvertor + " for class: " + clazz);
                        LOG.debug("isCellEditable(" + n + "," + n2 + "): convertor supports stringAsValue: " + stringConvertor.supportsStringAsValue());
                    }
                    return stringConvertor.supportsStringAsValue();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("isCellEditable(" + n + "," + n2 + "): editor " + tableCellEditor.getClass() + " not recognized, assuming the cell is editable");
                }
                return true;
            }
        }
        catch (Exception exception) {
            LOG.warn("isCellEditable(" + n + "," + n2 + "): Unable " + "to find out if cell is editable. Return false.", exception);
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        Object object = this.getElementAt(n);
        Selector selector = this.getColumnSelector(n2);
        PropertyManager propertyManager = this.getItemsManager();
        if (propertyManager == null || object == null || selector == null) {
            LOG.warn("getValueAt(" + n + "," + n2 + "): found no manager or row or selector");
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getValueAt: " + propertyManager.get(object, selector) + "(" + propertyManager.get(object, selector).getClass() + ")");
            }
            return propertyManager.get(object, selector);
        }
        catch (Exception exception) {
            LOG.warn("Can't get column " + n2 + " from row " + n, exception);
            return null;
        }
    }

    public void setColumnSelectors(Selector[] selectorArray) {
        this.columnSelectors = selectorArray;
    }

    public void setColumnSelectors(String[] stringArray) {
        if (stringArray == null) {
            this.columnSelectors = null;
        }
        this.columnSelectors = new Selector[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new IllegalArgumentException("Can't create column for null Selector");
            }
            this.columnSelectors[n] = Selector.fromString(stringArray[n]);
            ++n;
        }
    }

    public void setColumnSelectorStrings(String[] stringArray) {
        this.setColumnSelectors(stringArray);
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public void setEditableColumns(boolean[] blArray) {
        this.columnsEditable = blArray;
    }

    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getElementAt(n);
        Selector selector = this.getColumnSelector(n2);
        PropertyManager propertyManager = this.getItemsManager();
        if (propertyManager == null || object2 == null || selector == null) {
            LOG.warn("setValueAt: no manager or row or selector");
        }
        try {
            propertyManager.set(object2, selector, object);
        }
        catch (Exception exception) {
            LOG.warn("Can't set column " + n2 + " from row " + n, exception);
        }
    }

    public void addListDataListener(ListDataListener listDataListener) {
        throw new UnsupportedOperationException("Can't add ListDataListener to STableModel");
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        throw new UnsupportedOperationException("Can't remove ListDataListener from STableModel");
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = STableModel.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = STableModel.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, tableModelListener);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 1));
    }

    public void fireTableRowsUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 0));
    }

    public void fireTableRowsDeleted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    public void fireTableCellUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TableModelListener == null ? STableModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) {
                ((TableModelListener)objectArray[n + 1]).tableChanged(tableModelEvent);
            }
            n -= 2;
        }
    }

    protected JTable getTable() {
        return this.table;
    }

    protected Selector getColumnSelector(int n) {
        if (this.columnSelectors == null) {
            return null;
        }
        return this.columnSelectors[n];
    }

    protected PropertyManager getItemsManager() {
        if (this.itemsManager == null && this.getRowCount() > 0) {
            Object object = this.getElementAt(0);
            this.itemsManager = PropertyManager.getInstance(object);
        }
        return this.itemsManager;
    }

    protected void setShownModel(Object object) {
        super.setShownModel(object);
        this.fireTableDataChanged();
        this.itemsManager = null;
        if (this.table instanceof STable) {
            ((STable)this.table).refreshSelection();
        } else {
            this.table.clearSelection();
        }
    }

    protected void fireContentsChanged(Object object, int n, int n2) {
        this.fireTableRowsUpdated(n, n2);
    }

    protected void fireIntervalAdded(Object object, int n, int n2) {
        this.fireTableRowsInserted(n, n2);
    }

    protected void fireIntervalRemoved(Object object, int n, int n2) {
        this.fireTableRowsDeleted(n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

