/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils2.BasicDynaClass;
import org.apache.commons.beanutils2.BenchBean;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PropertyUtilsBenchCase {
    private long counter = 100000L;
    private DynaClass dynaClass;
    private BenchBean inBean;
    private DynaBean inDyna;
    private Map<String, Object> inMap;
    private BenchBean outBean;
    private DynaBean outDyna;
    private PropertyUtilsBean pu;

    @BeforeEach
    public void setUp() throws Exception {
        String prop = System.getProperty("counter");
        if (prop != null) {
            this.counter = Long.parseLong(prop);
        }
        this.dynaClass = new BasicDynaClass("BenchDynaClass", null, new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("byteProperty", Byte.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringProperty", String.class)});
        this.inBean = new BenchBean();
        this.inMap = new HashMap<String, Object>();
        this.inMap.put("booleanProperty", this.inBean.getBooleanProperty());
        this.inMap.put("byteProperty", this.inBean.getByteProperty());
        this.inMap.put("doubleProperty", this.inBean.getDoubleProperty());
        this.inMap.put("floatProperty", Float.valueOf(this.inBean.getFloatProperty()));
        this.inMap.put("intProperty", this.inBean.getIntProperty());
        this.inMap.put("longProperty", this.inBean.getLongProperty());
        this.inMap.put("shortProperty", this.inBean.getShortProperty());
        this.inMap.put("stringProperty", this.inBean.getStringProperty());
        this.inDyna = this.dynaClass.newInstance();
        for (Map.Entry<String, Object> e : this.inMap.entrySet()) {
            this.inDyna.set(e.getKey(), e.getValue());
        }
        this.outBean = new BenchBean();
        this.outDyna = this.dynaClass.newInstance();
        this.inDyna = this.dynaClass.newInstance();
        for (Map.Entry<String, Object> e : this.inMap.entrySet()) {
            this.outDyna.set(e.getKey(), e.getValue());
        }
        this.pu = PropertyUtilsBean.getInstance();
    }

    @AfterEach
    public void tearDown() {
        this.dynaClass = null;
        this.inBean = null;
        this.inDyna = null;
        this.inMap = null;
        this.outBean = null;
        this.outDyna = null;
        this.pu = null;
    }

    @Test
    public void testCopyPropertiesBean() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outBean, (Object)this.inBean);
        }
        long startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outBean, (Object)this.inBean);
        }
        long stopMillis = System.currentTimeMillis();
        System.err.println("PU.copyProperties(bean,bean), count=" + this.counter + ", time=" + (stopMillis - startMillis));
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outDyna, (Object)this.inBean);
        }
        startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outDyna, (Object)this.inBean);
        }
        stopMillis = System.currentTimeMillis();
        System.err.println("PU.copyProperties(dyna,bean), count=" + this.counter + ", time=" + (stopMillis - startMillis));
    }

    @Test
    public void testCopyPropertiesDyna() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outBean, (Object)this.inDyna);
        }
        long startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outBean, (Object)this.inDyna);
        }
        long stopMillis = System.currentTimeMillis();
        System.err.println("PU.copyProperties(bean,dyna), count=" + this.counter + ", time=" + (stopMillis - startMillis));
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outDyna, (Object)this.inDyna);
        }
        startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outDyna, (Object)this.inDyna);
        }
        stopMillis = System.currentTimeMillis();
        System.err.println("PU.copyProperties(dyna,dyna), count=" + this.counter + ", time=" + (stopMillis - startMillis));
    }

    @Test
    public void testCopyPropertiesMap() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outBean, this.inMap);
        }
        long startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outBean, this.inMap);
        }
        long stopMillis = System.currentTimeMillis();
        System.err.println("PU.copyProperties(bean, map), count=" + this.counter + ", time=" + (stopMillis - startMillis));
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outDyna, this.inMap);
        }
        startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.pu.copyProperties((Object)this.outDyna, this.inMap);
        }
        stopMillis = System.currentTimeMillis();
        System.err.println("PU.copyProperties(dyna, map), count=" + this.counter + ", time=" + (stopMillis - startMillis));
    }
}

