/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils2.BasicDynaBean;
import org.apache.commons.beanutils2.BasicDynaClass;
import org.apache.commons.beanutils2.BenchBean;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.LazyDynaBean;
import org.apache.commons.beanutils2.LazyDynaList;
import org.apache.commons.beanutils2.LazyDynaMap;
import org.apache.commons.beanutils2.TestBean;
import org.apache.commons.beanutils2.WrapDynaBean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LazyDynaListTest {
    private static final String BASIC_PROP1 = "BasicDynaClass_Property1";
    private static final String BASIC_PROP2 = "BasicDynaClass_Property2";
    protected DynaProperty[] properties = new DynaProperty[]{new DynaProperty("BasicDynaClass_Property1", String.class), new DynaProperty("BasicDynaClass_Property2", HashMap.class)};
    protected DynaClass treeMapDynaClass = new LazyDynaMap(new TreeMap());
    protected DynaClass hashMapDynaClass = new LazyDynaMap(new HashMap());
    protected DynaClass pojoDynaClass = new WrapDynaBean((Object)new TestBean()).getDynaClass();
    protected DynaClass basicDynaClass = new BasicDynaClass("test", BasicDynaBean.class, this.properties);

    private void dynaBeanTest(LazyDynaList list, Class<?> testClass, DynaClass testDynaClass, Object wrongBean) throws IllegalAccessException, InstantiationException {
        Object dynaBean = list.get(1);
        Assertions.assertNotNull((Object)dynaBean, (String)"1. DynaBean Not Created");
        Assertions.assertEquals(testClass, dynaBean.getClass(), (String)"2. Wrong Type");
        Object[] array = list.toArray();
        Assertions.assertNotNull((Object)array, (String)"3. Array Not Created");
        Assertions.assertEquals(testClass, array.getClass().getComponentType(), (String)"4. Not DynaBean[]");
        DynaBean[] dynaArray = (DynaBean[])array;
        Assertions.assertEquals((int)2, (int)dynaArray.length, (String)"5. Array Size Wrong");
        dynaBean = list.get(3);
        Assertions.assertNotNull((Object)dynaBean, (String)"6. DynaBean Not Created");
        Assertions.assertEquals(testClass, dynaBean.getClass(), (String)"7. Wrong type");
        array = list.toArray();
        Assertions.assertNotNull((Object)array, (String)"8. Array Not Created");
        Assertions.assertEquals(testClass, array.getClass().getComponentType(), (String)"9. Not DynaBean[]");
        dynaArray = (DynaBean[])array;
        Assertions.assertEquals((int)4, (int)dynaArray.length, (String)"10. Array Size Wrong");
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.add(2, wrongBean));
        String testProperty = this.findStringProperty(testDynaClass);
        Assertions.assertNotNull((Object)testProperty, (String)"Test Property Not Found");
        dynaArray = list.toDynaBeanArray();
        for (int i = 0; i < dynaArray.length; ++i) {
            dynaArray[i].set(testProperty, (Object)("orig_pos" + i));
        }
        ArrayList<DynaBean> collection = new ArrayList<DynaBean>();
        collection.add(testDynaClass.newInstance());
        collection.add(testDynaClass.newInstance());
        collection.add(testDynaClass.newInstance());
        int expectedSize = dynaArray.length + collection.size();
        String origValue = (String)((DynaBean)collection.get(0)).get(testProperty);
        ((DynaBean)collection.get(0)).set(testProperty, (Object)(origValue + "_updated_" + 0));
        ((DynaBean)collection.get(1)).set(testProperty, (Object)(origValue + "_updated_" + 1));
        ((DynaBean)collection.get(2)).set(testProperty, (Object)(origValue + "_updated_" + 2));
        list.addAll(1, collection);
        dynaArray = list.toDynaBeanArray();
        dynaArray = list.toDynaBeanArray();
        Assertions.assertEquals((int)expectedSize, (int)dynaArray.length, (String)"11. Array Size Wrong");
        Assertions.assertEquals((Object)"orig_pos0", (Object)dynaArray[0].get(testProperty), (String)"12. Wrong Value");
        Assertions.assertEquals((Object)(origValue + "_updated_" + 0), (Object)dynaArray[1].get(testProperty), (String)"13. Wrong Value");
        Assertions.assertEquals((Object)(origValue + "_updated_" + 1), (Object)dynaArray[2].get(testProperty), (String)"14. Wrong Value");
        Assertions.assertEquals((Object)(origValue + "_updated_" + 2), (Object)dynaArray[3].get(testProperty), (String)"15. Wrong Value");
        Assertions.assertEquals((Object)"orig_pos1", (Object)dynaArray[4].get(testProperty), (String)"16. Wrong Value");
        DynaBean extraElement = testDynaClass.newInstance();
        extraElement.set(testProperty, (Object)"extraOne");
        list.add(2, (Object)extraElement);
        dynaArray = list.toDynaBeanArray();
        Assertions.assertEquals((Object)(origValue + "_updated_" + 0), (Object)dynaArray[1].get(testProperty), (String)"17. Wrong Value");
        Assertions.assertEquals((Object)"extraOne", (Object)dynaArray[2].get(testProperty), (String)"18. Wrong Value");
        Assertions.assertEquals((Object)(origValue + "_updated_" + 1), (Object)dynaArray[3].get(testProperty), (String)"19. Wrong Value");
    }

    private String findStringProperty(DynaClass dynaClass) {
        DynaProperty[] properties;
        for (DynaProperty property : properties = dynaClass.getDynaProperties()) {
            if (property.getType() != String.class) continue;
            return property.getName();
        }
        return null;
    }

    private void mapTest(LazyDynaList list, Class<?> testClass, Object wrongBean) {
        Object dynaBean = list.get(0);
        Assertions.assertNotNull((Object)dynaBean, (String)"1. DynaBean Not Created");
        Assertions.assertEquals(LazyDynaMap.class, dynaBean.getClass(), (String)"2. Not LazyDynaMap");
        Map map = ((LazyDynaMap)dynaBean).getMap();
        Assertions.assertNotNull((Object)map, (String)"3. Map Not Created");
        Assertions.assertEquals(testClass, map.getClass(), (String)"4. Wrong Map");
        Object[] array = list.toArray();
        Assertions.assertNotNull((Object)array, (String)"5. Array Not Created");
        Assertions.assertEquals(testClass, array.getClass().getComponentType(), (String)"6. Not Map[]");
        Map[] mapArray = (Map[])array;
        Assertions.assertEquals((int)1, (int)mapArray.length, (String)"7. Array Size Wrong");
        dynaBean = list.get(2);
        Assertions.assertNotNull((Object)dynaBean, (String)"8. DynaBean Not Created");
        Assertions.assertEquals(LazyDynaMap.class, dynaBean.getClass(), (String)"9. Not LazyDynaMap");
        map = ((LazyDynaMap)dynaBean).getMap();
        Assertions.assertNotNull((Object)map, (String)"10. Map Not Created");
        Assertions.assertEquals(testClass, map.getClass(), (String)"11. Wrong Map");
        array = list.toArray();
        Assertions.assertNotNull((Object)array, (String)"12. Array Not Created");
        Assertions.assertEquals(testClass, array.getClass().getComponentType(), (String)"13. Not Map[]");
        mapArray = (Map[])array;
        Assertions.assertEquals((int)3, (int)mapArray.length, (String)"14. Array Size Wrong");
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.add(2, wrongBean));
    }

    private void pojoTest(LazyDynaList list, Class<?> testClass, Object wrongBean) {
        Object dynaBean = list.get(0);
        Assertions.assertNotNull((Object)dynaBean, (String)"1. DynaBean Not Created");
        Assertions.assertEquals(WrapDynaBean.class, dynaBean.getClass(), (String)"2. Not WrapDynaBean");
        Object pojoBean = ((WrapDynaBean)dynaBean).getInstance();
        Assertions.assertNotNull((Object)pojoBean, (String)"3. POJO Not Created");
        Assertions.assertEquals(testClass, pojoBean.getClass(), (String)"4. Not WrapDynaBean");
        Object[] array = list.toArray();
        Assertions.assertNotNull((Object)array, (String)"5. Array Not Created");
        Assertions.assertEquals(testClass, array.getClass().getComponentType(), (String)"6. Wrong array");
        Object[] pojoArray = array;
        Assertions.assertEquals((int)1, (int)pojoArray.length, (String)"7. Array Size Wrong");
        dynaBean = list.get(1);
        Assertions.assertNotNull((Object)dynaBean, (String)"8. DynaBean Not Created");
        Assertions.assertEquals(WrapDynaBean.class, dynaBean.getClass(), (String)"9. Not WrapDynaBean");
        pojoBean = ((WrapDynaBean)dynaBean).getInstance();
        Assertions.assertNotNull((Object)pojoBean, (String)"10. POJO Not Created");
        Assertions.assertEquals(testClass, pojoBean.getClass(), (String)"11. Not WrapDynaBean");
        array = list.toArray();
        Assertions.assertNotNull((Object)array, (String)"12. Array Not Created");
        Assertions.assertEquals(testClass, array.getClass().getComponentType(), (String)"13. Wrong array");
        pojoArray = array;
        Assertions.assertEquals((int)2, (int)pojoArray.length, (String)"14. Array Size Wrong");
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.add(2, wrongBean));
    }

    private Object serializeDeserialize(Object target, String text) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(target);
            oos.flush();
        }
        Object result = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
             ObjectInputStream ois = new ObjectInputStream(bais);){
            result = ois.readObject();
        }
        return result;
    }

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() {
    }

    public void testCollection(LazyDynaList list, Class<?> testClass, DynaClass testDynaClass, Object wrongBean) {
        int i;
        int size = 5;
        ArrayList<TreeMap> testList = new ArrayList<TreeMap>(5);
        Object[] testArray = new TreeMap[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("prop" + i2, "val" + i2);
            testArray[i2] = map;
            testList.add(testArray[i2]);
        }
        LazyDynaList lazyList = new LazyDynaList(testList);
        Assertions.assertEquals((int)5, (int)lazyList.size(), (String)"1. check size");
        DynaBean[] dynaArray = lazyList.toDynaBeanArray();
        TreeMap[] mapArray = (TreeMap[])lazyList.toArray();
        Assertions.assertEquals((int)5, (int)dynaArray.length, (String)"2. check size");
        Assertions.assertEquals((int)5, (int)mapArray.length, (String)"3. check size");
        for (i = 0; i < 5; ++i) {
            Assertions.assertEquals((Object)("val" + i), (Object)dynaArray[i].get("prop" + i), (String)("4." + i + " DynaBean error "));
            Assertions.assertEquals((Object)("val" + i), mapArray[i].get("prop" + i), (String)("5." + i + " Map error "));
        }
        lazyList = new LazyDynaList(testArray);
        Assertions.assertEquals((int)5, (int)lazyList.size(), (String)"6. check size");
        dynaArray = lazyList.toDynaBeanArray();
        mapArray = (TreeMap[])lazyList.toArray();
        Assertions.assertEquals((int)5, (int)dynaArray.length, (String)"7. check size");
        Assertions.assertEquals((int)5, (int)mapArray.length, (String)"8. check size");
        for (i = 0; i < 5; ++i) {
            Assertions.assertEquals((Object)("val" + i), (Object)dynaArray[i].get("prop" + i), (String)("9." + i + " DynaBean error "));
            Assertions.assertEquals((Object)("val" + i), mapArray[i].get("prop" + i), (String)("10." + i + " Map error "));
        }
    }

    @Test
    public void testDynaBeanDynaClass() throws Exception {
        LazyDynaList list = new LazyDynaList(this.basicDynaClass);
        this.dynaBeanTest(list, BasicDynaBean.class, this.basicDynaClass, new BenchBean());
    }

    @Test
    public void testDynaBeanType() throws Exception {
        LazyDynaList list = new LazyDynaList(LazyDynaBean.class);
        LazyDynaBean bean = new LazyDynaBean();
        bean.set("prop1", (Object)"val");
        this.dynaBeanTest(list, LazyDynaBean.class, bean.getDynaClass(), new BenchBean());
    }

    @Test
    public void testMapDynaClass() {
        LazyDynaList list = new LazyDynaList(this.treeMapDynaClass);
        this.mapTest(list, TreeMap.class, new BenchBean());
    }

    @Test
    public void testMapType() {
        LazyDynaList list = new LazyDynaList(HashMap.class);
        this.mapTest(list, HashMap.class, new BenchBean());
    }

    @Test
    public void testNullType() {
        LazyDynaList lazyList = new LazyDynaList();
        lazyList.add(new HashMap());
    }

    @Test
    public void testPojoDynaClass() {
        LazyDynaList list = new LazyDynaList(this.pojoDynaClass);
        this.pojoTest(list, TestBean.class, new BenchBean());
    }

    @Test
    public void testPojoType() {
        LazyDynaList list = new LazyDynaList(TestBean.class);
        this.pojoTest(list, TestBean.class, new BenchBean());
    }

    @Test
    public void testSerializationDynaBean() throws Exception {
        LazyDynaList target = new LazyDynaList(this.basicDynaClass);
        BasicDynaBean bean = (BasicDynaBean)target.get(0);
        Assertions.assertNull((Object)bean.get(BASIC_PROP1), (String)"pre-set check");
        bean.set(BASIC_PROP1, (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)bean.get(BASIC_PROP1), (String)"post-set check");
        Assertions.assertThrows(NotSerializableException.class, () -> this.serializeDeserialize(target, "DynaBean"));
    }

    @Test
    public void testSerializationLazyDynaBean() throws Exception {
        LazyDynaList target = new LazyDynaList();
        LazyDynaBean bean = (LazyDynaBean)target.get(0);
        Assertions.assertNull((Object)bean.get(BASIC_PROP1), (String)"pre-set check");
        bean.set(BASIC_PROP1, (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)bean.get(BASIC_PROP1), (String)"post-set check");
        Assertions.assertThrows(NotSerializableException.class, () -> this.serializeDeserialize(target, "DynaBean"));
    }

    @Test
    public void testSerializationMap() throws Exception {
        LazyDynaList target = new LazyDynaList(this.treeMapDynaClass);
        LazyDynaMap bean = (LazyDynaMap)target.get(0);
        Assertions.assertNull((Object)bean.get(BASIC_PROP1), (String)"pre-set check");
        bean.set(BASIC_PROP1, (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)bean.get(BASIC_PROP1), (String)"post-set check");
        Assertions.assertThrows(NotSerializableException.class, () -> this.serializeDeserialize(target, "Map"));
    }

    @Test
    public void testSerializationPojo() throws Exception {
        LazyDynaList target = new LazyDynaList(this.pojoDynaClass);
        WrapDynaBean bean = (WrapDynaBean)target.get(0);
        Assertions.assertEquals((Object)"This is a string", (Object)bean.get("stringProperty"), (String)"pre-set check");
        bean.set("stringProperty", (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)bean.get("stringProperty"), (String)"post-set check");
        Assertions.assertThrows(NotSerializableException.class, () -> this.serializeDeserialize(target, "POJO"));
    }

    @Test
    public void testToArrayDynaBeans() {
        LazyDynaList list = new LazyDynaList(LazyDynaBean.class);
        LazyDynaBean elem = new LazyDynaBean();
        list.add((Object)elem);
        Object[] beans = new LazyDynaBean[1];
        Assertions.assertSame((Object)beans, (Object)list.toArray(beans), (String)"Wrong array");
        Assertions.assertSame((Object)elem, (Object)beans[0], (String)"Wrong element");
    }

    @Test
    public void testToArrayMapType() {
        LazyDynaList list = new LazyDynaList(HashMap.class);
        HashMap elem = new HashMap();
        list.add(elem);
        Object[] array = new Map[1];
        Assertions.assertSame((Object)array, (Object)list.toArray(array), (String)"Wrong array");
        Assertions.assertEquals(elem, (Object)array[0], (String)"Wrong element");
    }

    @Test
    public void testToArrayOtherType() {
        LazyDynaList list = new LazyDynaList(TestBean.class);
        TestBean elem = new TestBean();
        list.add((Object)elem);
        Object[] array = new TestBean[1];
        Assertions.assertSame((Object)array, (Object)list.toArray(array), (String)"Wrong array");
        Assertions.assertEquals((Object)elem, (Object)array[0], (String)"Wrong element");
    }

    @Test
    public void testToArrayUnsufficientSize() {
        LazyDynaList list = new LazyDynaList(LazyDynaBean.class);
        LazyDynaBean elem = new LazyDynaBean();
        list.add((Object)elem);
        LazyDynaBean[] array = (LazyDynaBean[])list.toArray((Object[])LazyDynaBean.EMPTY_ARRAY);
        Assertions.assertEquals((int)1, (int)array.length, (String)"Wrong array size");
        Assertions.assertEquals((Object)elem, (Object)array[0], (String)"Wrong element");
    }
}

