/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.beans.IntrospectionException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.beanutils2.MappedPropertyDescriptor;
import org.apache.commons.beanutils2.memoryleaktests.MemoryLeakTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Jira347Test {
    private static URLClassLoader newClassLoader() throws MalformedURLException {
        String dataFilePath = MemoryLeakTest.class.getResource("pojotests").getFile();
        String location = "file://" + dataFilePath.substring(0, dataFilePath.length() - "org.apache.commons.beanutils2.memoryleaktests.pojotests".length());
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < location.length(); ++i) {
            if (location.charAt(i) == '\\') {
                newString.append("/");
                continue;
            }
            newString.append(location.charAt(i));
        }
        String classLocation = newString.toString();
        URLClassLoader theLoader = URLClassLoader.newInstance(new URL[]{new URL(classLocation)}, null);
        return theLoader;
    }

    private void forceGarbageCollection() throws Exception {
        SoftReference<Object> ref = new SoftReference<Object>(new Object());
        int count = 0;
        while (ref.get() != null && count++ < 5) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                long i = 0L;
                while (ref.get() != null) {
                    list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            list.clear();
            list = null;
            System.gc();
            Thread.sleep(1000L);
        }
        if (ref.get() != null) {
            throw new IllegalStateException("Your JVM is not releasing SoftReference, try running the test with less memory (-Xmx)");
        }
    }

    private String getMappedWriteMethod(MappedPropertyDescriptor descriptor) {
        Method m = descriptor.getMappedWriteMethod();
        return Objects.toString(m, null);
    }

    @Test
    public void testMappedPropertyDescriptor_AnyArgsProperty() throws Exception {
        String className = "org.apache.commons.beanutils2.MappedPropertyTestBean";
        try (URLClassLoader loader = Jira347Test.newClassLoader();){
            Class<?> beanClass = loader.loadClass("org.apache.commons.beanutils2.MappedPropertyTestBean");
            beanClass.newInstance();
            Assertions.assertNotNull((Object)loader, (String)"ClassLoader is null");
            Assertions.assertNotNull(beanClass, (String)"BeanClass is null");
            Assertions.assertNotSame((Object)this.getClass().getClassLoader(), (Object)beanClass.getClassLoader(), (String)"ClassLoaders should be different..");
            Assertions.assertSame((Object)beanClass.getClassLoader(), (Object)loader, (String)"BeanClass ClassLoader incorrect");
            MappedPropertyDescriptor descriptor = null;
            try {
                descriptor = new MappedPropertyDescriptor("anyMapped", beanClass);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            if (descriptor != null) {
                String m1 = this.getMappedWriteMethod(descriptor);
                this.forceGarbageCollection();
                try {
                    String m2 = this.getMappedWriteMethod(descriptor);
                    Assertions.assertEquals((Object)m1, (Object)m2, (String)"Method returned post garbage collection differs from Method returned prior to gc");
                }
                catch (RuntimeException e) {
                    Assertions.fail((String)("getMappedWriteMethod threw an exception after garbage collection " + e));
                }
            }
        }
    }
}

