/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationErrorListenerImpl;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.DynamicCombinedConfiguration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.FileOptionsProvider;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.TestDefaultConfigurationBuilder;
import org.apache.commons.configuration.VFSFileSystem;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.XMLPropertiesConfiguration;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.BeanHelper;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestWebdavConfigurationBuilder
implements FileOptionsProvider,
ConfigurationListener {
    private static final String TEST_FILE = "testDigesterConfiguration.xml";
    private static final String ADDITIONAL_FILE = "testDigesterConfiguration2.xml";
    private static final String OPTIONAL_FILE = "testDigesterOptionalConfiguration.xml";
    private static final String OPTIONALEX_FILE = "testDigesterOptionalConfigurationEx.xml";
    private static final String MULTI_FILE = "testDigesterConfiguration3.xml";
    private static final String INIT_FILE = "testComplexInitialization.xml";
    private static final String CLASS_FILE = "testExtendedClass.xml";
    private static final String PROVIDER_FILE = "testConfigurationProvider.xml";
    private static final String EXTENDED_PROVIDER_FILE = "testExtendedXMLConfigurationProvider.xml";
    private static final String GLOBAL_LOOKUP_FILE = "testGlobalLookup.xml";
    private static final String SYSTEM_PROPS_FILE = "testSystemProperties.xml";
    private static final String VALIDATION_FILE = "testValidation.xml";
    private static final String MULTI_TENENT_FILE = "testMultiTenentConfigurationBuilder.xml";
    private static final String FILERELOAD2_FILE = "testFileReloadConfigurationBuilder2.xml";
    private static final String FILERELOAD_1001_FILE = "testwrite/testMultiConfiguration_1001.xml";
    private static final String FILERELOAD_1002_FILE = "testwrite/testMultiConfiguration_1002.xml";
    private static final String TEST_PROPERTIES = "test.properties.xml";
    private static final String TEST_SAVE = "testsave.xml";
    private static final String OPTIONAL_NAME = "optionalConfig";
    private Map<String, Object> options;
    private boolean configChanged = false;
    DefaultConfigurationBuilder factory;

    private String getBasePath() {
        String path = System.getProperty("test.webdav.base");
        Assert.assertNotNull((String)"No base url provided", (Object)path);
        return path;
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", "org.apache.commons.configuration.MockInitialContextFactory");
        System.setProperty("test_file_xml", "test.xml");
        System.setProperty("test_file_combine", "testcombine1.xml");
        System.setProperty("basePath", this.getBasePath());
        VFSFileSystem fs = new VFSFileSystem();
        fs.setFileOptionsProvider((FileOptionsProvider)this);
        FileSystem.setDefaultFileSystem((FileSystem)fs);
        this.factory = new DefaultConfigurationBuilder();
        this.factory.setBasePath(this.getBasePath());
        this.factory.clearErrorListeners();
    }

    @After
    public void tearDown() throws Exception {
        FileSystem.resetDefaultFileSystem();
    }

    @Test
    public void testConfigurationDeclarationIsReserved() {
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory);
        DefaultConfigurationNode parent = new DefaultConfigurationNode();
        DefaultConfigurationNode nd = new DefaultConfigurationNode("at");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)"Attribute at not recognized", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("optional");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)"Attribute optional not recognized", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("config-class");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)"Inherited attribute not recognized", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("different");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertFalse((String)"Wrong reserved attribute", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("at");
        parent.addChild((ConfigurationNode)nd);
        Assert.assertFalse((String)"Node type not evaluated", (boolean)decl.isReservedNode((ConfigurationNode)nd));
    }

    @Test
    public void testConfigurationDeclarationIsReservedAt() {
        this.checkOldReservedAttribute("at");
    }

    @Test
    public void testConfigurationDeclarationIsReservedOptional() {
        this.checkOldReservedAttribute("optional");
    }

    private void checkOldReservedAttribute(String name) {
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory);
        DefaultConfigurationNode parent = new DefaultConfigurationNode();
        DefaultConfigurationNode nd = new DefaultConfigurationNode("config-" + name);
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)("config-" + name + " attribute not recognized"), (boolean)decl.isReservedNode((ConfigurationNode)nd));
        DefaultConfigurationNode nd2 = new DefaultConfigurationNode(name);
        parent.addAttribute((ConfigurationNode)nd2);
        Assert.assertFalse((String)(name + " is reserved though config- exists"), (boolean)decl.isReservedNode((ConfigurationNode)nd2));
        Assert.assertTrue((String)("config- attribute not recognized when " + name + " exists"), (boolean)decl.isReservedNode((ConfigurationNode)nd));
    }

    @Test
    public void testConfigurationDeclarationGetAttributes() {
        this.factory.addProperty("xml.fileName", (Object)"test.xml");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("xml"));
        Assert.assertNull((String)"Found an at attribute", (Object)decl.getAt());
        Assert.assertFalse((String)"Found an optional attribute", (boolean)decl.isOptional());
        this.factory.addProperty("xml[@config-at]", (Object)"test1");
        Assert.assertEquals((String)"Wrong value of at attribute", (Object)"test1", (Object)decl.getAt());
        this.factory.addProperty("xml[@at]", (Object)"test2");
        Assert.assertEquals((String)"Wrong value of config-at attribute", (Object)"test1", (Object)decl.getAt());
        this.factory.clearProperty("xml[@config-at]");
        Assert.assertEquals((String)"Old at attribute not detected", (Object)"test2", (Object)decl.getAt());
        this.factory.addProperty("xml[@config-optional]", (Object)"true");
        Assert.assertTrue((String)"Wrong value of optional attribute", (boolean)decl.isOptional());
        this.factory.addProperty("xml[@optional]", (Object)"false");
        Assert.assertTrue((String)"Wrong value of config-optional attribute", (boolean)decl.isOptional());
        this.factory.clearProperty("xml[@config-optional]");
        this.factory.setProperty("xml[@optional]", (Object)Boolean.TRUE);
        Assert.assertTrue((String)"Old optional attribute not detected", (boolean)decl.isOptional());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationDeclarationOptionalAttributeInvalid() {
        this.factory.addProperty("xml.fileName", (Object)"test.xml");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("xml"));
        this.factory.setProperty("xml[@optional]", (Object)"invalid value");
        decl.isOptional();
    }

    @Test
    public void testAddConfigurationProvider() {
        DefaultConfigurationBuilder.ConfigurationProvider provider = new DefaultConfigurationBuilder.ConfigurationProvider();
        Assert.assertNull((String)"Provider already registered", (Object)this.factory.providerForTag("test"));
        this.factory.addConfigurationProvider("test", provider);
        Assert.assertSame((String)"Provider not registered", (Object)provider, (Object)this.factory.providerForTag("test"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConfigurationProviderNull() {
        this.factory.addConfigurationProvider("test", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConfigurationProviderNullTag() {
        this.factory.addConfigurationProvider(null, new DefaultConfigurationBuilder.ConfigurationProvider());
    }

    @Test
    public void testRemoveConfigurationProvider() {
        Assert.assertNull((String)"Removing unknown provider", (Object)this.factory.removeConfigurationProvider("test"));
        Assert.assertNull((String)"Removing provider for null tag", (Object)this.factory.removeConfigurationProvider(null));
        DefaultConfigurationBuilder.ConfigurationProvider provider = new DefaultConfigurationBuilder.ConfigurationProvider();
        this.factory.addConfigurationProvider("test", provider);
        Assert.assertSame((String)"Failed to remove provider", (Object)provider, (Object)this.factory.removeConfigurationProvider("test"));
        Assert.assertNull((String)"Provider still registered", (Object)this.factory.providerForTag("test"));
    }

    @Test
    public void testConfigurationBeanFactoryCreateBean() {
        this.factory.addConfigurationProvider("test", new DefaultConfigurationBuilder.ConfigurationProvider(PropertiesConfiguration.class));
        this.factory.addProperty("test[@throwExceptionOnMissing]", (Object)"true");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("test"));
        PropertiesConfiguration conf = (PropertiesConfiguration)BeanHelper.createBean((BeanDeclaration)decl);
        Assert.assertTrue((String)"Property was not initialized", (boolean)conf.isThrowExceptionOnMissing());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationBeanFactoryCreateUnknownTag() {
        this.factory.addProperty("test[@throwExceptionOnMissing]", (Object)"true");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("test"));
        BeanHelper.createBean((BeanDeclaration)decl);
    }

    @Test
    public void testLoadConfiguration() throws ConfigurationException {
        this.factory.setFileName(TEST_FILE);
        this.checkConfiguration();
    }

    @Test
    public void testLoadConfigurationFromFile() throws ConfigurationException {
        this.factory = new DefaultConfigurationBuilder(this.getBasePath() + TEST_FILE);
        this.checkConfiguration();
    }

    @Test
    public void testSaveConfiguration() throws ConfigurationException {
        this.options = new HashMap<String, Object>();
        this.options.put("versioning", Boolean.TRUE);
        this.options.put("currentUser", "TestUser");
        XMLConfiguration conf = new XMLConfiguration();
        conf.setFileName(this.getBasePath() + TEST_PROPERTIES);
        conf.load();
        conf.save(this.getBasePath() + TEST_SAVE);
        XMLConfiguration checkConfig = new XMLConfiguration();
        checkConfig.setFileName(this.getBasePath() + TEST_SAVE);
        this.checkSavedConfig(conf, (FileConfiguration)checkConfig);
        this.options = null;
    }

    private void checkConfiguration() throws ConfigurationException {
        CombinedConfiguration compositeConfiguration = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Number of configurations", (long)3L, (long)compositeConfiguration.getNumberOfConfigurations());
        Assert.assertEquals(PropertiesConfiguration.class, compositeConfiguration.getConfiguration(0).getClass());
        Assert.assertEquals(XMLPropertiesConfiguration.class, compositeConfiguration.getConfiguration(1).getClass());
        Assert.assertEquals(XMLConfiguration.class, compositeConfiguration.getConfiguration(2).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)compositeConfiguration.getConfiguration(0);
        Assert.assertNotNull((String)("Make sure we have a fileName: " + pc.getFileName()), (Object)pc.getFileName());
        this.checkProperties((Configuration)compositeConfiguration);
    }

    private void checkProperties(Configuration compositeConfiguration) {
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)compositeConfiguration.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"I'm complex!", (Object)compositeConfiguration.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((String)"property in the XMLPropertiesConfiguration", (Object)"value1", (Object)compositeConfiguration.getProperty("key1"));
    }

    @Test
    public void testLoadAdditional() throws ConfigurationException {
        this.factory.setFileName(ADDITIONAL_FILE);
        CombinedConfiguration compositeConfiguration = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (long)2L, (long)compositeConfiguration.getNumberOfConfigurations());
        Object prop = compositeConfiguration.getProperty("tables.table.name");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)3L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"users", (Object)compositeConfiguration.getProperty("tables.table(0).name"));
        Assert.assertEquals((Object)"documents", (Object)compositeConfiguration.getProperty("tables.table(1).name"));
        Assert.assertEquals((Object)"tasks", (Object)compositeConfiguration.getProperty("tables.table(2).name"));
        prop = compositeConfiguration.getProperty("tables.table.fields.field.name");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)17L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"smtp.mydomain.org", (Object)compositeConfiguration.getString("mail.host.smtp"));
        Assert.assertEquals((Object)"pop3.mydomain.org", (Object)compositeConfiguration.getString("mail.host.pop"));
        Assert.assertEquals((Object)"masterOfPost", (Object)compositeConfiguration.getString("mail.account.user"));
        Assert.assertEquals((Object)"topsecret", (Object)compositeConfiguration.getString("mail.account.psswd"));
        Assert.assertEquals((Object)"enhanced factory", (Object)compositeConfiguration.getString("test.configuration"));
    }

    @Test
    public void testLogErrorListener() {
        Assert.assertEquals((String)"No default error listener registered", (long)1L, (long)new DefaultConfigurationBuilder().getErrorListeners().size());
    }

    @Test
    public void testLoadOptional() throws Exception {
        this.factory.setFileName(OPTIONAL_FILE);
        Configuration config = this.factory.getConfiguration();
        Assert.assertTrue((boolean)config.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"value", (Object)config.getProperty("element"));
    }

    @Test
    public void testLoadOptionalErrorEvent() throws Exception {
        this.factory.clearErrorListeners();
        ConfigurationErrorListenerImpl listener = new ConfigurationErrorListenerImpl();
        this.factory.addErrorListener((ConfigurationErrorListener)listener);
        this.prepareOptionalTest("configuration", false);
        listener.verify(51, OPTIONAL_NAME, null);
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadOptionalWithException() throws ConfigurationException {
        this.factory.setFileName(OPTIONALEX_FILE);
        this.factory.getConfiguration();
    }

    @Test
    public void testLoadOptionalNonFileBased() throws ConfigurationException {
        CombinedConfiguration config = this.prepareOptionalTest("configuration", false);
        Assert.assertTrue((String)"Configuration not empty", (boolean)config.isEmpty());
        Assert.assertEquals((String)"Wrong number of configurations", (long)0L, (long)config.getNumberOfConfigurations());
    }

    @Test
    public void testLoadOptionalBuilderForceCreate() throws ConfigurationException {
        CombinedConfiguration config = this.prepareOptionalTest("configuration", true);
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Wrong optional configuration type", (boolean)(config.getConfiguration(OPTIONAL_NAME) instanceof CombinedConfiguration));
    }

    @Test
    public void testLoadOptionalForceCreateWithException() throws ConfigurationException {
        this.factory.addConfigurationProvider("test", (DefaultConfigurationBuilder.ConfigurationProvider)new DefaultConfigurationBuilder.ConfigurationBuilderProvider(){

            public AbstractConfiguration getEmptyConfiguration(DefaultConfigurationBuilder.ConfigurationDeclaration decl) throws Exception {
                throw new Exception("Unable to create configuration!");
            }
        });
        CombinedConfiguration config = this.prepareOptionalTest("test", true);
        Assert.assertEquals((String)"Optional configuration could be created", (long)0L, (long)config.getNumberOfConfigurations());
    }

    private CombinedConfiguration prepareOptionalTest(String tag, boolean force) throws ConfigurationException {
        String prefix = "override." + tag;
        this.factory.addProperty(prefix + "[@fileName]", (Object)"nonExisting.xml");
        this.factory.addProperty(prefix + "[@config-optional]", (Object)Boolean.TRUE);
        this.factory.addProperty(prefix + "[@config-name]", (Object)OPTIONAL_NAME);
        if (force) {
            this.factory.addProperty(prefix + "[@config-forceCreate]", (Object)Boolean.TRUE);
        }
        return this.factory.getConfiguration(false);
    }

    @Test
    public void testLoadDifferentSources() throws ConfigurationException {
        this.factory.setFileName(MULTI_FILE);
        Configuration config = this.factory.getConfiguration();
        Assert.assertFalse((boolean)config.isEmpty());
        Assert.assertTrue((boolean)(config instanceof CombinedConfiguration));
        CombinedConfiguration cc = (CombinedConfiguration)config;
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)cc.getNumberOfConfigurations());
        Assert.assertNotNull((Object)config.getProperty("tables.table(0).fields.field(2).name"));
        Assert.assertNotNull((Object)config.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((Object)"value", (Object)config.getProperty("element3"));
        Assert.assertEquals((Object)"foo", (Object)config.getProperty("element3[@name]"));
        Assert.assertNotNull((Object)config.getProperty("mail.account.user"));
        Assert.assertNotNull((Object)config.getProperty("test.onlyinjndi"));
        Assert.assertTrue((boolean)config.getBoolean("test.onlyinjndi"));
        Configuration subset = config.subset("test");
        Assert.assertNotNull((Object)subset.getProperty("onlyinjndi"));
        Assert.assertTrue((boolean)subset.getBoolean("onlyinjndi"));
        Assert.assertNotNull((Object)config.getProperty("java.version"));
        Assert.assertEquals((Object)System.getProperty("java.version"), (Object)config.getString("java.version"));
    }

    @Test
    public void testSetConfigurationBasePath() throws ConfigurationException {
        this.factory.addProperty("properties[@fileName]", (Object)"test.properties");
        File deepDir = new File("conf/config/deep");
        this.factory.setConfigurationBasePath(deepDir.getAbsolutePath());
        CombinedConfiguration config = this.factory.getConfiguration(false);
        Assert.assertEquals((String)"Wrong property value", (Object)"somevalue", (Object)config.getString("somekey"));
    }

    @Test
    public void testComplexInitialization() throws ConfigurationException {
        this.factory.setFileName(INIT_FILE);
        CombinedConfiguration cc = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"System property not found", (Object)"test.xml", (Object)cc.getString("test_file_xml"));
        PropertiesConfiguration c1 = (PropertiesConfiguration)cc.getConfiguration(1);
        Assert.assertTrue((String)"Reloading strategy was not set", (boolean)(c1.getReloadingStrategy() instanceof FileChangedReloadingStrategy));
        Assert.assertEquals((String)"Refresh delay was not set", (long)10000L, (long)((FileChangedReloadingStrategy)c1.getReloadingStrategy()).getRefreshDelay());
        Configuration xmlConf = cc.getConfiguration("xml");
        Assert.assertEquals((String)"Property not found", (Object)"I'm complex!", (Object)xmlConf.getString("element2/subelement/subsubelement"));
        Assert.assertEquals((String)"List index not found", (Object)"two", (Object)xmlConf.getString("list[0]/item[1]"));
        Assert.assertEquals((String)"Property in combiner file not found", (Object)"yellow", (Object)cc.getString("/gui/selcolor"));
        Assert.assertTrue((String)"Delimiter flag was not set", (boolean)cc.isDelimiterParsingDisabled());
        Assert.assertTrue((String)"Expression engine was not set", (boolean)(cc.getExpressionEngine() instanceof XPathExpressionEngine));
    }

    @Test
    public void testCombinedConfiguration() throws ConfigurationException {
        this.factory.setFileName(INIT_FILE);
        CombinedConfiguration cc = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertNotNull((String)"Properties configuration not found", (Object)cc.getConfiguration("properties"));
        Assert.assertNotNull((String)"XML configuration not found", (Object)cc.getConfiguration("xml"));
        Assert.assertEquals((String)"Wrong number of contained configs", (long)4L, (long)cc.getNumberOfConfigurations());
        CombinedConfiguration cc2 = (CombinedConfiguration)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME);
        Assert.assertNotNull((String)"No additional configuration found", (Object)cc2);
        Set names = cc2.getConfigurationNames();
        Assert.assertEquals((String)"Wrong number of contained additional configs", (long)2L, (long)names.size());
        Assert.assertTrue((String)"Config 1 not contained", (boolean)names.contains("combiner1"));
        Assert.assertTrue((String)"Config 2 not contained", (boolean)names.contains("combiner2"));
    }

    @Test
    public void testCombinedConfigurationNoAdditional() throws ConfigurationException {
        this.factory.setFileName(TEST_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        Assert.assertNull((String)"Additional configuration was found", (Object)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME));
    }

    @Test
    public void testCombinedConfigurationListNodes() throws ConfigurationException {
        this.factory.setFileName(INIT_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        Set listNodes = cc.getNodeCombiner().getListNodes();
        Assert.assertEquals((String)"Wrong number of list nodes", (long)2L, (long)listNodes.size());
        Assert.assertTrue((String)"table node not a list node", (boolean)listNodes.contains("table"));
        Assert.assertTrue((String)"list node not a list node", (boolean)listNodes.contains("list"));
        CombinedConfiguration cca = (CombinedConfiguration)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME);
        listNodes = cca.getNodeCombiner().getListNodes();
        Assert.assertTrue((String)"Found list nodes for additional combiner", (boolean)listNodes.isEmpty());
    }

    @Test
    public void testLoadXMLWithSettings() throws ConfigurationException, IOException {
        File confDir = new File("conf");
        File targetDir = new File("target");
        File testXMLSource = new File(confDir, "testDtd.xml");
        File testXMLValidationSource = new File(confDir, "testValidateInvalid.xml");
        File testSavedXML = new File(targetDir, "testSave.xml");
        File testSavedFactory = new File(targetDir, "testSaveFactory.xml");
        File dtdFile = new File(confDir, "properties.dtd");
        String publicId = "http://commons.apache.org/test.dtd";
        XMLConfiguration config = new XMLConfiguration(testXMLSource);
        config.setPublicID("http://commons.apache.org/test.dtd");
        config.save(testSavedXML);
        this.factory.addProperty("xml[@fileName]", (Object)testSavedXML.getAbsolutePath());
        this.factory.addProperty("xml(0)[@validating]", (Object)"true");
        this.factory.addProperty("xml(-1)[@fileName]", (Object)testXMLValidationSource.getAbsolutePath());
        this.factory.addProperty("xml(1)[@config-optional]", (Object)"true");
        this.factory.addProperty("xml(1)[@validating]", (Object)"true");
        this.factory.save(testSavedFactory);
        this.factory = new DefaultConfigurationBuilder();
        this.factory.setFile(testSavedFactory);
        this.factory.registerEntityId("http://commons.apache.org/test.dtd", dtdFile.toURI().toURL());
        this.factory.clearErrorListeners();
        Configuration c = this.factory.getConfiguration();
        Assert.assertEquals((String)"Wrong property value", (Object)"value1", (Object)c.getString("entry(0)"));
        Assert.assertFalse((String)"Invalid XML source was loaded", (boolean)c.containsKey("table.name"));
        testSavedXML.delete();
        testSavedFactory.delete();
    }

    @Test
    public void testExtendedClass() throws ConfigurationException {
        this.factory.setFileName(CLASS_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        String prop = (String)cc.getProperty("test");
        Assert.assertEquals((String)("Expected 'Extended', actual '" + prop + "'"), (Object)"Extended", (Object)prop);
        Assert.assertTrue((String)("Wrong result class: " + cc.getClass()), (boolean)(cc instanceof TestDefaultConfigurationBuilder.ExtendedCombinedConfiguration));
    }

    @Test
    public void testConfigurationProvider() throws ConfigurationException {
        this.factory.setFileName(PROVIDER_FILE);
        this.factory.getConfiguration(true);
        DefaultConfigurationBuilder.ConfigurationProvider provider = this.factory.providerForTag("test");
        Assert.assertNotNull((String)"Provider 'test' not registered", (Object)provider);
    }

    @Test
    public void testExtendedXMLConfigurationProvider() throws ConfigurationException {
        this.factory.setFileName(EXTENDED_PROVIDER_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        DefaultConfigurationBuilder.ConfigurationProvider provider = this.factory.providerForTag("test");
        Assert.assertNotNull((String)"Provider 'test' not registered", (Object)provider);
        Configuration config = cc.getConfiguration("xml");
        Assert.assertNotNull((String)"Test configuration not present", (Object)config);
        Assert.assertTrue((String)("Configuration is not ExtendedXMLConfiguration, is " + config.getClass().getName()), (boolean)(config instanceof TestDefaultConfigurationBuilder.ExtendedXMLConfiguration));
    }

    @Test
    public void testGlobalLookup() throws Exception {
        this.factory.setFileName(GLOBAL_LOOKUP_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        String value = cc.getInterpolator().lookup("test:test_key");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"test.value", (Object)value);
    }

    @Test
    public void testSystemProperties() throws Exception {
        this.factory.setFileName(SYSTEM_PROPS_FILE);
        this.factory.getConfiguration(true);
        String value = System.getProperty("key1");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"value1", (Object)value);
    }

    @Test
    public void testValidation() throws Exception {
        this.factory.setFileName(VALIDATION_FILE);
        this.factory.getConfiguration(true);
        String value = System.getProperty("key1");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"value1", (Object)value);
    }

    @Test
    public void testMultiTenentConfiguration() throws Exception {
        this.factory.setFileName(MULTI_TENENT_FILE);
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        this.verify("1005", config, 50);
    }

    @Test
    public void testMultiTenentConfiguration2() throws Exception {
        this.factory.setFileName(MULTI_TENENT_FILE);
        System.setProperty("Id", "1004");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        this.verify("1005", config, 50);
    }

    @Test
    public void testMultiTenentConfiguration3() throws Exception {
        this.factory.setFileName(MULTI_TENENT_FILE);
        System.setProperty("Id", "1005");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        this.verify("1005", config, 50);
    }

    @Test
    public void testFileChanged() throws Exception {
        File input = new File("target/test-classes/testMultiConfiguration_1001.xml");
        FileObject output = this.getFile(this.getBasePath() + FILERELOAD_1001_FILE);
        output.delete();
        output.getParent().createFolder();
        this.copyFile(input, output);
        this.factory.setFileName(this.getBasePath() + FILERELOAD2_FILE);
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertNotNull((Object)config);
        config.addConfigurationListener((ConfigurationListener)this);
        this.verify("1001", config, 15);
        Thread.sleep(1000L);
        XMLConfiguration x = new XMLConfiguration(this.getBasePath() + FILERELOAD_1001_FILE);
        x.setProperty("rowsPerPage", (Object)"50");
        x.save();
        this.waitForChange();
        this.verify("1001", config, 50);
        output.delete();
    }

    @Test
    public void testFileChanged2() throws Exception {
        File input = new File("target/test-classes/testMultiConfiguration_1002.xml");
        FileObject output = this.getFile(this.getBasePath() + FILERELOAD_1002_FILE);
        output.delete();
        this.factory.setFileName(this.getBasePath() + FILERELOAD2_FILE);
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertNotNull((Object)config);
        config.addConfigurationListener((ConfigurationListener)this);
        this.verify("1002", config, 50);
        Thread.sleep(1000L);
        output.getParent().createFolder();
        this.copyFile(input, output);
        this.waitForChange();
        this.verify("1002", config, 25);
        output.delete();
    }

    private void verify(String key, CombinedConfiguration config, int rows) {
        System.setProperty("Id", key);
        int actual = config.getInt("rowsPerPage");
        Assert.assertTrue((String)("expected: " + rows + " actual: " + actual), (actual == rows ? 1 : 0) != 0);
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    private void checkSavedConfig(XMLConfiguration conf, FileConfiguration newConfig) throws ConfigurationException {
        newConfig.load();
        ConfigurationAssert.assertEquals((Configuration)conf, (Configuration)newConfig);
    }

    private FileObject getFile(String fileName) throws Exception {
        FileSystemManager manager = VFS.getManager();
        FileName file = manager.resolveURI(fileName);
        FileName base = file.getParent();
        FileName path = manager.resolveName(base, file.getBaseName());
        FileSystemOptions opts = new FileSystemOptions();
        return manager.resolveFile(path.getURI(), opts);
    }

    private void copyFile(File input, FileObject output) throws IOException {
        FileReader reader = new FileReader(input);
        OutputStreamWriter writer = new OutputStreamWriter(output.getContent().getOutputStream());
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = reader.read(buffer))) {
            ((Writer)writer).write(buffer, 0, n);
        }
        ((Reader)reader).close();
        ((Writer)writer).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForChange() {
        TestWebdavConfigurationBuilder testWebdavConfigurationBuilder = this;
        synchronized (testWebdavConfigurationBuilder) {
            try {
                int count = 0;
                while (!this.configChanged && count++ <= 3) {
                    this.wait(5000L);
                }
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException("wait timed out");
            }
            finally {
                this.configChanged = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationChanged(ConfigurationEvent event) {
        if (event.getType() == 21) {
            TestWebdavConfigurationBuilder testWebdavConfigurationBuilder = this;
            synchronized (testWebdavConfigurationBuilder) {
                this.configChanged = true;
                this.notify();
            }
        }
    }
}

