/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.XMLPropertiesConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TestXMLPropertiesConfiguration {
    @Test
    public void testLoad() throws Exception {
        XMLPropertiesConfiguration conf = new XMLPropertiesConfiguration("test.properties.xml");
        Assert.assertEquals((String)"header", (Object)"Description of the property list", (Object)conf.getHeader());
        Assert.assertFalse((String)"The configuration is empty", (boolean)conf.isEmpty());
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf.getProperty("key1"));
        Assert.assertEquals((String)"'key2' property", (Object)"value2", (Object)conf.getProperty("key2"));
        Assert.assertEquals((String)"'key3' property", (Object)"value3", (Object)conf.getProperty("key3"));
    }

    @Test
    public void testDOMLoad() throws Exception {
        URL location = ConfigurationUtils.locate((FileSystem)FileSystem.getDefaultFileSystem(), null, (String)"test.properties.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        File file = new File(location.toURI());
        Document doc = dBuilder.parse(file);
        XMLPropertiesConfiguration conf = new XMLPropertiesConfiguration(doc.getDocumentElement());
        Assert.assertEquals((String)"header", (Object)"Description of the property list", (Object)conf.getHeader());
        Assert.assertFalse((String)"The configuration is empty", (boolean)conf.isEmpty());
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf.getProperty("key1"));
        Assert.assertEquals((String)"'key2' property", (Object)"value2", (Object)conf.getProperty("key2"));
        Assert.assertEquals((String)"'key3' property", (Object)"value3", (Object)conf.getProperty("key3"));
    }

    @Test
    public void testSave() throws Exception {
        XMLPropertiesConfiguration conf = new XMLPropertiesConfiguration("test.properties.xml");
        conf.addProperty("key4", (Object)"value4");
        conf.clearProperty("key2");
        conf.setHeader("Description of the new property list");
        File saveFile = new File("target/test2.properties.xml");
        if (saveFile.exists()) {
            Assert.assertTrue((boolean)saveFile.delete());
        }
        conf.save(saveFile);
        XMLPropertiesConfiguration conf2 = new XMLPropertiesConfiguration(saveFile);
        Assert.assertEquals((String)"header", (Object)"Description of the new property list", (Object)conf2.getHeader());
        Assert.assertFalse((String)"The configuration is empty", (boolean)conf2.isEmpty());
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf2.getProperty("key1"));
        Assert.assertEquals((String)"'key3' property", (Object)"value3", (Object)conf2.getProperty("key3"));
        Assert.assertEquals((String)"'key4' property", (Object)"value4", (Object)conf2.getProperty("key4"));
    }

    @Test
    public void testDOMSave() throws Exception {
        XMLPropertiesConfiguration conf = new XMLPropertiesConfiguration("test.properties.xml");
        conf.addProperty("key4", (Object)"value4");
        conf.clearProperty("key2");
        conf.setHeader("Description of the new property list");
        File saveFile = new File("target/test2.properties.xml");
        if (saveFile.exists()) {
            Assert.assertTrue((boolean)saveFile.delete());
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.newDocument();
        conf.save(document, (Node)document);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(saveFile);
        transformer.transform(source, result);
        XMLPropertiesConfiguration conf2 = new XMLPropertiesConfiguration(saveFile);
        Assert.assertEquals((String)"header", (Object)"Description of the new property list", (Object)conf2.getHeader());
        Assert.assertFalse((String)"The configuration is empty", (boolean)conf2.isEmpty());
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf2.getProperty("key1"));
        Assert.assertEquals((String)"'key3' property", (Object)"value3", (Object)conf2.getProperty("key3"));
        Assert.assertEquals((String)"'key4' property", (Object)"value4", (Object)conf2.getProperty("key4"));
    }
}

