/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.solvers;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math4.legacy.exception.NoBracketingException;
import org.apache.commons.math4.legacy.exception.NumberIsTooLargeException;
import org.apache.commons.math4.legacy.exception.TooManyEvaluationsException;

public class MullerSolver2
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public MullerSolver2() {
        this(1.0E-6);
    }

    public MullerSolver2(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public MullerSolver2(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    @Override
    protected double doSolve() throws TooManyEvaluationsException, NumberIsTooLargeException, NoBracketingException {
        double min = this.getMin();
        double max = this.getMax();
        this.verifyInterval(min, max);
        double relativeAccuracy = this.getRelativeAccuracy();
        double absoluteAccuracy = this.getAbsoluteAccuracy();
        double functionValueAccuracy = this.getFunctionValueAccuracy();
        double x0 = min;
        double y0 = this.computeObjectiveValue(x0);
        if (JdkMath.abs((double)y0) < functionValueAccuracy) {
            return x0;
        }
        double x1 = max;
        double y1 = this.computeObjectiveValue(x1);
        if (JdkMath.abs((double)y1) < functionValueAccuracy) {
            return x1;
        }
        if (y0 * y1 > 0.0) {
            throw new NoBracketingException(x0, x1, y0, y1);
        }
        double x2 = 0.5 * (x0 + x1);
        double y2 = this.computeObjectiveValue(x2);
        double oldx = Double.POSITIVE_INFINITY;
        while (true) {
            double x;
            double denominator;
            double c;
            double a;
            double q;
            double b;
            double delta;
            if ((delta = (b = (2.0 * (q = (x2 - x1) / (x1 - x0)) + 1.0) * y2 - (1.0 + q) * (1.0 + q) * y1 + q * q * y0) * b - 4.0 * (a = q * (y2 - (1.0 + q) * y1 + q * y0)) * (c = (1.0 + q) * y2)) >= 0.0) {
                double dplus = b + JdkMath.sqrt((double)delta);
                double dminus = b - JdkMath.sqrt((double)delta);
                denominator = JdkMath.abs((double)dplus) > JdkMath.abs((double)dminus) ? dplus : dminus;
            } else {
                denominator = JdkMath.sqrt((double)(b * b - delta));
            }
            if (denominator != 0.0) {
                for (x = x2 - 2.0 * c * (x2 - x1) / denominator; x == x1 || x == x2; x += absoluteAccuracy) {
                }
            } else {
                x = min + JdkMath.random() * (max - min);
                oldx = Double.POSITIVE_INFINITY;
            }
            double y = this.computeObjectiveValue(x);
            double tolerance = JdkMath.max((double)(relativeAccuracy * JdkMath.abs((double)x)), (double)absoluteAccuracy);
            if (JdkMath.abs((double)(x - oldx)) <= tolerance || JdkMath.abs((double)y) <= functionValueAccuracy) {
                return x;
            }
            x0 = x1;
            y0 = y1;
            x1 = x2;
            y1 = y2;
            x2 = x;
            y2 = y;
            oldx = x;
        }
    }
}

