/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.creadur.tentacles.FileSystem;
import org.apache.creadur.tentacles.Layout;
import org.apache.creadur.tentacles.License;
import org.apache.creadur.tentacles.Notice;

public class Archive {
    private final Layout layout;
    private final FileSystem fileSystem;
    private final URI uri;
    private final File file;
    private final Map<URI, URI> map;
    private final Set<License> licenses = new HashSet<License>();
    private final Set<Notice> notices = new HashSet<Notice>();
    private final Set<License> declaredLicenses = new HashSet<License>();
    private final Set<Notice> declaredNotices = new HashSet<Notice>();
    private final Set<License> otherLicenses = new HashSet<License>();
    private final Set<Notice> otherNotices = new HashSet<Notice>();
    private Map<URI, URI> others;

    public Archive(File file, FileSystem fileSystem, Layout layout) {
        this.fileSystem = fileSystem;
        this.layout = layout;
        this.uri = layout.getRepositoryDirectory().toURI().relativize(file.toURI());
        this.file = file;
        this.map = this.map();
    }

    public Set<License> getDeclaredLicenses() {
        return this.declaredLicenses;
    }

    public Set<Notice> getDeclaredNotices() {
        return this.declaredNotices;
    }

    public Set<License> getOtherLicenses() {
        return this.otherLicenses;
    }

    public Set<Notice> getOtherNotices() {
        return this.otherNotices;
    }

    public Set<License> getLicenses() {
        return this.licenses;
    }

    public Set<Notice> getNotices() {
        return this.notices;
    }

    public URI getUri() {
        return this.uri;
    }

    public File getFile() {
        return this.file;
    }

    public Map<URI, URI> getLegal() {
        return this.map;
    }

    public Map<URI, URI> getOtherLegal() {
        if (this.others == null) {
            this.others = this.mapOther();
        }
        return this.others;
    }

    private Map<URI, URI> mapOther() {
        File jarContents = this.contentsDirectory();
        List<File> legal = this.fileSystem.legalDocumentsUndeclaredIn(jarContents);
        return this.buildMapFrom(jarContents, legal);
    }

    private Map<URI, URI> buildMapFrom(File jarContents, List<File> legal) {
        LinkedHashMap<URI, URI> map = new LinkedHashMap<URI, URI>();
        for (File file : legal) {
            URI name = jarContents.toURI().relativize(file.toURI());
            URI link = this.layout.getLocalRootDirectory().toURI().relativize(file.toURI());
            map.put(name, link);
        }
        return map;
    }

    private Map<URI, URI> map() {
        File jarContents = this.contentsDirectory();
        List<File> legal = this.fileSystem.legalDocumentsDeclaredIn(jarContents);
        return this.buildMapFrom(jarContents, legal);
    }

    public File contentsDirectory() {
        File archiveDocument = this.getFile();
        String path = archiveDocument.getAbsolutePath().substring(this.layout.getLocalRootDirectory().getAbsolutePath().length() + 1);
        if (path.startsWith("repo/")) {
            path = path.substring("repo/".length());
        }
        if (path.startsWith("content/")) {
            path = path.substring("content/".length());
        }
        File contents = new File(this.layout.getContentRootDirectory(), path + ".contents");
        this.fileSystem.mkdirs(contents);
        return contents;
    }

    public URI contentsURI() {
        return this.contentsDirectory().toURI();
    }
}

