/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.generation;

import java.util.regex.Pattern;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

public class GeneratedLicenseNotRequired
implements IHeaderMatcher {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Pattern[] EMPTY_PATTERN_ARRAY = new Pattern[0];
    private static final String[] DEFAULT_PHRASES = new String[]{"generated by Cayenne", "Generated By:JJTree", "Generated By:JavaCC", "THIS FILE IS AUTOMATICALLY GENERATED", "NOTE: this file is autogenerated by XBeans", "This file was automatically generated by ", "# WARNING: DO NOT EDIT OR DELETE THIS WORKSPACE FILE!", "# Microsoft Developer Studio Generated NMAKE File", "# Microsoft Developer Studio Generated Build File", "Generated from configure.ac by autoheader", "generated automatically by aclocal", "build.xml generated by maven from project.xml", "This file was generated by", "This file has been automatically generated.", "Automatically generated - do not modify!", "Javadoc style sheet", "SOURCE FILE GENERATATED", "Generated by the Batik", "this file is autogenerated", "This class was autogenerated", "Generated by Maven", "Autogenerated by Thrift", "DO NOT EDIT THIS FILE - it is machine generated", "This class was generated by"};
    private final Pattern[] linePatterns;
    private final String[] phrases;

    public GeneratedLicenseNotRequired() {
        this(DEFAULT_PHRASES);
    }

    public GeneratedLicenseNotRequired(Pattern[] linePatterns) {
        this.linePatterns = linePatterns;
        this.phrases = EMPTY_STRING_ARRAY;
    }

    public GeneratedLicenseNotRequired(String[] lines) {
        this.linePatterns = EMPTY_PATTERN_ARRAY;
        this.phrases = lines;
    }

    public boolean match(Document subject, String line) throws RatHeaderAnalysisException {
        boolean result = false;
        for (Pattern pat : this.linePatterns) {
            if (!pat.matcher(line).matches()) continue;
            result = true;
            this.reportOnLicense(subject);
            break;
        }
        for (String phrase : this.phrases) {
            if (!line.contains(phrase)) continue;
            result = true;
            this.reportOnLicense(subject);
            break;
        }
        return result;
    }

    private void reportOnLicense(Document subject) {
        subject.getMetaData().set(MetaData.RAT_LICENSE_FAMILY_CATEGORY_DATUM_GEN);
    }

    public void reset() {
    }
}

