/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Compiler;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;

public class ClassUtils {
    protected static final Logger LOG = LogUtils.getL7dLogger(ClassUtils.class);

    public void compile(ToolContext context) throws ToolException {
        String javaClasspath;
        Compiler compiler = (Compiler)context.get("compiler");
        if (compiler == null) {
            compiler = new Compiler();
        }
        if (context.isVerbose()) {
            compiler.setVerbose(true);
        }
        compiler.setEncoding((String)context.get("encoding"));
        if (context.get("classdir") != null) {
            compiler.setOutputDir((String)context.get("classdir"));
        }
        if ((javaClasspath = System.getProperty("java.class.path")) != null) {
            if (context.get("outputdir") != null) {
                compiler.setClassPath(javaClasspath + File.pathSeparatorChar + context.get("outputdir"));
            } else {
                compiler.setClassPath(javaClasspath);
            }
        }
        String outPutDir = (String)context.get("outputdir");
        HashSet<String> dirSet = new HashSet<String>();
        ClassCollector classCollector = context.get(ClassCollector.class);
        ArrayList<String> fileList = new ArrayList<String>();
        for (String fileName : classCollector.getGeneratedFileInfo()) {
            File file;
            fileName = fileName.replace('.', File.separatorChar);
            String dirName = fileName.substring(0, fileName.lastIndexOf(File.separator) + 1);
            String path = outPutDir + File.separator + dirName;
            if (!dirSet.add(path) || !(file = new File(path)).isDirectory() || file.list() == null) continue;
            for (String str : file.list()) {
                if (str.endsWith("java")) {
                    fileList.add(path + str);
                    continue;
                }
                Path otherFile = Paths.get(path, str);
                String suffix = "xml";
                if (!Files.isReadable(otherFile) || !str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length()) || context.get("classdir") == null) continue;
                String targetDir = (String)context.get("classdir");
                try {
                    Files.copy(otherFile, Files.createDirectories(Paths.get(targetDir, dirName), new FileAttribute[0]).resolve(str), new CopyOption[0]);
                }
                catch (FileAlreadyExistsException existsException) {
                    LOG.log(Level.WARNING, "EXIST_RESOURCE_FILE", Paths.get(targetDir, dirName).resolve(str));
                }
                catch (IOException e) {
                    Message msg = new Message("FAIL_TO_COPY_GENERATED_RESOURCE_FILE", LOG, new Object[0]);
                    throw new ToolException(msg, (Throwable)e);
                }
            }
            File jaxbRuntime = new File(path, "runtime");
            if (!jaxbRuntime.isDirectory() || !jaxbRuntime.exists()) continue;
            List files = FileUtils.getFilesUsingSuffix((File)jaxbRuntime, (String)".java");
            files.forEach(f -> fileList.add(f.toString()));
        }
        if (!compiler.compileFiles(fileList.toArray(new String[0]))) {
            Message msg = new Message("FAIL_TO_COMPILE_GENERATE_CODES", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }
}

