/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.sso.AbstractSSOSpHandler;
import org.apache.cxf.rs.security.saml.sso.MetadataWriter;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.w3c.dom.Document;

@Path(value="metadata")
public class MetadataService
extends AbstractSSOSpHandler {
    protected static final Logger LOG = LogUtils.getL7dLogger(MetadataService.class);
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(MetadataService.class);
    private String serviceAddress;
    private String assertionConsumerServiceAddress;
    private String logoutServiceAddress;
    private boolean addEndpointAddressToContext;

    @GET
    @Produces(value={"text/xml"})
    public Document getMetadata() {
        try {
            MetadataWriter metadataWriter = new MetadataWriter();
            Crypto crypto = this.getSignatureCrypto();
            if (crypto == null) {
                LOG.fine("No crypto instance of properties file configured for signature");
                throw ExceptionUtils.toInternalServerErrorException(null, null);
            }
            String signatureUser = this.getSignatureUsername();
            if (signatureUser == null) {
                LOG.fine("No user configured for signature");
                throw ExceptionUtils.toInternalServerErrorException(null, null);
            }
            CallbackHandler callbackHandler = this.getCallbackHandler();
            if (callbackHandler == null) {
                LOG.fine("No CallbackHandler configured to supply a password for signature");
                throw ExceptionUtils.toInternalServerErrorException(null, null);
            }
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(signatureUser);
            X509Certificate[] issuerCerts = crypto.getX509Certificates(cryptoType);
            if (issuerCerts == null) {
                throw new Exception("No issuer certs were found to sign the request using name: " + signatureUser);
            }
            WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(signatureUser, 3)};
            callbackHandler.handle((Callback[])cb);
            String password = cb[0].getPassword();
            PrivateKey privateKey = crypto.getPrivateKey(signatureUser, password);
            if (this.addEndpointAddressToContext) {
                Message message = JAXRSUtils.getCurrentMessage();
                String rawPath = (String)message.get((Object)"http.base.path");
                return metadataWriter.getMetaData(rawPath + this.serviceAddress, rawPath + this.assertionConsumerServiceAddress, rawPath + this.logoutServiceAddress, privateKey, issuerCerts[0], true);
            }
            Document metadata = metadataWriter.getMetaData(this.serviceAddress, this.assertionConsumerServiceAddress, this.logoutServiceAddress, privateKey, issuerCerts[0], true);
            try {
                privateKey.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
            return metadata;
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, ex.getMessage(), ex);
            throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
        }
    }

    protected void reportError(String code) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(code, BUNDLE, new Object[0]);
        LOG.warning(errorMsg.toString());
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    public String getLogoutServiceAddress() {
        return this.logoutServiceAddress;
    }

    public void setLogoutServiceAddress(String logoutServiceAddress) {
        this.logoutServiceAddress = logoutServiceAddress;
    }

    public void setAddEndpointAddressToContext(boolean add) {
        this.addEndpointAddressToContext = add;
    }

    public String getAssertionConsumerServiceAddress() {
        return this.assertionConsumerServiceAddress;
    }

    public void setAssertionConsumerServiceAddress(String assertionConsumerServiceAddress) {
        this.assertionConsumerServiceAddress = assertionConsumerServiceAddress;
    }
}

