/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

public enum DisconnectReason {
    REDIRECT(0, false),
    REDIRECT_ON_CRITICAL_ERROR(1, true),
    SCALE_DOWN(2, false),
    SCALE_DOWN_ON_CRITICAL_ERROR(3, true),
    SHUT_DOWN(4, false),
    SHUT_DOWN_ON_CRITICAL_ERROR(5, true);

    private final byte type;
    private final boolean criticalError;

    private DisconnectReason(byte type, boolean criticalError) {
        this.type = type;
        this.criticalError = criticalError;
    }

    public byte getType() {
        return this.type;
    }

    public boolean isCriticalError() {
        return this.criticalError;
    }

    public boolean isRedirect() {
        return this == REDIRECT || this == REDIRECT_ON_CRITICAL_ERROR;
    }

    public boolean isScaleDown() {
        return this == SCALE_DOWN || this == SCALE_DOWN_ON_CRITICAL_ERROR;
    }

    public boolean isShutDown() {
        return this == SHUT_DOWN || this == SHUT_DOWN_ON_CRITICAL_ERROR;
    }

    public static DisconnectReason getType(byte type) {
        return switch (type) {
            case 0 -> REDIRECT;
            case 1 -> REDIRECT_ON_CRITICAL_ERROR;
            case 2 -> SCALE_DOWN;
            case 3 -> SCALE_DOWN_ON_CRITICAL_ERROR;
            case 4 -> SHUT_DOWN;
            case 5 -> SHUT_DOWN_ON_CRITICAL_ERROR;
            default -> null;
        };
    }
}

