/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.daffodil.io.RegexLimitingInputStream$;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class RegexLimitingInputStream
extends InputStream {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RegexLimitingInputStream.class.getDeclaredField("charsIter$lzy1"));
    private final InputStream in;
    private final Pattern pattern;
    private final int lookAheadMax;
    private volatile Object charsIter$lzy1;
    private boolean noMoreChunks;

    public static int $lessinit$greater$default$5() {
        return RegexLimitingInputStream$.MODULE$.$lessinit$greater$default$5();
    }

    public RegexLimitingInputStream(InputStream inputStream, String regexForDelimiter, String maximumLengthDelimiterExample, Charset charset, int targetChunkSize) {
        if (targetChunkSize < 1) {
            throw Assert$.MODULE$.usageError("RegexLimitingInputStream.this.targetChunkSize.>=(1)");
        }
        if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(maximumLengthDelimiterExample))) {
            throw Assert$.MODULE$.usageError("scala.Predef.augmentString(RegexLimitingInputStream.this.maximumLengthDelimiterExample).nonEmpty");
        }
        this.in = inputStream;
        String maxDelimiterIn8859 = new String(maximumLengthDelimiterExample.getBytes(charset), StandardCharsets.ISO_8859_1);
        int maxDelimiterLength = (int)package$.MODULE$.ceil(Float$.MODULE$.float2double((float)maxDelimiterIn8859.length() * charset.newEncoder().maxBytesPerChar()));
        int chunkSize = package$.MODULE$.max(targetChunkSize, maxDelimiterLength + 1);
        String regex = "([\\s\\S]{0," + chunkSize + "}?)(?=(" + regexForDelimiter + "))|([\\s\\S]{0," + chunkSize + "})";
        this.pattern = Pattern.compile(regex);
        this.lookAheadMax = chunkSize + maxDelimiterLength;
        this.noMoreChunks = false;
    }

    private Iterator<Object> charsIter() {
        Object object = this.charsIter$lzy1;
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Iterator)this.charsIter$lzyINIT1();
    }

    private Object charsIter$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.charsIter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Iterator iterator = null;
                    try {
                        Iterator iter;
                        LazyList<String> cks = this.chunks();
                        LazyList streamChars = cks.flatten((Function1 & Serializable)s -> Predef$.MODULE$.wrapString(s));
                        iterator = iter = streamChars.iterator();
                        object2 = iterator == null ? LazyVals.NullValue$.MODULE$ : iterator;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.charsIter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return iterator;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public int read() {
        if (!this.charsIter().hasNext()) {
            return -1;
        }
        return BoxesRunTime.unboxToChar((Object)this.charsIter().next());
    }

    @Override
    public int available() {
        if (this.charsIter().hasNext()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() {
    }

    private LazyList<String> chunks() {
        if (this.noMoreChunks) {
            return (LazyList)scala.package$.MODULE$.LazyList().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        this.in.mark(this.lookAheadMax);
        InputStreamReader rdr = new InputStreamReader(this.in, StandardCharsets.ISO_8859_1);
        Scanner scanner = new Scanner(rdr);
        String beforeMatchString = scanner.findWithinHorizon(this.pattern, 0);
        int delimMatchLength = this.checkScan(beforeMatchString, scanner);
        this.in.reset();
        this.in.skip(Int$.MODULE$.int2long(beforeMatchString.length() + delimMatchLength));
        if (delimMatchLength > 0) {
            this.noMoreChunks = true;
        }
        if (beforeMatchString.isEmpty()) {
            return (LazyList)scala.package$.MODULE$.LazyList().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        Function0 function0 = LazyList$.MODULE$.toDeferrer(this::chunks$$anonfun$1);
        return LazyList.Deferrer$.MODULE$.$hash$colon$colon$extension(function0, () -> RegexLimitingInputStream.chunks$$anonfun$2(beforeMatchString));
    }

    private int checkScan(String matchString, Scanner scanner) {
        int n;
        boolean isFound;
        if (matchString == null) {
            throw Assert$.MODULE$.abort("Invariant broken: matchString.ne(null)");
        }
        MatchResult matcher = scanner.match();
        int beforeDelimMatch = matcher.end(1);
        int delimMatch = matcher.end(2);
        int noDelimMatch = matcher.end(3);
        boolean bl = isFound = beforeDelimMatch > -1;
        if (isFound) {
            if (delimMatch <= -1) {
                throw Assert$.MODULE$.abort("Invariant broken: delimMatch.>(-1)");
            }
            if (noDelimMatch != -1) {
                throw Assert$.MODULE$.abort("Invariant broken: noDelimMatch.==(-1)");
            }
            n = matcher.end(2) - matcher.start(2);
        } else {
            if (delimMatch != -1) {
                throw Assert$.MODULE$.abort("Invariant broken: delimMatch.==(-1)");
            }
            if (noDelimMatch <= -1) {
                throw Assert$.MODULE$.abort("Invariant broken: noDelimMatch.>(-1)");
            }
            n = 0;
        }
        int delimMatchLength = n;
        return delimMatchLength;
    }

    private final LazyList chunks$$anonfun$1() {
        return this.chunks();
    }

    private static final String chunks$$anonfun$2(String beforeMatchString$1) {
        return beforeMatchString$1;
    }
}

