/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class StylesheetFunctionLibrary
implements FunctionLibrary {
    private final StylesheetPackage pack;
    private final boolean overrideExtensionFunction;
    private HashMap<StructuredQName, List<Component>> functionIndex = null;

    public StylesheetFunctionLibrary(StylesheetPackage sheet, boolean overrideExtensionFunction) {
        this.pack = sheet;
        this.overrideExtensionFunction = overrideExtensionFunction;
    }

    public boolean isOverrideExtensionFunction() {
        return this.overrideExtensionFunction;
    }

    public StylesheetPackage getStylesheetPackage() {
        return this.pack;
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) throws XPathException {
        Component c = this.getFunction(functionName.getComponentName(), staticArgs.length);
        if (c == null) {
            return null;
        }
        UserFunction fn = (UserFunction)c.getActor();
        fn.incrementReferenceCount();
        if (fn.isOverrideExtensionFunction() != this.overrideExtensionFunction) {
            return null;
        }
        UserFunctionCall fc = new UserFunctionCall();
        fc.setFunction(fn);
        fc.setFunctionName(fn.getFunctionName());
        int maxArity = fn.getArity();
        if (staticArgs.length == maxArity && (keywords == null || keywords.isEmpty())) {
            fc.setArguments(staticArgs);
        } else {
            Expression[] expandedArgs = UserFunction.makeExpandedArgumentArray(staticArgs, keywords, fn);
            fc.setArguments(expandedArgs);
        }
        if (env instanceof ExpressionContext) {
            PrincipalStylesheetModule psm = ((ExpressionContext)env).getStyleElement().getCompilation().getPrincipalStylesheetModule();
            ExpressionVisitor visitor = ExpressionVisitor.make(env);
            psm.addFixupAction(() -> {
                if (fc.getFunction() == null) {
                    Component target = psm.getComponent(fc.getSymbolicName());
                    UserFunction fn1 = (UserFunction)target.getActor();
                    if (fn1 != null) {
                        fc.allocateArgumentEvaluators();
                        fc.setStaticType(fn1.getResultType());
                    } else {
                        XPathException err = new XPathException("There is no available function named " + fc.getDisplayName() + " with " + fc.getArity() + " arguments", "XPST0017");
                        err.setLocator(fc.getLocation());
                        throw err;
                    }
                }
            });
        }
        return fc;
    }

    private void buildFunctionIndex() {
        HashMap<SymbolicName, Component> allComponents = this.pack.getComponentIndex();
        this.functionIndex = new HashMap();
        for (Map.Entry<SymbolicName, Component> entry : allComponents.entrySet()) {
            if (entry.getValue().getComponentKind() != 160) continue;
            UserFunction uf = (UserFunction)entry.getValue().getActor();
            StructuredQName functionName = entry.getKey().getComponentName();
            if (this.functionIndex.containsKey(functionName)) {
                this.functionIndex.get(functionName).add(entry.getValue());
                continue;
            }
            ArrayList<Component> functionList = new ArrayList<Component>();
            functionList.add(entry.getValue());
            this.functionIndex.put(functionName, functionList);
        }
    }

    private Component getFunction(StructuredQName name, int actualArgs) {
        List<Component> candidates;
        if (this.functionIndex == null) {
            this.buildFunctionIndex();
        }
        if ((candidates = this.functionIndex.get(name)) == null) {
            return null;
        }
        for (Component c : candidates) {
            UserFunction fn = (UserFunction)c.getActor();
            if (fn.getMinimumArity() > actualArgs || fn.getArity() < actualArgs) continue;
            return c;
        }
        return null;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        return this.pack.getFunction(functionName);
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        return this.pack.getFunction(functionName) != null;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }
}

