/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAnalyzeString;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.trans.XPathException;

public class XSLMatchingSubstring
extends StyleElement {
    private Expression select = null;

    @Override
    protected void prepareAttributes() {
        for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String value = att.getValue();
            String f = attName.getDisplayName();
            if (f.equals("select")) {
                if (!this.requireXslt40Attribute("select")) continue;
                this.select = this.makeExpression(value, att);
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        if (!(this.getParent() instanceof XSLAnalyzeString)) {
            this.compileError(this.getDisplayName() + " must be immediately within xsl:analyze-string", "XTSE0010");
        }
        if (this.select != null) {
            for (NodeInfo nodeInfo : this.children()) {
                if (nodeInfo instanceof XSLFallback) continue;
                if (this.select == null) break;
                this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", "XTSE3185");
                break;
            }
            this.select = this.typeCheck("select", this.select);
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        throw new UnsupportedOperationException("XSLMatchingSubstring#compile() should not be called");
    }
}

