/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tdigest;

import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tdigest.TDigestDouble;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TDigestDoubleTest {
    @Test
    public void empty() {
        TDigestDouble td = new TDigestDouble(100);
        Assert.assertTrue((boolean)td.isEmpty());
        Assert.assertEquals((int)td.getK(), (int)100);
        Assert.assertEquals((long)td.getTotalWeight(), (long)0L);
        Assert.assertThrows(SketchesStateException.class, () -> td.getMinValue());
        Assert.assertThrows(SketchesStateException.class, () -> td.getMaxValue());
        Assert.assertThrows(SketchesStateException.class, () -> td.getRank(0.0));
        Assert.assertThrows(SketchesStateException.class, () -> td.getQuantile(0.5));
        Assert.assertThrows(SketchesStateException.class, () -> td.getPMF(new double[]{0.0}));
        Assert.assertThrows(SketchesStateException.class, () -> td.getCDF(new double[]{0.0}));
    }

    @Test
    public void oneValue() {
        TDigestDouble td = new TDigestDouble();
        td.update(1.0);
        Assert.assertFalse((boolean)td.isEmpty());
        Assert.assertEquals((int)td.getK(), (int)200);
        Assert.assertEquals((long)td.getTotalWeight(), (long)1L);
        Assert.assertEquals((double)td.getMinValue(), (double)1.0);
        Assert.assertEquals((double)td.getMaxValue(), (double)1.0);
        Assert.assertEquals((double)td.getRank(0.99), (double)0.0);
        Assert.assertEquals((double)td.getRank(1.0), (double)0.5);
        Assert.assertEquals((double)td.getRank(1.01), (double)1.0);
        Assert.assertEquals((double)td.getQuantile(0.0), (double)1.0);
        Assert.assertEquals((double)td.getQuantile(0.5), (double)1.0);
        Assert.assertEquals((double)td.getQuantile(1.0), (double)1.0);
    }

    @Test
    public void manyValues() {
        TDigestDouble td = new TDigestDouble();
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            td.update((double)i);
        }
        Assert.assertFalse((boolean)td.isEmpty());
        Assert.assertEquals((long)td.getTotalWeight(), (long)10000L);
        Assert.assertEquals((double)td.getMinValue(), (double)0.0);
        Assert.assertEquals((double)td.getMaxValue(), (double)9999.0);
        Assert.assertEquals((double)td.getRank(0.0), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(2500.0), (double)0.25, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(5000.0), (double)0.5, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(7500.0), (double)0.75, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(10000.0), (double)1.0);
        Assert.assertEquals((double)td.getQuantile(0.0), (double)0.0);
        Assert.assertEquals((double)td.getQuantile(0.5), (double)5000.0, (double)150.0);
        Assert.assertEquals((double)td.getQuantile(0.9), (double)9000.0, (double)90.0);
        Assert.assertEquals((double)td.getQuantile(0.95), (double)9500.0, (double)95.0);
        Assert.assertEquals((double)td.getQuantile(1.0), (double)9999.0);
        double[] pmf = td.getPMF(new double[]{5000.0});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)1.0E-4);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)1.0E-4);
        double[] cdf = td.getCDF(new double[]{5000.0});
        Assert.assertEquals((int)cdf.length, (int)2);
        Assert.assertEquals((double)cdf[0], (double)0.5, (double)1.0E-4);
        Assert.assertEquals((double)cdf[1], (double)1.0);
    }

    @Test
    public void mergeSmall() {
        TDigestDouble td1 = new TDigestDouble();
        td1.update(1.0);
        td1.update(2.0);
        TDigestDouble td2 = new TDigestDouble();
        td2.update(2.0);
        td2.update(3.0);
        td1.merge(td2);
        Assert.assertEquals((long)td1.getTotalWeight(), (long)4L);
        Assert.assertEquals((double)td1.getMinValue(), (double)1.0);
        Assert.assertEquals((double)td1.getMaxValue(), (double)3.0);
    }

    @Test
    public void mergeLarge() {
        int n = 10000;
        TDigestDouble td1 = new TDigestDouble();
        TDigestDouble td2 = new TDigestDouble();
        for (int i = 0; i < 5000; ++i) {
            td1.update((double)i);
            td2.update((double)(5000 + i));
        }
        td1.merge(td2);
        Assert.assertEquals((long)td1.getTotalWeight(), (long)10000L);
        Assert.assertEquals((double)td1.getMinValue(), (double)0.0);
        Assert.assertEquals((double)td1.getMaxValue(), (double)9999.0);
    }

    @Test
    public void serializeDeserializeEmpty() {
        TDigestDouble td1 = new TDigestDouble();
        byte[] bytes = td1.toByteArray();
        TDigestDouble td2 = TDigestDouble.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((short)td2.getK(), (short)td1.getK());
        Assert.assertEquals((long)td2.getTotalWeight(), (long)td1.getTotalWeight());
        Assert.assertEquals((boolean)td2.isEmpty(), (boolean)td1.isEmpty());
    }

    @Test
    public void serializeDeserializeNonEmpty() {
        TDigestDouble td1 = new TDigestDouble();
        for (int i = 0; i < 10000; ++i) {
            td1.update((double)i);
        }
        byte[] bytes = td1.toByteArray();
        TDigestDouble td2 = TDigestDouble.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((short)td2.getK(), (short)td1.getK());
        Assert.assertEquals((long)td2.getTotalWeight(), (long)td1.getTotalWeight());
        Assert.assertEquals((boolean)td2.isEmpty(), (boolean)td1.isEmpty());
        Assert.assertEquals((double)td2.getMinValue(), (double)td1.getMinValue());
        Assert.assertEquals((double)td2.getMaxValue(), (double)td1.getMaxValue());
        Assert.assertEquals((double)td2.getRank(5000.0), (double)td1.getRank(5000.0));
        Assert.assertEquals((double)td2.getQuantile(0.5), (double)td1.getQuantile(0.5));
    }

    @Test
    public void deserializeFromReferenceImplementationDouble() {
        byte[] bytes = TestUtil.getResourceBytes("tdigest_ref_k100_n10000_double.sk");
        TDigestDouble td = TDigestDouble.heapify((Memory)Memory.wrap((byte[])bytes));
        int n = 10000;
        Assert.assertEquals((int)td.getK(), (int)100);
        Assert.assertEquals((long)td.getTotalWeight(), (long)10000L);
        Assert.assertEquals((double)td.getMinValue(), (double)0.0);
        Assert.assertEquals((double)td.getMaxValue(), (double)9999.0);
        Assert.assertEquals((double)td.getRank(0.0), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(2500.0), (double)0.25, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(5000.0), (double)0.5, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(7500.0), (double)0.75, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(10000.0), (double)1.0);
    }

    @Test
    public void deserializeFromReferenceImplementationFloat() {
        byte[] bytes = TestUtil.getResourceBytes("tdigest_ref_k100_n10000_float.sk");
        TDigestDouble td = TDigestDouble.heapify((Memory)Memory.wrap((byte[])bytes));
        int n = 10000;
        Assert.assertEquals((int)td.getK(), (int)100);
        Assert.assertEquals((long)td.getTotalWeight(), (long)10000L);
        Assert.assertEquals((double)td.getMinValue(), (double)0.0);
        Assert.assertEquals((double)td.getMaxValue(), (double)9999.0);
        Assert.assertEquals((double)td.getRank(0.0), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(2500.0), (double)0.25, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(5000.0), (double)0.5, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(7500.0), (double)0.75, (double)1.0E-4);
        Assert.assertEquals((double)td.getRank(10000.0), (double)1.0);
    }
}

