/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.testng.annotations.Test;

public class CornerCaseThetaSetOperationsTest {
    private static final long GT_MIDP_V = 3L;
    private static final float MIDP = 0.5f;
    private static final long GT_LOWP_V = 6L;
    private static final float LOWP = 0.1f;
    private static final long LT_LOWP_V = 4L;
    private static final double LOWP_THETA = (double)0.1f;

    @Test
    public void emptyEmpty() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = true;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 0, true);
    }

    @Test
    public void emptyExact() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void emptyDegenerate() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 0.1f, 0, false);
    }

    @Test
    public void emptyEstimation() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 0.1f, 1, false);
    }

    @Test
    public void exactEmpty() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 1, false, 1.0, 1, false);
    }

    @Test
    public void exactExact() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 1, false, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void exactDegenerate() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void exactEstimation() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void estimationEmpty() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void estimationExact() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void estimationDegenerate() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.5f, 4L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void estimationEstimation() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.5f, 4L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void degenerateEmpty() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 0.1f, 0, false, 0.1f, 0, false);
    }

    @Test
    public void degenerateExact() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void degenerateDegenerate() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.5f, 3L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 0, false);
    }

    @Test
    public void degenerateEstimation() {
        UpdateSketch thetaA = CornerCaseThetaSetOperationsTest.getSketch(SkType.DEGENERATE, 0.5f, 3L);
        UpdateSketch thetaB = CornerCaseThetaSetOperationsTest.getSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseThetaSetOperationsTest.checks(thetaA, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    private static void checks(UpdateSketch thetaA, UpdateSketch thetaB, double expectedIntersectTheta, int expectedIntersectCount, boolean expectedIntersectEmpty, double expectedAnotbTheta, int expectedAnotbCount, boolean expectedAnotbEmpty, double expectedUnionTheta, int expectedUnionCount, boolean expectedUnionEmpty) {
        Intersection inter = SetOperation.builder().buildIntersection();
        AnotB anotb = SetOperation.builder().buildANotB();
        Union union = new SetOperationBuilder().buildUnion();
        CompactSketch csk = inter.intersect((Sketch)thetaA, (Sketch)thetaB);
        CornerCaseThetaSetOperationsTest.checkResult("Intersect Stateless Theta, Theta", csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = inter.intersect((Sketch)thetaA.compact(), (Sketch)thetaB.compact());
        CornerCaseThetaSetOperationsTest.checkResult("Intersect Stateless Theta, Theta", csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = anotb.aNotB((Sketch)thetaA, (Sketch)thetaB);
        CornerCaseThetaSetOperationsTest.checkResult("AnotB Stateless Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = anotb.aNotB((Sketch)thetaA.compact(), (Sketch)thetaB.compact());
        CornerCaseThetaSetOperationsTest.checkResult("AnotB Stateless Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((Sketch)thetaA);
        anotb.notB((Sketch)thetaB);
        csk = anotb.getResult(true);
        CornerCaseThetaSetOperationsTest.checkResult("AnotB Stateful Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((Sketch)thetaA.compact());
        anotb.notB((Sketch)thetaB.compact());
        csk = anotb.getResult(true);
        CornerCaseThetaSetOperationsTest.checkResult("AnotB Stateful Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        union.union((Sketch)thetaA);
        union.union((Sketch)thetaB);
        csk = union.getResult();
        union.reset();
        CornerCaseThetaSetOperationsTest.checkResult("Union Stateless Theta, Theta", csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((Sketch)thetaA.compact());
        union.union((Sketch)thetaB.compact());
        csk = union.getResult();
        union.reset();
        CornerCaseThetaSetOperationsTest.checkResult("Union Stateless Theta, Theta", csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
    }

    private static void checkResult(String comment, CompactSketch csk, double expectedTheta, int expectedEntries, boolean expectedEmpty) {
        boolean emptyOk;
        double actualTheta = csk.getTheta();
        int actualEntries = csk.getRetainedEntries();
        boolean actualEmpty = csk.isEmpty();
        boolean thetaOk = actualTheta == expectedTheta;
        boolean entriesOk = actualEntries == expectedEntries;
        boolean bl = emptyOk = actualEmpty == expectedEmpty;
        if (!(thetaOk && entriesOk && emptyOk)) {
            StringBuilder sb = new StringBuilder();
            sb.append(comment + ": ");
            if (!thetaOk) {
                sb.append("Theta: expected " + expectedTheta + ", got " + actualTheta + "; ");
            }
            if (!entriesOk) {
                sb.append("Entries: expected " + expectedEntries + ", got " + actualEntries + "; ");
            }
            if (!emptyOk) {
                sb.append("Empty: expected " + expectedEmpty + ", got " + actualEmpty + ".");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static UpdateSketch getSketch(SkType skType, float p, long value) {
        UpdateSketch sk;
        UpdateSketchBuilder bldr = UpdateSketch.builder();
        bldr.setLogNominalEntries(4);
        switch (skType.ordinal()) {
            case 0: {
                sk = bldr.build();
                break;
            }
            case 1: {
                sk = bldr.build();
                sk.update(value);
                break;
            }
            case 2: {
                bldr.setP(p);
                sk = bldr.build();
                sk.update(value);
                break;
            }
            case 3: {
                bldr.setP(p);
                sk = bldr.build();
                sk.update(value);
                break;
            }
            default: {
                return null;
            }
        }
        return sk;
    }

    private static enum SkType {
        EMPTY,
        EXACT,
        ESTIMATION,
        DEGENERATE;

    }
}

