/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.thetacommon.HashOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetOperationTest {
    @Test
    public void checkBuilder() {
        int i;
        int k = 2048;
        long seed = 1021L;
        UpdateSketch usk1 = UpdateSketch.builder().setSeed(1021L).setNominalEntries(2048).build();
        UpdateSketch usk2 = UpdateSketch.builder().setSeed(1021L).setNominalEntries(2048).build();
        for (i = 0; i < 1024; ++i) {
            usk1.update((long)i);
        }
        for (i = 1024; i < 2048; ++i) {
            usk2.update((long)i);
        }
        ResizeFactor rf = ResizeFactor.X4;
        Union union = SetOperation.builder().setSeed(1021L).setResizeFactor(rf).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        double exactUnionAnswer = 2048.0;
        CompactSketch comp1 = union.getResult(false, null);
        double compEst = comp1.getEstimate();
        Assert.assertEquals((double)compEst, (double)2048.0, (double)0.0);
    }

    @Test
    public void checkBuilder2() {
        SetOperationBuilder bldr = SetOperation.builder();
        long seed = 12345L;
        bldr.setSeed(12345L);
        Assert.assertEquals((long)bldr.getSeed(), (long)12345L);
        float p = 0.5f;
        bldr.setP(0.5f);
        Assert.assertEquals((float)bldr.getP(), (float)0.5f);
        ResizeFactor rf = ResizeFactor.X4;
        bldr.setResizeFactor(rf);
        Assert.assertEquals((Object)bldr.getResizeFactor(), (Object)rf);
        int lgK = 10;
        int k = 1024;
        bldr.setNominalEntries(1024);
        Assert.assertEquals((int)bldr.getLgNominalEntries(), (int)10);
        DefaultMemoryRequestServer mrs = new DefaultMemoryRequestServer();
        bldr.setMemoryRequestServer((MemoryRequestServer)mrs);
        Assert.assertEquals((Object)bldr.getMemoryRequestServer(), (Object)mrs);
        SetOperationTest.println(bldr.toString());
    }

    @Test
    public void checkBuilderNonPowerOf2() {
        SetOperation.builder().setNominalEntries(1000).buildUnion();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderBadFamily() {
        SetOperation.builder().build(Family.ALPHA);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderIllegalPhi() {
        float p = 1.5f;
        SetOperation.builder().setP(1.5f).buildUnion();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderIllegalPlo() {
        float p = 0.0f;
        SetOperation.builder().setP(0.0f).buildUnion();
    }

    @Test
    public void checkBuilderValidP() {
        float p = 0.5f;
        SetOperation.builder().setP(0.5f).buildUnion();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderAnotB_noMem() {
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[64]);
        SetOperation.builder().build(Family.A_NOT_B, mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderBadSeedHashes() {
        int i;
        int k = 2048;
        long seed = 1021L;
        UpdateSketch usk1 = UpdateSketch.builder().setSeed(1021L).setNominalEntries(2048).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(2048).build();
        for (i = 0; i < 1024; ++i) {
            usk1.update((long)i);
        }
        for (i = 1024; i < 2048; ++i) {
            usk2.update((long)i);
        }
        ResizeFactor rf = ResizeFactor.X4;
        Union union = SetOperation.builder().setSeed(1021L).setResizeFactor(rf).setNominalEntries(2048).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderNomEntries() {
        int k = 0x8000000;
        SetOperationBuilder bldr = SetOperation.builder();
        bldr.setNominalEntries(0x8000000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSetOpHeapify() {
        int k = 64;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(64).build();
        for (int i = 0; i < 64; ++i) {
            usk1.update((long)i);
        }
        byte[] byteArray = usk1.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArray);
        SetOperation.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSetOpWrap() {
        int k = 64;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(64).build();
        for (int i = 0; i < 64; ++i) {
            usk1.update((long)i);
        }
        byte[] byteArray = usk1.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArray);
        Sketches.wrapIntersection((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSetOpWrap2() {
        int k = 64;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(64).build();
        for (int i = 0; i < 64; ++i) {
            usk1.update((long)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])usk1.toByteArray());
        PreambleUtil.insertSerVer((WritableMemory)wmem, (int)2);
        WritableMemory mem = wmem;
        SetOperation.wrap((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSetOpWrap3() {
        int k = 64;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(64).build();
        for (int i = 0; i < 64; ++i) {
            usk1.update((long)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])usk1.toByteArray());
        SetOperation.wrap((WritableMemory)wmem);
    }

    @Test
    public void checkBuildSetOps() {
        SetOperationBuilder bldr = Sketches.setOperationBuilder();
        bldr.buildUnion();
        bldr.buildIntersection();
        bldr.buildANotB();
    }

    @Test
    public void checkComputeLgArrLongs() {
        Assert.assertEquals((int)HashOperations.minLgHashTableSize((int)30, (double)0.9375), (int)5);
        Assert.assertEquals((int)HashOperations.minLgHashTableSize((int)31, (double)0.9375), (int)6);
    }

    @Test
    public void checkDirectUnionExample() {
        int sketchNomEntries = 16384;
        int unionNomEntries = 32768;
        int[] heapLayout = SetOperationTest.getHeapLayout(16384, unionNomEntries);
        byte[] backingArr = new byte[heapLayout[5]];
        ByteBuffer heapBuf = ByteBuffer.wrap(backingArr).order(ByteOrder.nativeOrder());
        WritableMemory heapMem = WritableMemory.writableWrap((ByteBuffer)heapBuf);
        double result = SetOperationTest.directUnionTrial1(heapMem, heapLayout, 16384, unionNomEntries);
        SetOperationTest.println("1st est: " + result);
        int expected = 32768;
        Assert.assertEquals((double)result, (double)32768.0, (double)0.0);
        unionNomEntries = 16384;
        result = SetOperationTest.directUnionTrial2(heapMem, heapLayout, 16384, unionNomEntries);
        Assert.assertEquals((double)result, (double)32768.0, (double)1638.4);
        SetOperationTest.println("2nd est: " + result);
        SetOperationTest.println("Error %: " + (result / 32768.0 - 1.0) * 100.0);
    }

    @Test
    public void setOpsExample() {
        int i;
        SetOperationTest.println("Set Operations Example:");
        int k = 4096;
        UpdateSketch skA = Sketches.updateSketchBuilder().setNominalEntries(4096).build();
        UpdateSketch skB = Sketches.updateSketchBuilder().setNominalEntries(4096).build();
        UpdateSketch skC = Sketches.updateSketchBuilder().setNominalEntries(4096).build();
        for (i = 1; i <= 10; ++i) {
            skA.update((long)i);
        }
        for (i = 1; i <= 20; ++i) {
            skB.update((long)i);
        }
        for (i = 6; i <= 15; ++i) {
            skC.update((long)i);
        }
        Union union = Sketches.setOperationBuilder().setNominalEntries(4096).buildUnion();
        union.union((Sketch)skA);
        union.union((Sketch)skB);
        CompactSketch unionSk = union.getResult();
        SetOperationTest.println("A U B      : " + unionSk.getEstimate());
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.intersect((Sketch)unionSk);
        inter.intersect((Sketch)skC);
        CompactSketch interSk = inter.getResult();
        SetOperationTest.println("(A U B) ^ C: " + interSk.getEstimate());
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        CompactSketch not = aNotB.aNotB((Sketch)skA, (Sketch)skC);
        SetOperationTest.println("A \\ C      : " + not.getEstimate());
    }

    @Test
    public void checkIsSameResource() {
        int k = 16;
        WritableMemory wmem = WritableMemory.writableWrap((byte[])new byte[288]);
        WritableMemory emptyMem = WritableMemory.writableWrap((byte[])new byte[8]);
        Union union = Sketches.setOperationBuilder().setNominalEntries(16).buildUnion(wmem);
        Assert.assertTrue((boolean)union.isSameResource((Memory)wmem));
        Assert.assertFalse((boolean)union.isSameResource((Memory)emptyMem));
        Intersection inter = Sketches.setOperationBuilder().buildIntersection(wmem);
        Assert.assertTrue((boolean)inter.isSameResource((Memory)wmem));
        Assert.assertFalse((boolean)inter.isSameResource((Memory)emptyMem));
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        Assert.assertFalse((boolean)aNotB.isSameResource((Memory)emptyMem));
    }

    @Test
    public void printlnTest() {
        SetOperationTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    private static int[] getHeapLayout(int sketchNomEntries, int unionNomEntries) {
        int[] heapLayout = new int[6];
        int unionBytes = SetOperation.getMaxUnionBytes((int)unionNomEntries);
        int sketchBytes = Sketch.getMaxUpdateSketchBytes((int)sketchNomEntries);
        int resultBytes = Sketch.getMaxCompactSketchBytes((int)unionNomEntries);
        heapLayout[0] = 0;
        heapLayout[1] = unionBytes;
        heapLayout[2] = unionBytes + sketchBytes;
        heapLayout[3] = unionBytes + 2 * sketchBytes;
        heapLayout[4] = unionBytes + 3 * sketchBytes;
        heapLayout[5] = unionBytes + 3 * sketchBytes + resultBytes;
        return heapLayout;
    }

    private static double directUnionTrial1(WritableMemory heapMem, int[] heapLayout, int sketchNomEntries, int unionNomEntries) {
        int offset = heapLayout[0];
        int bytes = heapLayout[1] - offset;
        WritableMemory unionMem = heapMem.writableRegion((long)offset, (long)bytes);
        Union union = SetOperation.builder().setNominalEntries(unionNomEntries).buildUnion(unionMem);
        WritableMemory sketch1mem = heapMem.writableRegion((long)heapLayout[1], (long)(heapLayout[2] - heapLayout[1]));
        WritableMemory sketch2mem = heapMem.writableRegion((long)heapLayout[2], (long)(heapLayout[3] - heapLayout[2]));
        WritableMemory sketch3mem = heapMem.writableRegion((long)heapLayout[3], (long)(heapLayout[4] - heapLayout[3]));
        WritableMemory resultMem = heapMem.writableRegion((long)heapLayout[4], (long)(heapLayout[5] - heapLayout[4]));
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(sketchNomEntries).build(sketch1mem);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(sketchNomEntries).build(sketch2mem);
        UpdateSketch sk3 = UpdateSketch.builder().setNominalEntries(sketchNomEntries).build(sketch3mem);
        for (int i = 0; i < sketchNomEntries; ++i) {
            sk1.update((long)i);
            sk2.update((long)(i + sketchNomEntries / 2));
            sk3.update((long)(i + sketchNomEntries));
        }
        Assert.assertEquals((double)sk1.getEstimate(), (double)sketchNomEntries, (double)0.0);
        Assert.assertEquals((double)sk2.getEstimate(), (double)sketchNomEntries, (double)0.0);
        Assert.assertEquals((double)sk3.getEstimate(), (double)sketchNomEntries, (double)0.0);
        union.union((Sketch)sk1);
        union.union((Sketch)sk2);
        union = Sketches.wrapUnion((WritableMemory)unionMem);
        union.union(Sketch.wrap((Memory)sketch3mem));
        CompactSketch resSk = union.getResult(true, resultMem);
        double est = resSk.getEstimate();
        return est;
    }

    private static double directUnionTrial2(WritableMemory heapMem, int[] heapLayout, int sketchNomEntries, int unionNomEntries) {
        WritableMemory unionMem = heapMem.writableRegion((long)heapLayout[0], (long)(heapLayout[1] - heapLayout[0]));
        WritableMemory sketch1mem = heapMem.writableRegion((long)heapLayout[1], (long)(heapLayout[2] - heapLayout[1]));
        WritableMemory sketch2mem = heapMem.writableRegion((long)heapLayout[2], (long)(heapLayout[3] - heapLayout[2]));
        WritableMemory sketch3mem = heapMem.writableRegion((long)heapLayout[3], (long)(heapLayout[4] - heapLayout[3]));
        WritableMemory resultMem = heapMem.writableRegion((long)heapLayout[4], (long)(heapLayout[5] - heapLayout[4]));
        UpdateSketch sk1 = (UpdateSketch)Sketch.wrap((Memory)sketch1mem);
        UpdateSketch sk2 = (UpdateSketch)Sketch.wrap((Memory)sketch2mem);
        UpdateSketch sk3 = (UpdateSketch)Sketch.wrap((Memory)sketch3mem);
        Assert.assertEquals((double)sk1.getEstimate(), (double)sketchNomEntries, (double)0.0);
        Assert.assertEquals((double)sk2.getEstimate(), (double)sketchNomEntries, (double)0.0);
        Assert.assertEquals((double)sk3.getEstimate(), (double)sketchNomEntries, (double)0.0);
        unionMem.clear();
        Union union = SetOperation.builder().setNominalEntries(unionNomEntries).buildUnion(unionMem);
        union.union((Sketch)sk1);
        union.union((Sketch)sk2);
        union.union((Sketch)sk3);
        CompactSketch resSk = union.getResult(true, resultMem);
        double est = resSk.getEstimate();
        return est;
    }
}

