/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectQuantilesMemoryRequestTest {
    @Test
    public void checkLimitedMemoryScenarios() {
        MemorySegment wseg;
        int k = 128;
        int u = 5120;
        int initBytes = 2080;
        try (Arena arena = Arena.ofConfined();){
            wseg = arena.allocate(2080L);
            DirectQuantilesMemoryRequestTest.println("Initial seg size: " + wseg.byteSize());
            UpdatableQuantilesDoublesSketch usk = QuantilesDoublesSketch.builder().setK(128).build(wseg);
            Assert.assertTrue((boolean)usk.isEmpty());
            for (int i = 0; i < 5120; ++i) {
                usk.update((double)i);
            }
            double result = usk.getQuantile(0.5);
            DirectQuantilesMemoryRequestTest.println("Result: " + result);
            Assert.assertEquals((double)result, (double)2560.0, (double)256.0);
            MemorySegment wseg2 = usk.getMemorySegment();
            DirectQuantilesMemoryRequestTest.println("\nFinal seg size: " + wseg2.byteSize());
        }
        Assert.assertFalse((boolean)wseg.scope().isAlive());
    }

    @Test
    public void checkGrowBaseBuf() {
        MemorySegment wseg;
        int k = 128;
        int u = 32;
        int initBytes = 160;
        try (Arena arena = Arena.ofConfined();){
            wseg = arena.allocate(160L);
            DirectQuantilesMemoryRequestTest.println("Initial seg size: " + wseg.byteSize());
            UpdatableQuantilesDoublesSketch usk1 = QuantilesDoublesSketch.builder().setK(128).build(wseg);
            for (int i = 1; i <= 32; ++i) {
                usk1.update((double)i);
            }
            int currentSpace = usk1.getCombinedBufferItemCapacity();
            DirectQuantilesMemoryRequestTest.println("curCombBufItemCap: " + currentSpace);
            Assert.assertEquals((int)currentSpace, (int)256);
            Assert.assertTrue((boolean)wseg.scope().isAlive());
        }
        Assert.assertFalse((boolean)wseg.scope().isAlive());
    }

    @Test
    public void checkGrowCombBuf() {
        MemorySegment wseg;
        int k = 128;
        int u = 255;
        int initBytes = 2080;
        try (Arena arena = Arena.ofConfined();){
            wseg = arena.allocate(2080L);
            DirectQuantilesMemoryRequestTest.println("Initial seg size: " + wseg.byteSize());
            UpdatableQuantilesDoublesSketch usk1 = QuantilesDoublesSketch.builder().setK(128).build(wseg);
            for (int i = 1; i <= 255; ++i) {
                usk1.update((double)i);
            }
            int currentSpace = usk1.getCombinedBufferItemCapacity();
            DirectQuantilesMemoryRequestTest.println("curCombBufItemCap: " + currentSpace);
            double[] newCB = usk1.growCombinedBuffer(currentSpace, 384);
            int newSpace = usk1.getCombinedBufferItemCapacity();
            DirectQuantilesMemoryRequestTest.println("newCombBurItemCap: " + newSpace);
            Assert.assertEquals((int)newCB.length, (int)384);
            Assert.assertTrue((boolean)wseg.scope().isAlive());
        }
        Assert.assertFalse((boolean)wseg.scope().isAlive());
    }

    @Test
    public void checkUpdatableStorageBytes() {
        int k = 16;
        int initBytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)16, (long)1L);
        DirectQuantilesMemoryRequestTest.println("Predicted Updatable Storage Bytes: " + initBytes);
        UpdatableQuantilesDoublesSketch usk1 = QuantilesDoublesSketch.builder().setK(16).build();
        usk1.update(1.0);
        byte[] uarr = usk1.toByteArray();
        DirectQuantilesMemoryRequestTest.println("Actual Storage Bytes " + uarr.length);
        Assert.assertEquals((int)initBytes, (int)uarr.length);
        Assert.assertEquals((int)initBytes, (int)64);
    }

    @Test
    public void checkGrowFromWrappedEmptySketch() {
        MemorySegment wseg;
        int k = 16;
        boolean n = false;
        int initBytes = QuantilesDoublesSketch.getUpdatableStorageBytes((int)16, (long)0L);
        UpdatableQuantilesDoublesSketch usk1 = QuantilesDoublesSketch.builder().setK(16).build();
        MemorySegment origSketchSeg = MemorySegment.ofArray(usk1.toByteArray());
        try (Arena arena = Arena.ofConfined();){
            wseg = arena.allocate(initBytes);
            MemorySegment.copy(origSketchSeg, 0L, wseg, 0L, initBytes);
            DirectUpdateDoublesSketch usk2 = DirectUpdateDoublesSketch.wrapInstance((MemorySegment)wseg, null);
            Assert.assertTrue((boolean)MemorySegmentStatus.isSameResource((MemorySegment)wseg, (MemorySegment)usk2.getMemorySegment()));
            Assert.assertEquals((long)wseg.byteSize(), (long)initBytes);
            Assert.assertTrue((boolean)wseg.isNative());
            Assert.assertTrue((boolean)usk2.isEmpty());
            usk2.update(1.0);
            Assert.assertEquals((long)usk2.getN(), (long)1L);
            MemorySegment seg2 = usk2.getMemorySegment();
            Assert.assertFalse((boolean)MemorySegmentStatus.isSameResource((MemorySegment)wseg, (MemorySegment)seg2));
            Assert.assertFalse((boolean)seg2.isNative());
            int expectedSize = 288;
            Assert.assertEquals((long)seg2.byteSize(), (long)288L);
            Assert.assertTrue((boolean)wseg.scope().isAlive());
        }
        Assert.assertFalse((boolean)wseg.scope().isAlive());
    }

    @Test
    public void printlnTest() {
        DirectQuantilesMemoryRequestTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

