/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PairwiseSetOperationsTest {
    @Test
    public void checkIntersectionNoOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)(i + k));
        }
        CompactThetaSketch csk1 = usk1.compact(true, null);
        CompactThetaSketch csk2 = usk2.compact(true, null);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        CompactThetaSketch rsk = inter.intersect((ThetaSketch)csk1, (ThetaSketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)0.0);
    }

    @Test
    public void checkIntersectionFullOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)i);
        }
        CompactThetaSketch csk1 = usk1.compact(true, null);
        CompactThetaSketch csk2 = usk2.compact(true, null);
        CompactThetaSketch rsk = inter.intersect((ThetaSketch)csk1, (ThetaSketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)k, (double)0.0);
    }

    @Test
    public void checkIntersectionEarlyStop() {
        int lgK = 10;
        int k = 1 << lgK;
        int u = 4 * k;
        long v = 0L;
        int trials = 10;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        for (int t = 0; t < trials; ++t) {
            for (int i = 0; i < u; ++i) {
                usk1.update((long)i + v);
                usk2.update((long)i + v + (long)(u / 2));
            }
            v += (long)(u + u / 2);
            CompactThetaSketch csk1 = usk1.compact(true, null);
            CompactThetaSketch csk2 = usk2.compact(true, null);
            CompactThetaSketch rsk = inter.intersect((ThetaSketch)csk1, (ThetaSketch)csk2);
            double result1 = rsk.getEstimate();
            inter.intersect((ThetaSketch)csk1);
            inter.intersect((ThetaSketch)csk2);
            CompactThetaSketch csk3 = inter.getResult(true, null);
            double result2 = csk3.getEstimate();
            Assert.assertEquals((double)result1, (double)result2, (double)0.0);
            usk1.reset();
            usk2.reset();
            inter.reset();
        }
    }

    @Test
    public void checkAnotBNoOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        ThetaAnotB anotb = ThetaSetOperation.builder().buildANotB();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)(i + k));
        }
        CompactThetaSketch csk1 = usk1.compact(true, null);
        CompactThetaSketch csk2 = usk2.compact(true, null);
        CompactThetaSketch rsk = anotb.aNotB((ThetaSketch)csk1, (ThetaSketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)k, (double)0.0);
    }

    @Test
    public void checkAnotBFullOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        ThetaAnotB anotb = ThetaSetOperation.builder().buildANotB();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)i);
        }
        CompactThetaSketch csk1 = usk1.compact(true, null);
        CompactThetaSketch csk2 = usk2.compact(true, null);
        CompactThetaSketch rsk = anotb.aNotB((ThetaSketch)csk1, (ThetaSketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkAnotBEarlyStop() {
        int lgK = 10;
        int k = 1 << lgK;
        int u = 4 * k;
        long v = 0L;
        int trials = 10;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        for (int t = 0; t < trials; ++t) {
            for (int i = 0; i < u; ++i) {
                usk1.update((long)i + v);
                usk2.update((long)i + v + (long)(u / 2));
            }
            v += (long)(u + u / 2);
            CompactThetaSketch csk1 = usk1.compact(true, null);
            CompactThetaSketch csk2 = usk2.compact(true, null);
            CompactThetaSketch rsk = aNotB.aNotB((ThetaSketch)csk1, (ThetaSketch)csk2);
            double result1 = rsk.getEstimate();
            CompactThetaSketch csk3 = aNotB.aNotB((ThetaSketch)csk1, (ThetaSketch)csk2);
            double result2 = csk3.getEstimate();
            Assert.assertEquals((double)result1, (double)result2, (double)0.0);
            usk1.reset();
            usk2.reset();
        }
    }

    @Test
    public void checkUnionNoOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(k).buildUnion();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)(i + k));
        }
        CompactThetaSketch csk1 = usk1.compact(true, null);
        CompactThetaSketch csk2 = usk2.compact(true, null);
        union.union((ThetaSketch)csk1);
        union.union((ThetaSketch)csk2);
        CompactThetaSketch stdSk = union.getResult(true, null);
        CompactThetaSketch rsk = union.union((ThetaSketch)csk1, (ThetaSketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)stdSk.getEstimate(), (double)0.0);
    }

    @Test
    public void checkUnionFullOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(k).buildUnion();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)i);
        }
        CompactThetaSketch csk1 = usk1.compact(true, null);
        CompactThetaSketch csk2 = usk2.compact(true, null);
        CompactThetaSketch rsk = union.union((ThetaSketch)csk1, (ThetaSketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)k, (double)0.0);
    }

    @Test
    public void checkUnionEarlyStop() {
        int lgK = 10;
        int k = 1 << lgK;
        int u = 4 * k;
        long v = 0L;
        int trials = 10;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(2 * k).buildUnion();
        for (int t = 0; t < trials; ++t) {
            for (int i = 0; i < u; ++i) {
                usk1.update((long)i + v);
                usk2.update((long)i + v + (long)(u / 2));
            }
            v += (long)(u + u / 2);
            CompactThetaSketch csk1 = usk1.compact(true, null);
            CompactThetaSketch csk2 = usk2.compact(true, null);
            CompactThetaSketch pwSk = union.union((ThetaSketch)csk1, (ThetaSketch)csk2);
            double pwEst = pwSk.getEstimate();
            union.union((ThetaSketch)csk1);
            union.union((ThetaSketch)csk2);
            CompactThetaSketch stdSk = union.getResult(true, null);
            double stdEst = stdSk.getEstimate();
            Assert.assertEquals((double)pwEst, (double)stdEst, (double)0.0);
            usk1.reset();
            usk2.reset();
            union.reset();
        }
    }

    @Test
    public void checkUnionCutbackToK() {
        int lgK = 10;
        int k = 1 << lgK;
        int u = 3 * k;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(k).buildUnion();
        for (int i = 0; i < u; ++i) {
            usk1.update((long)i);
            usk2.update((long)(i + 2 * u));
        }
        CompactThetaSketch csk1 = usk1.compact(true, null);
        CompactThetaSketch csk2 = usk2.compact(true, null);
        CompactThetaSketch pwSk = union.union((ThetaSketch)csk1, (ThetaSketch)csk2);
        double pwEst = pwSk.getEstimate();
        union.union((ThetaSketch)csk1);
        union.union((ThetaSketch)csk2);
        CompactThetaSketch stdSk = union.getResult(true, null);
        double stdEst = stdSk.getEstimate();
        Assert.assertEquals((double)pwEst, (double)stdEst, (double)(stdEst * 0.06));
        usk1.reset();
        usk2.reset();
        union.reset();
    }

    @Test
    public void checkNullRules() {
        int k = 16;
        UpdatableThetaSketch uskA = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        CompactThetaSketch cskAempty = uskA.compact();
        CompactThetaSketch cskAnull = null;
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        try {
            PairwiseSetOperationsTest.checkIntersection(inter, cskAnull, cskAempty);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkIntersection(inter, cskAempty, cskAnull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkIntersection(inter, cskAnull, cskAnull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkAnotB(aNotB, cskAnull, cskAempty);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkAnotB(aNotB, cskAempty, cskAnull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkAnotB(aNotB, cskAnull, cskAnull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkEmptyValidRules() {
        int k = 16;
        UpdatableThetaSketch uskA = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        UpdatableThetaSketch uskB = UpdatableThetaSketch.builder().setNominalEntries(k).build();
        CompactThetaSketch cskAempty = uskA.compact();
        CompactThetaSketch cskBempty = uskB.compact();
        uskA.update(1L);
        CompactThetaSketch cskA1 = uskA.compact();
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(k).buildUnion();
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        PairwiseSetOperationsTest.checkSetOps(union, inter, aNotB, cskAempty, cskBempty);
        PairwiseSetOperationsTest.checkSetOps(union, inter, aNotB, cskA1, cskBempty);
        PairwiseSetOperationsTest.checkSetOps(union, inter, aNotB, cskAempty, cskA1);
    }

    private static void checkSetOps(ThetaUnion union, ThetaIntersection inter, ThetaAnotB aNotB, CompactThetaSketch cskA, CompactThetaSketch cskB) {
        PairwiseSetOperationsTest.checkUnion(union, cskA, cskB);
        PairwiseSetOperationsTest.checkIntersection(inter, cskA, cskB);
        PairwiseSetOperationsTest.checkAnotB(aNotB, cskA, cskB);
    }

    private static void checkUnion(ThetaUnion union, CompactThetaSketch cskA, CompactThetaSketch cskB) {
        union.union((ThetaSketch)cskA);
        union.union((ThetaSketch)cskB);
        CompactThetaSketch cskU = union.getResult();
        CompactThetaSketch cskP = union.union((ThetaSketch)cskA, (ThetaSketch)cskB);
        Assert.assertEquals((boolean)cskU.isEmpty(), (boolean)cskP.isEmpty());
        union.reset();
    }

    private static void checkIntersection(ThetaIntersection inter, CompactThetaSketch cskA, CompactThetaSketch cskB) {
        inter.intersect((ThetaSketch)cskA);
        inter.intersect((ThetaSketch)cskB);
        CompactThetaSketch cskI = inter.getResult();
        CompactThetaSketch cskP = inter.intersect((ThetaSketch)cskA, (ThetaSketch)cskB);
        Assert.assertEquals((boolean)cskI.isEmpty(), (boolean)cskP.isEmpty());
        inter.reset();
    }

    private static void checkAnotB(ThetaAnotB aNotB, CompactThetaSketch cskA, CompactThetaSketch cskB) {
        CompactThetaSketch cskD = aNotB.aNotB((ThetaSketch)cskA, (ThetaSketch)cskB);
        CompactThetaSketch cskP = aNotB.aNotB((ThetaSketch)cskA, (ThetaSketch)cskB);
        Assert.assertEquals((boolean)cskD.isEmpty(), (boolean)cskP.isEmpty());
    }

    @Test
    public void printlnTest() {
        PairwiseSetOperationsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

