/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllMemorySegmentValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;

class KllDirectLongsSketch
extends KllLongsSketch {
    private MemorySegment wseg;
    private final MemorySegmentRequest mSegReq;

    KllDirectLongsSketch(MemorySegment wseg, KllMemorySegmentValidate segVal, MemorySegmentRequest mSegmentRequest) {
        super(segVal);
        this.wseg = wseg;
        this.mSegReq = mSegmentRequest;
    }

    static KllDirectLongsSketch newDirectUpdatableInstance(int k, int m, MemorySegment dstSeg, MemorySegmentRequest mSegmentRequest) {
        KllPreambleUtil.setMemorySegmentPreInts(dstSeg, KllSketch.SketchStructure.UPDATABLE.getPreInts());
        KllPreambleUtil.setMemorySegmentSerVer(dstSeg, KllSketch.SketchStructure.UPDATABLE.getSerVer());
        KllPreambleUtil.setMemorySegmentFamilyID(dstSeg, Family.KLL.getID());
        KllPreambleUtil.setMemorySegmentK(dstSeg, k);
        KllPreambleUtil.setMemorySegmentM(dstSeg, m);
        KllPreambleUtil.setMemorySegmentN(dstSeg, 0L);
        KllPreambleUtil.setMemorySegmentMinK(dstSeg, k);
        KllPreambleUtil.setMemorySegmentNumLevels(dstSeg, 1);
        int offset = 20;
        MemorySegment.copy(new int[]{k, k}, 0, dstSeg, ValueLayout.JAVA_INT_UNALIGNED, (long)offset, 2);
        MemorySegment.copy(new long[]{Long.MAX_VALUE, Long.MIN_VALUE}, 0, dstSeg, ValueLayout.JAVA_LONG_UNALIGNED, (long)(offset += 8), 2);
        MemorySegment.copy(new long[k], 0, dstSeg, ValueLayout.JAVA_LONG_UNALIGNED, (long)(offset += 16), k);
        KllMemorySegmentValidate segVal = new KllMemorySegmentValidate(dstSeg, KllSketch.SketchType.KLL_LONGS_SKETCH, null);
        MemorySegment wSeg = dstSeg;
        return new KllDirectLongsSketch(wSeg, segVal, mSegmentRequest);
    }

    @Override
    String getItemAsString(int index) {
        if (this.isEmpty()) {
            return "Null";
        }
        return Long.toString(this.getLongItemsArray()[index]);
    }

    @Override
    public int getK() {
        return KllPreambleUtil.getMemorySegmentK(this.wseg);
    }

    @Override
    public long getMaxItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getLongSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        return this.wseg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
    }

    @Override
    long getMaxItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Long.MAX_VALUE;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getLongSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        return this.wseg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
    }

    @Override
    String getMaxItemAsString() {
        long maxItem = this.getMaxItemInternal();
        return Long.toString(maxItem);
    }

    @Override
    public long getMinItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getLongSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wseg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
    }

    @Override
    long getMinItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Long.MAX_VALUE;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getLongSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wseg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
    }

    @Override
    String getMinItemAsString() {
        long minItem = this.getMinItemInternal();
        return Long.toString(minItem);
    }

    @Override
    void setMaxItem(long item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        this.wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset, item);
    }

    @Override
    void setMinItem(long item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        this.wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset, item);
    }

    @Override
    public long getN() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return 0L;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return 1L;
        }
        return KllPreambleUtil.getMemorySegmentN(this.wseg);
    }

    @Override
    long[] getLongItemsArray() {
        int k = this.getK();
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new long[k];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            long[] itemsArr = new long[k];
            itemsArr[k - 1] = this.getLongSingleItem();
            return itemsArr;
        }
        int capacityItems = KllHelper.computeTotalItemCapacity(k, this.getM(), this.getNumLevels());
        long[] longItemsArr = new long[capacityItems];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16;
        int shift = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.levelsArr[0] : 0;
        int numItems = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.getNumRetained() : capacityItems;
        MemorySegment.copy(this.wseg, ValueLayout.JAVA_LONG_UNALIGNED, offset, longItemsArr, shift, numItems);
        return longItemsArr;
    }

    @Override
    long[] getLongRetainedItemsArray() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new long[0];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return new long[]{this.getLongSingleItem()};
        }
        int numRetained = this.getNumRetained();
        long[] longItemsArr = new long[numRetained];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16 + (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 0 : this.levelsArr[0] * 8);
        MemorySegment.copy(this.wseg, ValueLayout.JAVA_LONG_UNALIGNED, offset, longItemsArr, 0, numRetained);
        return longItemsArr;
    }

    @Override
    long getLongSingleItem() {
        if (!this.isSingleItem()) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.wseg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
        }
        int offset = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16 : 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (2 + this.getK() - 1) * 8;
        return this.wseg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
    }

    @Override
    int getM() {
        return KllPreambleUtil.getMemorySegmentM(this.wseg);
    }

    @Override
    MemorySegmentRequest getMemorySegmentRequest() {
        return this.mSegReq;
    }

    @Override
    int getMinK() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL || this.sketchStructure == KllSketch.SketchStructure.UPDATABLE) {
            return KllPreambleUtil.getMemorySegmentMinK(this.wseg);
        }
        return this.getK();
    }

    @Override
    byte[] getMinMaxByteArr() {
        byte[] bytesOut = new byte[16];
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            ByteArrayUtil.putLongLE(bytesOut, 0, Long.MAX_VALUE);
            ByteArrayUtil.putLongLE(bytesOut, 8, Long.MIN_VALUE);
            return bytesOut;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            int offset = 8;
            MemorySegment.copy(this.wseg, ValueLayout.JAVA_BYTE, offset, bytesOut, 0, 8);
            ByteArrayUtil.copyBytes(bytesOut, 0, bytesOut, 8, 8);
            return bytesOut;
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        MemorySegment.copy(this.wseg, ValueLayout.JAVA_BYTE, offset, bytesOut, 0, 8);
        MemorySegment.copy(this.wseg, ValueLayout.JAVA_BYTE, offset + 8, bytesOut, 8, 8);
        return bytesOut;
    }

    @Override
    byte[] getRetainedItemsByteArr() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new byte[0];
        }
        long[] lngArr = this.getLongRetainedItemsArray();
        byte[] lngByteArr = new byte[lngArr.length * 8];
        MemorySegment wseg2 = MemorySegment.ofArray(lngByteArr);
        MemorySegment.copy(lngArr, 0, wseg2, ValueLayout.JAVA_LONG_UNALIGNED, 0L, lngArr.length);
        return lngByteArr;
    }

    @Override
    byte[] getTotalItemsByteArr() {
        long[] lngArr = this.getLongItemsArray();
        byte[] lngByteArr = new byte[lngArr.length * 8];
        MemorySegment wseg2 = MemorySegment.ofArray(lngByteArr);
        MemorySegment.copy(lngArr, 0, wseg2, ValueLayout.JAVA_LONG_UNALIGNED, 0L, lngArr.length);
        return lngByteArr;
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.wseg;
    }

    @Override
    void incN(int increment) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentN(this.wseg, KllPreambleUtil.getMemorySegmentN(this.wseg) + (long)increment);
    }

    @Override
    void incNumLevels() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int numLevels = KllPreambleUtil.getMemorySegmentNumLevels(this.wseg);
        KllPreambleUtil.setMemorySegmentNumLevels(this.wseg, ++numLevels);
    }

    @Override
    boolean isLevelZeroSorted() {
        return KllPreambleUtil.getMemorySegmentLevelZeroSortedFlag(this.wseg);
    }

    @Override
    void setLongItemsArray(long[] longItems) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 16;
        MemorySegment.copy(longItems, 0, this.wseg, ValueLayout.JAVA_LONG_UNALIGNED, (long)offset, longItems.length);
    }

    @Override
    void setLongItemsArrayAt(int index, long item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 8;
        this.wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset, item);
    }

    @Override
    void setLongItemsArrayAt(int index, long[] items, int srcOffset, int length) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 8;
        MemorySegment.copy(items, srcOffset, this.wseg, ValueLayout.JAVA_LONG_UNALIGNED, (long)offset, length);
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentLevelZeroSortedFlag(this.wseg, sorted);
    }

    @Override
    void setMinK(int minK) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentMinK(this.wseg, minK);
    }

    @Override
    void setN(long n) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentN(this.wseg, n);
    }

    @Override
    void setNumLevels(int numLevels) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentNumLevels(this.wseg, numLevels);
    }

    @Override
    public boolean hasMemorySegment() {
        return this.wseg != null && this.wseg.scope().isAlive();
    }

    @Override
    public boolean isOffHeap() {
        return this.hasMemorySegment() && this.wseg.isNative();
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return MemorySegmentStatus.isSameResource(this.wseg, that);
    }

    @Override
    void setMemorySegment(MemorySegment wseg) {
        this.wseg = wseg;
    }
}

