/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import org.apache.datasketches.pig.quantiles.GetPmfFromDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetPmfFromDoublesSketchTest {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();

    @Test
    public void emptySketch() throws Exception {
        GetPmfFromDoublesSketch func = new GetPmfFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.5)));
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void normalCase() throws Exception {
        GetPmfFromDoublesSketch func = new GetPmfFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        for (int i = 1; i <= 10; ++i) {
            sketch.update((double)i);
        }
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 2.0, 7.0)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)0.1);
        Assert.assertEquals((double)((Double)resultTuple.get(1)), (double)0.5);
        Assert.assertEquals((double)((Double)resultTuple.get(2)), (double)0.4);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongNumberOfInputs() throws Exception {
        GetPmfFromDoublesSketch func = new GetPmfFromDoublesSketch();
        func.exec(tupleFactory.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetPmfFromDoublesSketch func = new GetPmfFromDoublesSketch();
        func.exec(tupleFactory.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeOfSplitPoint() throws Exception {
        GetPmfFromDoublesSketch func = new GetPmfFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 1)));
    }
}

