/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.frequencies;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class FrequentStringsSketchToEstimates
extends EvalFunc<DataBag> {
    private final ErrorType errorType;

    public FrequentStringsSketchToEstimates() {
        this.errorType = ErrorType.NO_FALSE_POSITIVES;
    }

    public FrequentStringsSketchToEstimates(String errorType) {
        this.errorType = ErrorType.valueOf((String)errorType);
    }

    public DataBag exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])dba.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        ItemsSketch.Row[] result = sketch.getFrequentItems(this.errorType);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < result.length; ++i) {
            Tuple tuple = TupleFactory.getInstance().newTuple(4);
            tuple.set(0, result[i].getItem());
            tuple.set(1, (Object)result[i].getEstimate());
            tuple.set(2, (Object)result[i].getLowerBound());
            tuple.set(3, (Object)result[i].getUpperBound());
            bag.add(tuple);
        }
        return bag;
    }

    public Schema outputSchema(Schema inputSchema) {
        Schema tupleSchema = new Schema();
        tupleSchema.add(new Schema.FieldSchema("item", 55));
        tupleSchema.add(new Schema.FieldSchema("estimate", 15));
        tupleSchema.add(new Schema.FieldSchema("lower_bound", 15));
        tupleSchema.add(new Schema.FieldSchema("upper_bound", 15));
        try {
            Schema bagSchema = new Schema(new Schema.FieldSchema("item_tuple", tupleSchema, 110));
            return new Schema(new Schema.FieldSchema("bag_of_item_tuples", bagSchema, 120));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

