/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.io.IOException;
import java.util.Arrays;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class GetQuantiles
extends EvalFunc<Tuple> {
    public Tuple exec(Tuple input) throws IOException {
        if (input.size() < 2) {
            throw new IllegalArgumentException("expected two or more inputs: sketch and list of fractions");
        }
        if (!(input.get(0) instanceof DataByteArray)) {
            throw new IllegalArgumentException("expected a DataByteArray as a sketch, got " + input.get(0).getClass().getSimpleName());
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])dba.get()));
        if (input.size() == 2) {
            Object arg = input.get(1);
            if (arg instanceof Integer) {
                return GetQuantiles.floatArrayToTuple(sketch.getQuantiles(((Integer)arg).intValue()));
            }
            if (arg instanceof Double) {
                return TupleFactory.getInstance().newTuple(Arrays.asList(Float.valueOf(sketch.getQuantile(((Double)arg).doubleValue()))));
            }
            throw new IllegalArgumentException("expected a double value as a fraction or an integer value as a number of evenly spaced intervals, got " + arg.getClass().getSimpleName());
        }
        double[] fractions = new double[input.size() - 1];
        for (int i = 1; i < input.size(); ++i) {
            if (!(input.get(i) instanceof Double)) {
                throw new IllegalArgumentException("expected a double value as a fraction, got " + input.get(i).getClass().getSimpleName());
            }
            fractions[i - 1] = (Double)input.get(i);
        }
        return GetQuantiles.floatArrayToTuple(sketch.getQuantiles(fractions));
    }

    private static Tuple floatArrayToTuple(float[] array) throws ExecException {
        Tuple tuple = TupleFactory.getInstance().newTuple(array.length);
        for (int i = 0; i < array.length; ++i) {
            tuple.set(i, (Object)Float.valueOf(array[i]));
        }
        return tuple;
    }
}

