/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericColumnDescriptor;

public class EmbedResultSetMetaData
implements ResultSetMetaData {
    private final ResultColumnDescriptor[] columnInfo;

    public EmbedResultSetMetaData(ResultColumnDescriptor[] columnInfo) {
        this.columnInfo = ArrayUtil.copy(columnInfo);
    }

    @Override
    public final int getColumnCount() {
        return this.columnInfo.length;
    }

    @Override
    public final boolean isAutoIncrement(int column) throws SQLException {
        this.validColumnNumber(column);
        ResultColumnDescriptor rcd = this.columnInfo[column - 1];
        return rcd.isAutoincrement();
    }

    @Override
    public final boolean isCaseSensitive(int column) throws SQLException {
        return DataTypeUtilities.isCaseSensitive(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final boolean isSearchable(int column) throws SQLException {
        this.validColumnNumber(column);
        return true;
    }

    @Override
    public final boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public final int isNullable(int column) throws SQLException {
        return DataTypeUtilities.isNullable(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final boolean isSigned(int column) throws SQLException {
        return DataTypeUtilities.isSigned(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final int getColumnDisplaySize(int column) throws SQLException {
        return DataTypeUtilities.getColumnDisplaySize(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final String getColumnLabel(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getName();
        return s == null ? "Column" + Integer.toString(column) : s;
    }

    @Override
    public final String getColumnName(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getName();
        return s == null ? "" : s;
    }

    @Override
    public final String getSchemaName(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getSourceSchemaName();
        return s == null ? "" : s;
    }

    @Override
    public final int getPrecision(int column) throws SQLException {
        return DataTypeUtilities.getDigitPrecision(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final int getScale(int column) throws SQLException {
        DataTypeDescriptor dtd = this.getColumnTypeDescriptor(column);
        return dtd.getScale();
    }

    @Override
    public final String getTableName(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getSourceTableName();
        return s == null ? "" : s;
    }

    @Override
    public final String getCatalogName(int column) throws SQLException {
        this.validColumnNumber(column);
        return "";
    }

    @Override
    public final int getColumnType(int column) throws SQLException {
        DataTypeDescriptor dtd = this.getColumnTypeDescriptor(column);
        return dtd.getTypeId().getJDBCTypeId();
    }

    @Override
    public final String getColumnTypeName(int column) throws SQLException {
        DataTypeDescriptor dtd = this.getColumnTypeDescriptor(column);
        return dtd.getTypeId().getSQLTypeName();
    }

    @Override
    public final boolean isReadOnly(int column) throws SQLException {
        this.validColumnNumber(column);
        return false;
    }

    @Override
    public final boolean isWritable(int column) throws SQLException {
        this.validColumnNumber(column);
        return this.columnInfo[column - 1].updatableByCursor();
    }

    @Override
    public final boolean isDefinitelyWritable(int column) throws SQLException {
        this.validColumnNumber(column);
        return false;
    }

    private void validColumnNumber(int column) throws SQLException {
        if (column < 1 || column > this.getColumnCount()) {
            throw Util.generateCsSQLException("S0022", column);
        }
    }

    private DataTypeDescriptor getColumnTypeDescriptor(int column) throws SQLException {
        this.validColumnNumber(column);
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        return cd.getType();
    }

    @Override
    public final String getColumnClassName(int column) throws SQLException {
        return this.getColumnTypeDescriptor(column).getTypeId().getResultSetMetaDataTypeName();
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String name, int jdcbTypeId, boolean nullable) {
        return new GenericColumnDescriptor(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdcbTypeId, nullable));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String name, int jdcbTypeId, boolean nullable, int length) {
        return new GenericColumnDescriptor(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdcbTypeId, nullable, length));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String name, DataTypeDescriptor dtd) {
        return new GenericColumnDescriptor(name, dtd);
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw Util.generateCsSQLException("XJ128.S", iface);
        }
    }
}

