/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public class TableName
extends QueryTreeNode {
    String tableName;
    String schemaName;
    private boolean hasSchema;

    TableName(String schemaName, String tableName, ContextManager cm) {
        super(cm);
        this.hasSchema = schemaName != null;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    TableName(String schemaName, String tableName, int tokBeginOffset, int tokEndOffset, ContextManager cm) {
        this(schemaName, tableName, cm);
        this.setBeginOffset(tokBeginOffset);
        this.setEndOffset(tokEndOffset);
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    String getFullTableName() {
        if (this.schemaName != null) {
            return this.schemaName + "." + this.tableName;
        }
        return this.tableName;
    }

    public String getFullSQLName() {
        return IdUtil.mkQualifiedName(this.schemaName, this.tableName);
    }

    @Override
    public String toString() {
        if (this.hasSchema) {
            return this.getFullTableName();
        }
        return this.tableName;
    }

    boolean equals(TableName otherTableName) {
        if (otherTableName == null) {
            return false;
        }
        String fullTableName = this.getFullTableName();
        if (fullTableName == null) {
            return true;
        }
        if (this.schemaName == null || otherTableName.getSchemaName() == null) {
            return this.tableName.equals(otherTableName.getTableName());
        }
        return fullTableName.equals(otherTableName.getFullTableName());
    }

    boolean equals(String otherSchemaName, String otherTableName) {
        String fullTableName = this.getFullTableName();
        if (fullTableName == null) {
            return true;
        }
        if (this.schemaName == null || otherSchemaName == null) {
            return this.tableName.equals(otherTableName);
        }
        return fullTableName.equals(otherSchemaName + "." + otherTableName);
    }

    public TableName cloneMe() {
        return new TableName(this.schemaName, this.tableName, this.getContextManager());
    }

    void bind() throws StandardException {
        this.schemaName = this.getSchemaDescriptor(this.schemaName).getSchemaName();
    }

    public int hashCode() {
        return this.getFullTableName().hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TableName)) {
            return false;
        }
        TableName that = (TableName)other;
        return this.getFullTableName().equals(that.getFullTableName());
    }
}

