/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.shared.common.sanity.SanityManager;

class UserTypeConstantNode
extends ConstantNode {
    Object val;

    UserTypeConstantNode(TypeId t, ContextManager cm) throws StandardException {
        super(t, true, -1, cm);
    }

    UserTypeConstantNode(Date d, ContextManager cm) throws StandardException {
        super(TypeId.getBuiltInTypeId(91), d == null, 10, cm);
        this.setValue(new SQLDate(d));
        this.val = d;
    }

    UserTypeConstantNode(Time t, ContextManager cm) throws StandardException {
        super(TypeId.getBuiltInTypeId(92), t == null, 8, cm);
        this.setValue(new SQLTime(t));
        this.val = t;
    }

    UserTypeConstantNode(Timestamp t, ContextManager cm) throws StandardException {
        super(TypeId.getBuiltInTypeId(93), t == null, 29, cm);
        this.setValue(new SQLTimestamp(t));
        this.val = t;
    }

    UserTypeConstantNode(DataValueDescriptor dvd, ContextManager cm) throws StandardException {
        super(UserTypeConstantNode.getTypeId(dvd), dvd == null, UserTypeConstantNode.getWidth(dvd), cm);
        this.setValue(dvd);
        this.val = dvd;
    }

    private static TypeId getTypeId(DataValueDescriptor dvd) {
        if (dvd != null) {
            switch (dvd.getTypeFormatId()) {
                case 298: {
                    return TypeId.getBuiltInTypeId(91);
                }
                case 299: {
                    return TypeId.getBuiltInTypeId(92);
                }
                case 31: {
                    return TypeId.getBuiltInTypeId(93);
                }
            }
            SanityManager.THROWASSERT("Unexpected class " + dvd.getClass().getName());
            return null;
        }
        return null;
    }

    private static int getWidth(DataValueDescriptor dvd) {
        if (dvd != null) {
            switch (dvd.getTypeFormatId()) {
                case 298: {
                    return 10;
                }
                case 299: {
                    return 8;
                }
                case 31: {
                    return 29;
                }
            }
            SanityManager.THROWASSERT("Unexpected class " + dvd.getClass().getName());
            return 0;
        }
        return 0;
    }

    public Object getObjectValue() {
        return this.val;
    }

    @Override
    boolean isNull() {
        return this.val == null;
    }

    @Override
    Object getConstantValueAsObject() {
        return this.val;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        TypeCompiler tc = this.getTypeCompiler();
        String fieldType = tc.interfaceName();
        if (this.val == null) {
            acb.generateNull(mb, tc, this.getTypeServices().getCollationType());
        } else {
            String typeName = this.getTypeId().getCorrespondingJavaTypeName();
            mb.push(this.val.toString());
            mb.callMethod((short)184, typeName, "valueOf", typeName, 1);
            LocalField field = acb.newFieldDeclaration(2, fieldType);
            acb.generateDataValue(mb, tc, this.getTypeServices().getCollationType(), field);
        }
    }

    @Override
    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.THROWASSERT("geneateConstant() not expected to be called for UserTypeConstantNode because we have implemented our own generateExpression().");
    }
}

