/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ProcedureTest
extends BaseJDBCTestCase {
    private static final String[] PROCEDURES = new String[]{"CREATE PROCEDURE RETRIEVE_DYNAMIC_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveDynamicResults' DYNAMIC RESULT SETS 4", "CREATE PROCEDURE RETRIEVE_CLOSED_RESULT() LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveClosedResult' DYNAMIC RESULT SETS 1", "CREATE PROCEDURE RETRIEVE_EXTERNAL_RESULT(DBNAME VARCHAR(128), DBUSER VARCHAR(128), DBPWD VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveExternalResult' DYNAMIC RESULT SETS 1", "CREATE PROCEDURE PROC_WITH_SIDE_EFFECTS(ret INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".procWithSideEffects' DYNAMIC RESULT SETS 2", "CREATE PROCEDURE NESTED_RESULT_SETS(proctext VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".nestedDynamicResultSets' DYNAMIC RESULT SETS 6", "CREATE PROCEDURE INT_OUT(OUT X INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".intOut'"};
    private static final String[][] TABLES = new String[][]{{"SIMPLE_TABLE", "CREATE TABLE SIMPLE_TABLE (id INT)"}};

    public ProcedureTest(String name) {
        super(name);
    }

    public void testExecuteQueryWithNoDynamicResultSets() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(0)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(1)");
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)rs);
        ProcedureTest.assertSame((Object)stmt, (Object)rs.getStatement());
        JDBC.assertDrainResultsHasData(rs);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(2)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets() throws SQLException {
        Statement stmt = this.createStatement();
        ProcedureTest.assertUpdateCount(stmt, 0, "CALL RETRIEVE_DYNAMIC_RESULTS(0)");
        JDBC.assertNoMoreResults(stmt);
    }

    public void testExecuteUpdateWithOneDynamicResultSet() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("CALL RETRIEVE_DYNAMIC_RESULTS(1)");
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
    }

    public void testExecuteQueryWithNoDynamicResultSets_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 0);
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 1);
        ResultSet rs = ps.executeQuery();
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)rs);
        ProcedureTest.assertSame((Object)ps, (Object)rs.getStatement());
        JDBC.assertDrainResultsHasData(rs);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 2);
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 0);
        ProcedureTest.assertUpdateCount(ps, 0);
        JDBC.assertNoMoreResults(ps);
    }

    public void testExecuteUpdateWithOneDynamicResultSet_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 1);
        try {
            ps.executeUpdate();
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
    }

    public void testExecuteQueryWithNoDynamicResultSets_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 0);
        try {
            cs.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 1);
        ResultSet rs = cs.executeQuery();
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)rs);
        ProcedureTest.assertSame((Object)cs, (Object)rs.getStatement());
        JDBC.assertDrainResultsHasData(rs);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 2);
        try {
            cs.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 0);
        ProcedureTest.assertUpdateCount(cs, 0);
        JDBC.assertNoMoreResults(cs);
    }

    public void testExecuteUpdateWithOneDynamicResultSet_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 1);
        try {
            cs.executeUpdate();
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
    }

    public void testRollbackStoredProcWithExecuteQuery() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(1)");
        rs.close();
        this.rollback();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWithExecuteUpdate() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CALL PROC_WITH_SIDE_EFFECTS(0)");
        this.rollback();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsNothing() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(0)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsTooMuch() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(2)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteUpdateReturnsResults() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("CALL PROC_WITH_SIDE_EFFECTS(1)");
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsNothing_prepared() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        ps.setInt(1, 0);
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
        Statement stmt = this.createStatement();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsTooMuch_prepared() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        ps.setInt(1, 2);
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
        Statement stmt = this.createStatement();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteUpdateReturnsResults_prepared() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        ps.setInt(1, 1);
        try {
            ps.executeUpdate();
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
        Statement stmt = this.createStatement();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testClosedDynamicResultSetsFromExecuteQuery() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("CALL RETRIEVE_CLOSED_RESULT()");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testClosedDynamicResultSetsFromExecuteUpdate() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CALL RETRIEVE_CLOSED_RESULT()");
        JDBC.assertNoMoreResults(stmt);
    }

    public void testDynamicResultSetsFromOtherConnectionWithExecuteQuery() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_EXTERNAL_RESULT(?,?,?)");
        ps.setString(1, this.getTestConfiguration().getDefaultDatabaseName());
        ps.setString(2, this.getTestConfiguration().getUserName());
        ps.setString(3, this.getTestConfiguration().getUserPassword());
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testDynamicResultSetsFromOtherConnectionWithExecuteUpdate() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_EXTERNAL_RESULT(?,?,?)");
        ps.setString(1, this.getTestConfiguration().getDefaultDatabaseName());
        ps.setString(2, this.getTestConfiguration().getUserName());
        ps.setString(3, this.getTestConfiguration().getUserPassword());
        ps.executeUpdate();
        JDBC.assertNoMoreResults(ps);
    }

    public void testGetBlobFromIntParameter() throws SQLException {
        CallableStatement cs = this.prepareCall("call int_out(?)");
        cs.registerOutParameter(1, 4);
        cs.execute();
        try {
            cs.getBlob(1);
            ProcedureTest.fail((String)"getBlob() on int parameter expected to fail");
        }
        catch (SQLException sqle) {
            ProcedureTest.assertSQLState("22005", sqle);
        }
    }

    public void testGetClobFromIntParameter() throws SQLException {
        CallableStatement cs = this.prepareCall("call int_out(?)");
        cs.registerOutParameter(1, 4);
        cs.execute();
        try {
            cs.getClob(1);
            ProcedureTest.fail((String)"getClob() on int parameter expected to fail");
        }
        catch (SQLException sqle) {
            ProcedureTest.assertSQLState("22005", sqle);
        }
    }

    public void testStatementSeverityErrorInProcedure() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create procedure proc_5280() language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".proc_5280' reads sql data");
        s.execute("call proc_5280()");
    }

    public static void proc_5280() throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement s = c.createStatement();
        try {
            s.execute("drop table this_table_does_not_exist");
            ProcedureTest.fail((String)"dropping non-existent table should fail");
        }
        catch (SQLException sqle) {
            ProcedureTest.assertSQLState("42Y55", sqle);
        }
        JDBC.assertSingleValueResultSet(s.executeQuery("values 1"), "1");
    }

    public void test_2515() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = conn.prepareStatement("create type price_2515 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        ps.execute();
        ps.close();
        ps = conn.prepareStatement("create procedure proc_2515\n(\n\tin passNumber int,\n\tout returnMessage varchar( 32672 ),\n\tinout bigintArg bigint,\n\tinout blobArg blob,\ninout booleanArg boolean,\ninout charArg char( 6 ),\ninout charForBitDataArg char( 3 ) for bit data,\ninout clobArg clob,\ninout dateArg date,\ninout decimalArg decimal,\ninout doubleArg double,\ninout intArg int,\ninout longVarcharArg long varchar,\ninout longVarcharForBitDataArg long varchar for bit data,\ninout realArg real,\ninout smallintArg smallint,\ninout timeArg time,\ninout timestampArg timestamp,\ninout priceArg price_2515,\ninout varcharArg varchar( 20 ),\ninout varcharForBitDataArg varchar( 3 ) for bit data\n)\nparameter style java language java no sql\nexternal name '" + ProcedureTest.class.getName() + ".proc_2515'");
        ps.execute();
        ps.close();
        CallableStatement cs = conn.prepareCall("call proc_2515( ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ? )");
        AllTypesTuple firstArgs = ProcedureTest.makeFirstAllTypesTuple();
        int idx = 2;
        cs.registerOutParameter(idx++, 12);
        cs.registerOutParameter(idx, -5);
        cs.setLong(idx++, (long)firstArgs.get_bigintArg());
        cs.registerOutParameter(idx, 2004);
        cs.setBlob(idx++, firstArgs.get_blobArg());
        cs.registerOutParameter(idx, 16);
        cs.setBoolean(idx++, (boolean)firstArgs.get_booleanArg());
        cs.registerOutParameter(idx, 1);
        cs.setString(idx++, firstArgs.get_charArg());
        cs.registerOutParameter(idx, -2);
        cs.setBytes(idx++, firstArgs.get_charForBitDataArg());
        cs.registerOutParameter(idx, 2005);
        cs.setClob(idx++, firstArgs.get_clobArg());
        cs.registerOutParameter(idx, 91);
        cs.setDate(idx++, firstArgs.get_dateArg());
        cs.registerOutParameter(idx, 3);
        cs.setBigDecimal(idx++, firstArgs.get_decimalArg());
        cs.registerOutParameter(idx, 8);
        cs.setDouble(idx++, (double)firstArgs.get_doubleArg());
        cs.registerOutParameter(idx, 4);
        cs.setInt(idx++, (int)firstArgs.get_intArg());
        cs.registerOutParameter(idx, -1);
        cs.setString(idx++, firstArgs.get_longVarcharArg());
        cs.registerOutParameter(idx, -4);
        cs.setBytes(idx++, firstArgs.get_longVarcharForBitDataArg());
        cs.registerOutParameter(idx, 7);
        cs.setFloat(idx++, firstArgs.get_realArg().floatValue());
        cs.registerOutParameter(idx, 5);
        cs.setShort(idx++, firstArgs.get_smallintArg().shortValue());
        cs.registerOutParameter(idx, 92);
        cs.setTime(idx++, firstArgs.get_timeArg());
        cs.registerOutParameter(idx, 93);
        cs.setTimestamp(idx++, firstArgs.get_timestampArg());
        cs.registerOutParameter(idx, 2000);
        cs.setObject(idx++, (Object)firstArgs.get_priceArg());
        cs.registerOutParameter(idx, 12);
        cs.setString(idx++, firstArgs.get_varcharArg());
        cs.registerOutParameter(idx, -3);
        cs.setBytes(idx++, firstArgs.get_varcharForBitDataArg());
        cs.setInt(1, 0);
        cs.execute();
        ProcedureTest.assertEquals((String)"", (String)cs.getString(2));
        ProcedureTest.assertEquals((String)"", (String)ProcedureTest.makeSecondAllTypesTuple().compare(this.getActualReturnArgs(cs)));
        cs.setInt(1, 1);
        cs.execute();
        ProcedureTest.assertEquals((String)"", (String)cs.getString(2));
        ProcedureTest.assertEquals((String)"", (String)ProcedureTest.makeThirdAllTypesTuple().compare(this.getActualReturnArgs(cs)));
        cs.setInt(1, 2);
        cs.execute();
        ProcedureTest.assertEquals((String)"", (String)cs.getString(2));
        ProcedureTest.assertEquals((String)"", (String)ProcedureTest.makeFourthAllTypesTuple().compare(this.getActualReturnArgs(cs)));
        ps = conn.prepareStatement("drop procedure proc_2515");
        ps.execute();
        ps.close();
        ps = conn.prepareStatement("drop type price_2515 restrict");
        ps.execute();
        ps.close();
    }

    private AllTypesTuple getActualReturnArgs(CallableStatement cs) throws Exception {
        int idx = 3;
        return new AllTypesTuple((Long)cs.getObject(idx++), (Blob)cs.getObject(idx++), (Boolean)cs.getObject(idx++), (String)cs.getObject(idx++), (byte[])cs.getObject(idx++), (Clob)cs.getObject(idx++), (Date)cs.getObject(idx++), (BigDecimal)cs.getObject(idx++), (Double)cs.getObject(idx++), (Integer)cs.getObject(idx++), (String)cs.getObject(idx++), (byte[])cs.getObject(idx++), (Float)cs.getObject(idx++), (Integer)cs.getObject(idx++), (Time)cs.getObject(idx++), (Timestamp)cs.getObject(idx++), (Price)cs.getObject(idx++), (String)cs.getObject(idx++), (byte[])cs.getObject(idx++));
    }

    public void testInOutParamNotSet() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create procedure proc_2516 (inout i int) language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".proc_2516' no sql");
        CallableStatement cs = this.prepareCall("call proc_2516(?)");
        cs.registerOutParameter(1, 4);
        ProcedureTest.assertStatementError("07000", cs);
        cs.setInt(1, 0);
        cs.execute();
        ProcedureTest.assertEquals((int)10, (int)cs.getInt(1));
        cs.clearParameters();
        ProcedureTest.assertStatementError("07000", cs);
        cs.setInt(1, 1);
        cs.execute();
        ProcedureTest.assertEquals((int)10, (int)cs.getInt(1));
    }

    public static void proc_2516(Integer[] i) {
        i[0] = 10;
    }

    public void testMaxNumberOfParameters() throws SQLException {
        this.testMaxNumberOfParameters(255, true);
        this.testMaxNumberOfParameters(256, false);
        this.testMaxNumberOfParameters(10000, false);
    }

    private void testMaxNumberOfParameters(int params, boolean methodExists) throws SQLException {
        String javaMethod = ((Object)((Object)this)).getClass().getName() + ".procWithManyParams";
        String sqlProc = "PROC_WITH_LOTS_OF_PARAMETERS";
        this.setAutoCommit(false);
        StringBuffer sb = new StringBuffer("create procedure ");
        sb.append("PROC_WITH_LOTS_OF_PARAMETERS").append('(');
        for (int i = 0; i < params; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('p').append(i).append(" int");
        }
        sb.append(") language java parameter style java external name '");
        sb.append(javaMethod).append("' no sql");
        Statement s = this.createStatement();
        s.execute(sb.toString());
        DatabaseMetaData dmd = this.getConnection().getMetaData();
        JDBC.assertFullResultSet(dmd.getProcedures(null, null, "PROC_WITH_LOTS_OF_PARAMETERS"), (Object[][])new Object[][]{{"", "APP", "PROC_WITH_LOTS_OF_PARAMETERS", null, null, null, javaMethod, 1, new JDBC.GeneratedId()}}, false);
        JDBC.assertDrainResults(dmd.getProcedureColumns(null, null, "PROC_WITH_LOTS_OF_PARAMETERS", "%"), params);
        sb.setLength(0);
        sb.append("call ").append("PROC_WITH_LOTS_OF_PARAMETERS").append('(');
        for (int i = 0; i < params; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(i);
        }
        sb.append(')');
        if (methodExists) {
            s.execute(sb.toString());
        } else {
            this.assertCallError("42X50", sb.toString());
        }
        this.rollback();
    }

    public static void procWithManyParams(int p001, int p002, int p003, int p004, int p005, int p006, int p007, int p008, int p009, int p010, int p011, int p012, int p013, int p014, int p015, int p016, int p017, int p018, int p019, int p020, int p021, int p022, int p023, int p024, int p025, int p026, int p027, int p028, int p029, int p030, int p031, int p032, int p033, int p034, int p035, int p036, int p037, int p038, int p039, int p040, int p041, int p042, int p043, int p044, int p045, int p046, int p047, int p048, int p049, int p050, int p051, int p052, int p053, int p054, int p055, int p056, int p057, int p058, int p059, int p060, int p061, int p062, int p063, int p064, int p065, int p066, int p067, int p068, int p069, int p070, int p071, int p072, int p073, int p074, int p075, int p076, int p077, int p078, int p079, int p080, int p081, int p082, int p083, int p084, int p085, int p086, int p087, int p088, int p089, int p090, int p091, int p092, int p093, int p094, int p095, int p096, int p097, int p098, int p099, int p100, int p101, int p102, int p103, int p104, int p105, int p106, int p107, int p108, int p109, int p110, int p111, int p112, int p113, int p114, int p115, int p116, int p117, int p118, int p119, int p120, int p121, int p122, int p123, int p124, int p125, int p126, int p127, int p128, int p129, int p130, int p131, int p132, int p133, int p134, int p135, int p136, int p137, int p138, int p139, int p140, int p141, int p142, int p143, int p144, int p145, int p146, int p147, int p148, int p149, int p150, int p151, int p152, int p153, int p154, int p155, int p156, int p157, int p158, int p159, int p160, int p161, int p162, int p163, int p164, int p165, int p166, int p167, int p168, int p169, int p170, int p171, int p172, int p173, int p174, int p175, int p176, int p177, int p178, int p179, int p180, int p181, int p182, int p183, int p184, int p185, int p186, int p187, int p188, int p189, int p190, int p191, int p192, int p193, int p194, int p195, int p196, int p197, int p198, int p199, int p200, int p201, int p202, int p203, int p204, int p205, int p206, int p207, int p208, int p209, int p210, int p211, int p212, int p213, int p214, int p215, int p216, int p217, int p218, int p219, int p220, int p221, int p222, int p223, int p224, int p225, int p226, int p227, int p228, int p229, int p230, int p231, int p232, int p233, int p234, int p235, int p236, int p237, int p238, int p239, int p240, int p241, int p242, int p243, int p244, int p245, int p246, int p247, int p248, int p249, int p250, int p251, int p252, int p253, int p254, int p255) {
    }

    private void assertNoResultSetFromExecuteQuery(SQLException sqle) {
        ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y78", sqle);
    }

    private void assertMultipleResultsFromExecuteQuery(SQLException sqle) {
        ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y78", sqle);
    }

    private void assertResultsFromExecuteUpdate(SQLException sqle) {
        ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y79", sqle);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ProcedureTest");
        suite.addTest(ProcedureTest.baseSuite("ProcedureTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ProcedureTest.baseSuite("ProcedureTest:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        if (!JDBC.vmSupportsJDBC3()) {
            return suite;
        }
        suite.addTestSuite(ProcedureTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                int i;
                for (i = 0; i < PROCEDURES.length; ++i) {
                    s.execute(PROCEDURES[i]);
                }
                for (i = 0; i < TABLES.length; ++i) {
                    s.execute(TABLES[i][1]);
                }
            }
        };
    }

    public void setUp() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement s = this.createStatement();
        for (int i = 0; i < TABLES.length; ++i) {
            s.execute("DELETE FROM " + TABLES[i][0]);
        }
        this.commit();
    }

    public static void retrieveDynamicResults(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        c.close();
    }

    public static void retrieveClosedResult(ResultSet[] closed) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        closed[0] = c.createStatement().executeQuery("VALUES(1)");
        closed[0].close();
        c.close();
    }

    public static void retrieveExternalResult(String dbName, String user, String password, ResultSet[] external) throws SQLException {
        String url = "jdbc:derby:" + dbName;
        Connection conn = DriverManager.getConnection(url, user, password);
        external[0] = conn.createStatement().executeQuery("VALUES(1)");
    }

    public static void procWithSideEffects(int returnResults, ResultSet[] rs1, ResultSet[] rs2) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = c.createStatement();
        stmt.executeUpdate("INSERT INTO SIMPLE_TABLE VALUES (42)");
        if (returnResults > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (returnResults > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        c.close();
    }

    public static void nestedDynamicResultSets(String procedureText, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ResultSet[] rs5, ResultSet[] rs6) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        CallableStatement cs = c.prepareCall("CALL " + procedureText);
        cs.execute();
        rs6[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs3[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs4[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs2[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs1[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs5[0] = cs.getResultSet();
    }

    public static void intOut(int[] out) {
        out[0] = 42;
    }

    public static AllTypesTuple makeFirstAllTypesTuple() throws Exception {
        return new AllTypesTuple(1L, (Blob)new HarmonySerialBlob(new byte[]{1, 1, 1}), Boolean.TRUE, "firstt", new byte[]{1, 1, 1}, (Clob)new HarmonySerialClob("firstt"), new Date(1L), new BigDecimal("1"), 1.0, 1, new String("firstt"), new byte[]{1, 1, 1}, Float.valueOf(1.0f), 1, new Time(1L), new Timestamp(1L), new Price("USD", new BigDecimal("1"), new Timestamp(1L)), "firstt", new byte[]{1, 1, 1});
    }

    public static AllTypesTuple makeSecondAllTypesTuple() throws Exception {
        return new AllTypesTuple(2L, (Blob)new HarmonySerialBlob(new byte[]{2, 2, 2}), Boolean.FALSE, "second", new byte[]{2, 2, 2}, (Clob)new HarmonySerialClob("second"), new Date(2L), new BigDecimal("2"), 2.0, 2, new String("second"), new byte[]{2, 2, 2}, Float.valueOf(2.0f), 2, new Time(2L), new Timestamp(2L), new Price("USD", new BigDecimal("2"), new Timestamp(2L)), "second", new byte[]{2, 2, 2});
    }

    public static AllTypesTuple makeThirdAllTypesTuple() throws Exception {
        return new AllTypesTuple(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static AllTypesTuple makeFourthAllTypesTuple() throws Exception {
        return ProcedureTest.makeFirstAllTypesTuple();
    }

    public static void proc_2515(int passNumber, String[] message, Long[] bigintArg, Blob[] blobArg, Boolean[] booleanArg, String[] charArg, byte[][] charForBitDataArg, Clob[] clobArg, Date[] dateArg, BigDecimal[] decimalArg, Double[] doubleArg, Integer[] intArg, String[] longVarcharArg, byte[][] longVarcharForBitDataArg, Float[] realArg, Integer[] smallintArg, Time[] timeArg, Timestamp[] timestampArg, Price[] priceArg, String[] varcharArg, byte[][] varcharForBitDataArg) throws Exception {
        AllTypesTuple returnSignature;
        AllTypesTuple expectedCallSignature;
        AllTypesTuple actualCallSignature = new AllTypesTuple(bigintArg[0], blobArg[0], booleanArg[0], charArg[0], charForBitDataArg[0], clobArg[0], dateArg[0], decimalArg[0], doubleArg[0], intArg[0], longVarcharArg[0], longVarcharForBitDataArg[0], realArg[0], smallintArg[0], timeArg[0], timestampArg[0], priceArg[0], varcharArg[0], varcharForBitDataArg[0]);
        switch (passNumber) {
            case 0: {
                expectedCallSignature = ProcedureTest.makeFirstAllTypesTuple();
                returnSignature = ProcedureTest.makeSecondAllTypesTuple();
                break;
            }
            case 1: {
                expectedCallSignature = ProcedureTest.makeSecondAllTypesTuple();
                returnSignature = ProcedureTest.makeThirdAllTypesTuple();
                break;
            }
            default: {
                expectedCallSignature = ProcedureTest.makeThirdAllTypesTuple();
                returnSignature = ProcedureTest.makeFourthAllTypesTuple();
            }
        }
        message[0] = expectedCallSignature.compare(actualCallSignature);
        bigintArg[0] = returnSignature.get_bigintArg();
        blobArg[0] = returnSignature.get_blobArg();
        booleanArg[0] = returnSignature.get_booleanArg();
        charArg[0] = returnSignature.get_charArg();
        charForBitDataArg[0] = returnSignature.get_charForBitDataArg();
        clobArg[0] = returnSignature.get_clobArg();
        dateArg[0] = returnSignature.get_dateArg();
        decimalArg[0] = returnSignature.get_decimalArg();
        doubleArg[0] = returnSignature.get_doubleArg();
        intArg[0] = returnSignature.get_intArg();
        longVarcharArg[0] = returnSignature.get_longVarcharArg();
        longVarcharForBitDataArg[0] = returnSignature.get_longVarcharForBitDataArg();
        realArg[0] = returnSignature.get_realArg();
        smallintArg[0] = returnSignature.get_smallintArg();
        timeArg[0] = returnSignature.get_timeArg();
        timestampArg[0] = returnSignature.get_timestampArg();
        priceArg[0] = returnSignature.get_priceArg();
        varcharArg[0] = returnSignature.get_varcharArg();
        varcharForBitDataArg[0] = returnSignature.get_varcharForBitDataArg();
    }

    public void testGetMoreResults() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table MRS.FIVERS(i integer)");
        PreparedStatement ps = this.prepareStatement("insert into MRS.FIVERS values (?)");
        for (int i = 1; i <= 20; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        s.executeUpdate("create procedure MRS.FIVEJP() parameter style JAVA READS SQL DATA dynamic result sets 5 language java external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.fivejp'");
        CallableStatement cs = this.prepareCall("CALL MRS.FIVEJP()");
        Object[] allRS = new ResultSet[5];
        this.defaultGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.closeCurrentGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.keepCurrentGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.mixedGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.checkExecuteClosesResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.checkCSCloseClosesResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        CallableStatement nestedCs = this.prepareCall("CALL NESTED_RESULT_SETS('MRS.FIVEJP()')");
        this.defaultGetMoreResults(nestedCs, (ResultSet[])allRS);
    }

    private void checkExecuteClosesResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        int pass = 0;
        do {
            allRS[pass++] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[pass - 1].getStatement());
        } while (cs.getMoreResults(2));
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
        cs.execute();
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void checkCSCloseClosesResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        int pass = 0;
        do {
            allRS[pass++] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[pass - 1].getStatement());
        } while (cs.getMoreResults(2));
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
        cs.close();
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void mixedGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        cs.execute();
        allRS[0] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[0].getStatement());
        boolean moreRS = cs.getMoreResults(2);
        if (!moreRS) {
            ProcedureTest.fail((String)"FAIL - no second result set");
        }
        allRS[1] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[1].getStatement());
        allRS[0].next();
        ProcedureTest.assertEquals((int)2, (int)allRS[0].getInt(1));
        allRS[1].next();
        ProcedureTest.assertEquals((int)3, (int)allRS[1].getInt(1));
        moreRS = cs.getMoreResults(1);
        if (!moreRS) {
            ProcedureTest.fail((String)"FAIL - no third result set");
        }
        allRS[2] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[2].getStatement());
        ProcedureTest.assertEquals((int)2, (int)allRS[0].getInt(1));
        JDBC.assertClosed(allRS[1]);
        allRS[2].next();
        ProcedureTest.assertEquals((int)4, (int)allRS[2].getInt(1));
        moreRS = cs.getMoreResults(2);
        if (!moreRS) {
            ProcedureTest.fail((String)"FAIL - no fourth result set");
        }
        allRS[3] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[3].getStatement());
        allRS[3].next();
        ProcedureTest.assertEquals((int)2, (int)allRS[0].getInt(1));
        JDBC.assertClosed(allRS[1]);
        ProcedureTest.assertEquals((int)4, (int)allRS[2].getInt(1));
        ProcedureTest.assertEquals((int)5, (int)allRS[3].getInt(1));
        moreRS = cs.getMoreResults(3);
        if (!moreRS) {
            ProcedureTest.fail((String)"FAIL - no fifth result set");
        }
        allRS[4] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[4].getStatement());
        allRS[4].next();
        JDBC.assertClosed(allRS[0]);
        JDBC.assertClosed(allRS[1]);
        JDBC.assertClosed(allRS[2]);
        JDBC.assertClosed(allRS[3]);
        ProcedureTest.assertEquals((int)6, (int)allRS[4].getInt(1));
        moreRS = cs.getMoreResults(2);
        if (moreRS) {
            ProcedureTest.fail((String)"FAIL - too many result sets");
        }
        JDBC.assertClosed(allRS[0]);
        JDBC.assertClosed(allRS[1]);
        JDBC.assertClosed(allRS[2]);
        JDBC.assertClosed(allRS[3]);
        ProcedureTest.assertEquals((int)6, (int)allRS[4].getInt(1));
        allRS[4].close();
    }

    private void keepCurrentGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            ProcedureTest.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                ProcedureTest.assertTrue((boolean)cs.getMoreResults(2));
                continue;
            }
            ProcedureTest.assertFalse((boolean)cs.getMoreResults(2));
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
    }

    private void closeCurrentGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            ProcedureTest.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                ProcedureTest.assertTrue((boolean)cs.getMoreResults(1));
                continue;
            }
            ProcedureTest.assertFalse((boolean)cs.getMoreResults(1));
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void defaultGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            ProcedureTest.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                ProcedureTest.assertTrue((boolean)cs.getMoreResults());
                continue;
            }
            ProcedureTest.assertFalse((boolean)cs.getMoreResults());
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    public static final class AllTypesTuple {
        private Long _bigintArg;
        private Blob _blobArg;
        private Boolean _booleanArg;
        private String _charArg;
        private byte[] _charForBitDataArg;
        private Clob _clobArg;
        private Date _dateArg;
        private BigDecimal _decimalArg;
        private Double _doubleArg;
        private Integer _intArg;
        private String _longVarcharArg;
        private byte[] _longVarcharForBitDataArg;
        private Float _realArg;
        private Integer _smallintArg;
        private Time _timeArg;
        private Timestamp _timestampArg;
        private Price _priceArg;
        private String _varcharArg;
        private byte[] _varcharForBitDataArg;

        public AllTypesTuple(Long bigintArg, Blob blobArg, Boolean booleanArg, String charArg, byte[] charForBitDataArg, Clob clobArg, Date dateArg, BigDecimal decimalArg, Double doubleArg, Integer intArg, String longVarcharArg, byte[] longVarcharForBitDataArg, Float realArg, Integer smallintArg, Time timeArg, Timestamp timestampArg, Price priceArg, String varcharArg, byte[] varcharForBitDataArg) {
            this._bigintArg = bigintArg;
            this._blobArg = blobArg;
            this._booleanArg = booleanArg;
            this._charArg = charArg;
            this._charForBitDataArg = charForBitDataArg;
            this._clobArg = clobArg;
            this._dateArg = dateArg;
            this._decimalArg = decimalArg;
            this._doubleArg = doubleArg;
            this._intArg = intArg;
            this._longVarcharArg = longVarcharArg;
            this._longVarcharForBitDataArg = longVarcharForBitDataArg;
            this._realArg = realArg;
            this._smallintArg = smallintArg;
            this._timeArg = timeArg;
            this._timestampArg = timestampArg;
            this._priceArg = priceArg;
            this._varcharArg = varcharArg;
            this._varcharForBitDataArg = varcharForBitDataArg;
        }

        public Long get_bigintArg() {
            return this._bigintArg;
        }

        public Blob get_blobArg() {
            return this._blobArg;
        }

        public Boolean get_booleanArg() {
            return this._booleanArg;
        }

        public String get_charArg() {
            return this._charArg;
        }

        public byte[] get_charForBitDataArg() {
            return this._charForBitDataArg;
        }

        public Clob get_clobArg() {
            return this._clobArg;
        }

        public Date get_dateArg() {
            return this._dateArg;
        }

        public BigDecimal get_decimalArg() {
            return this._decimalArg;
        }

        public Double get_doubleArg() {
            return this._doubleArg;
        }

        public Integer get_intArg() {
            return this._intArg;
        }

        public String get_longVarcharArg() {
            return this._longVarcharArg;
        }

        public byte[] get_longVarcharForBitDataArg() {
            return this._longVarcharForBitDataArg;
        }

        public Float get_realArg() {
            return this._realArg;
        }

        public Integer get_smallintArg() {
            return this._smallintArg;
        }

        public Time get_timeArg() {
            return this._timeArg;
        }

        public Timestamp get_timestampArg() {
            return this._timestampArg;
        }

        public Price get_priceArg() {
            return this._priceArg;
        }

        public String get_varcharArg() {
            return this._varcharArg;
        }

        public byte[] get_varcharForBitDataArg() {
            return this._varcharForBitDataArg;
        }

        public String compare(AllTypesTuple that) throws Exception {
            String message = "";
            message = message + this.compare("_bigintArg", this._bigintArg, that._bigintArg);
            message = message + this.compare("_blobArg", this.getBlobBytes(), that.getBlobBytes());
            message = message + this.compare("_booleanArg", this._booleanArg, that._booleanArg);
            message = message + this.compare("_charArg", this._charArg, that._charArg);
            message = message + this.compare("_charForBitDataArg", this._charForBitDataArg, that._charForBitDataArg);
            message = message + this.compare("_clobArg", this.getClobString(), that.getClobString());
            message = message + this.compare("_dateArg", this.getDateString(), that.getDateString());
            message = message + this.compare("_decimalArg", this._decimalArg, that._decimalArg);
            message = message + this.compare("_doubleArg", this._doubleArg, that._doubleArg);
            message = message + this.compare("_intArg", this._intArg, that._intArg);
            message = message + this.compare("_longVarcharArg", this._longVarcharArg, that._longVarcharArg);
            message = message + this.compare("_longVarcharForBitDataArg", this._longVarcharForBitDataArg, that._longVarcharForBitDataArg);
            message = message + this.compare("_realArg", this._realArg, that._realArg);
            message = message + this.compare("_smallintArg", this._smallintArg, that._smallintArg);
            message = message + this.compare("_timeArg", this.getTimeString(), that.getTimeString());
            message = message + this.compare("_timestampArg", this._timestampArg, that._timestampArg);
            message = message + this.compare("_priceArg", this._priceArg, that._priceArg);
            message = message + this.compare("_varcharArg", this._varcharArg, that._varcharArg);
            message = message + this.compare("_varcharForBitDataArg", this._varcharForBitDataArg, that._varcharForBitDataArg);
            return message;
        }

        private byte[] getBlobBytes() throws Exception {
            if (this._blobArg == null) {
                return null;
            }
            return this._blobArg.getBytes(1L, (int)this._blobArg.length());
        }

        private String getClobString() throws Exception {
            if (this._clobArg == null) {
                return null;
            }
            return this._clobArg.getSubString(1L, (int)this._clobArg.length());
        }

        private String getDateString() {
            if (this._dateArg == null) {
                return null;
            }
            return this._dateArg.toString();
        }

        private String getTimeString() {
            if (this._timeArg == null) {
                return null;
            }
            return this._timeArg.toString();
        }

        private String compare(String argName, Object left, Object right) {
            if (left == null) {
                if (right == null) {
                    return "";
                }
                return argName + ": left was null but right was " + right;
            }
            if (right == null) {
                return argName + ": left = " + left + " but right is null";
            }
            if (left instanceof byte[]) {
                return this.compareBytes(argName, (byte[])left, (byte[])right);
            }
            if (left.equals(right)) {
                return "";
            }
            return argName + ": left = " + left + " but right = " + right;
        }

        private String compareBytes(String argName, byte[] left, byte[] right) {
            int count = left.length;
            if (count != right.length) {
                return argName + ": left count = " + count + " but right count = " + right.length;
            }
            for (int i = 0; i < count; ++i) {
                if (left[i] == right[i]) continue;
                return argName + ": left[ " + i + " ] = " + left[i] + " but right[ " + i + " ] = " + right[i];
            }
            return "";
        }
    }
}

