/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURBaseTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURDataModelSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SURTest
extends SURBaseTest {
    public SURTest(String name) {
        super(name);
    }

    public void testConcurrencyModeWarning1() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 order by a");
        SQLWarning warn = rs.getWarnings();
        SURTest.assertEquals((String)"Expected resultset to be read only", (int)1007, (int)rs.getConcurrency());
        this.assertWarning(warn, "01J06");
        this.scrollForward(rs);
        rs.close();
        s.close();
    }

    public void testConcurrencyModeWarning2() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 as table1,t1 as table2 where table1.a=table2.a");
        SQLWarning warn = rs.getWarnings();
        SURTest.assertEquals((String)"Expected resultset to be read only", (int)1007, (int)rs.getConcurrency());
        this.assertWarning(warn, "01J06");
        this.scrollForward(rs);
        rs.close();
        s.close();
    }

    public void testForUpdateException1() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        try {
            String queryString = "select * from t1 order by a for update";
            s.setCursorName(this.getNextCursorName());
            ResultSet rs = s.executeQuery(queryString);
            SURTest.assertTrue((String)("Expected query '" + queryString + "' to fail"), (boolean)false);
        }
        catch (SQLException e) {
            SURTest.assertEquals((String)"Unexpected SQLState", (String)"42Y90", (String)e.getSQLState());
        }
        this.rollback();
        s.close();
    }

    public void testForUpdateException2() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        try {
            String queryString = "select * from t1 as table1,t1 as table2 where table1.a=table2.a for update";
            s.setCursorName(this.getNextCursorName());
            ResultSet rs = s.executeQuery(queryString);
            SURTest.assertTrue((String)("Expected query '" + queryString + "' to fail"), (boolean)false);
        }
        catch (SQLException e) {
            SURTest.assertEquals((String)"Unexpected SQLState", (String)"42Y90", (String)e.getSQLState());
        }
        this.rollback();
        s.close();
    }

    public void testForwardOnlyReadOnly1() throws SQLException {
        Statement s = this.createStatement(1003, 1007);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        this.scrollForward(rs);
        rs.close();
        s.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet1() throws SQLException {
        Statement s = this.createStatement(1003, 1007);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        this.assertFailOnUpdate(rs);
        s.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet2() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 order by id");
        rs.next();
        this.assertFailOnUpdate(rs);
        s.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet3() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 for read only");
        rs.next();
        this.assertFailOnUpdate(rs);
        s.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet4() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 where a=1 for read only");
        rs.next();
        this.verifyTuple(rs);
        this.assertFailOnUpdate(rs);
        s.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet5() throws SQLException {
        Statement s = this.createStatement(1004, 1007);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 where a=1 for read only");
        rs.next();
        this.verifyTuple(rs);
        this.assertFailOnUpdate(rs);
        s.close();
    }

    public void testCursorStateAfterCommit1() throws SQLException {
        this.testCursorStateAfterCommit(false, 1003);
    }

    public void testCursorStateAfterCommit2() throws SQLException {
        this.testCursorStateAfterCommit(false, 1004);
    }

    public void testCursorStateAfterCommit3() throws SQLException {
        this.testCursorStateAfterCommit(true, 1003);
    }

    public void testCursorStateAfterCommit4() throws SQLException {
        this.testCursorStateAfterCommit(true, 1004);
    }

    private void testCursorStateAfterCommit(boolean positioned, int resultSetType) throws SQLException {
        Statement s = this.createStatement(resultSetType, 1008);
        String cursorName = this.getNextCursorName();
        s.setCursorName(cursorName);
        ResultSet rs = s.executeQuery("select a from t1");
        int recordToUpdate = 5;
        if (resultSetType == 1003) {
            for (int i = 0; i < 5; ++i) {
                rs.next();
            }
        } else {
            rs.absolute(5);
        }
        this.commit();
        PreparedStatement ps = this.prepareStatement("update t1 set a=? where current of " + cursorName);
        try {
            if (positioned) {
                ps.setInt(1, -1);
                ps.executeUpdate();
                SURTest.fail((String)"Expected exception to be thrown on positioned update since cursor is not positioned");
            } else {
                rs.updateInt(1, -1);
                rs.updateRow();
                SURTest.fail((String)"Expected exception to be thrown on updateRow() since cursor is not positioned");
            }
        }
        catch (SQLException e) {
            SURTest.assertSQLState("Unexpected SQLState when updating row after commit", "24000", e);
        }
        if (resultSetType == 1003) {
            rs.next();
        } else {
            rs.relative(0);
        }
        if (positioned) {
            ps.setInt(1, -1);
            ps.executeUpdate();
        } else {
            rs.updateInt(1, -1);
            rs.updateRow();
        }
        s.close();
        ps.close();
    }

    public void testMultiUpdateRow1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.absolute(5);
        int oldCol2 = rs.getInt(2);
        int newCol2 = -2222;
        int oldCol3 = rs.getInt(3);
        int newCol3 = -3333;
        rs.updateInt(2, -2222);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateInt", (int)-2222, (int)rs.getInt(2));
        rs.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected updateXXX to have no effect after cancelRowUpdated", (int)oldCol2, (int)rs.getInt(2));
        rs.updateInt(2, -2222);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateInt", (int)-2222, (int)rs.getInt(2));
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false before updateRow", (!rs.rowUpdated() ? 1 : 0) != 0);
        rs.updateRow();
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be true after updateRow", (boolean)rs.rowUpdated());
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow", (int)-2222, (int)rs.getInt(2));
        rs.updateInt(3, -3333);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateInt", (int)-3333, (int)rs.getInt(3));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow", (int)-2222, (int)rs.getInt(2));
        rs.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected updateXXX to have no effect after cancelRowUpdated", (int)oldCol3, (int)rs.getInt(3));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow after cancelRowUpdated", (int)-2222, (int)rs.getInt(2));
        rs.updateInt(3, -3333);
        rs.updateRow();
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateInt", (int)-3333, (int)rs.getInt(3));
        rs.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previousupdateRow after cancelRowUpdates", (int)-2222, (int)rs.getInt(2));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previousupdateRow after cancelRowUpdates", (int)-3333, (int)rs.getInt(3));
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be true after updateRow and cancelRowUpdates", (boolean)rs.rowUpdated());
        rs.close();
        s.close();
    }

    public void testMultiUpdateRow2() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.absolute(5);
        int oldCol2 = rs.getInt(2);
        int oldCol3 = rs.getInt(3);
        rs.updateNull(2);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateNull", (int)0, (int)rs.getInt(2));
        SURTest.assertTrue((String)"Expected wasNull to be true after updateNull", (boolean)rs.wasNull());
        rs.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected updateXXX to have no effect after cancelRowUpdated", (int)oldCol2, (int)rs.getInt(2));
        rs.updateNull(2);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateNull", (int)0, (int)rs.getInt(2));
        SURTest.assertTrue((String)"Expected wasNull to be true after updateNull", (boolean)rs.wasNull());
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false before updateRow", (!rs.rowUpdated() ? 1 : 0) != 0);
        rs.updateRow();
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be true after updateRow", (boolean)rs.rowUpdated());
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow", (int)0, (int)rs.getInt(2));
        rs.updateNull(3);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateNull", (int)0, (int)rs.getInt(3));
        SURTest.assertTrue((String)"Expected wasNull to be true after updateNull", (boolean)rs.wasNull());
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow", (int)0, (int)rs.getInt(2));
        rs.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected updateXXX to have no effect after cancelRowUpdated", (int)oldCol3, (int)rs.getInt(3));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow after cancelRowUpdated", (int)0, (int)rs.getInt(2));
        rs.updateNull(3);
        rs.updateRow();
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateNull", (int)0, (int)rs.getInt(3));
        rs.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previousupdateRow after cancelRowUpdates", (int)0, (int)rs.getInt(2));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previousupdateRow after cancelRowUpdates", (int)0, (int)rs.getInt(3));
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be true after updateRow and cancelRowUpdates", (boolean)rs.rowUpdated());
        rs.close();
        s.close();
    }

    public void testCursorOperationConflictWarning1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        this.createStatement().executeUpdate("delete from t1 where id=" + rs.getString("ID"));
        int newValue = -3333;
        int oldValue = rs.getInt(2);
        rs.updateInt(2, -3333);
        rs.updateRow();
        SQLWarning warn = rs.getWarnings();
        this.assertWarning(warn, "01001");
        SURTest.assertEquals((String)"Did not expect the resultset to be updated", (int)oldValue, (int)rs.getInt(2));
        SURTest.assertTrue((String)"Expected rs.rowDeleted() to be false", (!rs.rowDeleted() ? 1 : 0) != 0);
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false", (!rs.rowUpdated() ? 1 : 0) != 0);
        rs.clearWarnings();
        rs.deleteRow();
        warn = rs.getWarnings();
        this.assertWarning(warn, "01001");
        rs.relative(0);
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false", (!rs.rowUpdated() ? 1 : 0) != 0);
        SURTest.assertTrue((String)"Expected rs.rowDeleted() to be false", (!rs.rowDeleted() ? 1 : 0) != 0);
        SURTest.assertEquals((String)"Did not expect the resultset to be updated", (int)oldValue, (int)rs.getInt(2));
        rs.close();
        s.close();
    }

    public void testCursorOperationConflictWarning2() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        this.createStatement().executeUpdate("delete from t1 where id=" + rs.getString("ID"));
        int newValue = -3333;
        int oldValue = rs.getInt(2);
        Statement s3 = this.createStatement();
        int updateCount = s3.executeUpdate("update t1 set A=-3333 where current of " + rs.getCursorName());
        rs.relative(0);
        SQLWarning warn = s3.getWarnings();
        this.assertWarning(warn, "01001");
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false", (!rs.rowUpdated() ? 1 : 0) != 0);
        SURTest.assertTrue((String)"Expected rs.rowDeleted() to be false", (!rs.rowDeleted() ? 1 : 0) != 0);
        SURTest.assertEquals((String)"Did not expect the resultset to be updated", (int)oldValue, (int)rs.getInt(2));
        SURTest.assertEquals((String)"Expected update count to be 0", (int)0, (int)updateCount);
        Statement s4 = this.createStatement();
        updateCount = s4.executeUpdate("delete from t1 where current of " + rs.getCursorName());
        rs.relative(0);
        warn = s4.getWarnings();
        this.assertWarning(warn, "01001");
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false", (!rs.rowUpdated() ? 1 : 0) != 0);
        SURTest.assertTrue((String)"Expected rs.rowDeleted() to be false", (!rs.rowDeleted() ? 1 : 0) != 0);
        SURTest.assertEquals((String)"Did not expect the resultset to be updated", (int)oldValue, (int)rs.getInt(2));
        SURTest.assertEquals((String)"Expected update count to be 0", (int)0, (int)updateCount);
        rs.close();
        s.close();
        s3.close();
        s4.close();
    }

    public void testIndexedUpdateCursor1() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 where a=1");
        SURTest.assertTrue((String)"Expected to get a tuple on rs.next()", (boolean)rs.next());
        this.verifyTuple(rs);
        this.updateTuple(rs);
        s.close();
    }

    public void testIndexedUpdateCursor2() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 where a=1 for update");
        SURTest.assertTrue((String)"Expected to get a tuple on rs.next()", (boolean)rs.next());
        this.verifyTuple(rs);
        this.updateTuple(rs);
        s.close();
    }

    public void testInsertRowWithScrollCursor() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.last();
        int lastRow = rs.getRow();
        rs.beforeFirst();
        rs.next();
        int currentPosition = rs.getRow();
        rs.moveToInsertRow();
        rs.updateInt(1, currentPosition + 1000);
        rs.next();
        SURTest.assertEquals((String)("CurrentPosition should be " + (currentPosition + 1)), (int)rs.getRow(), (int)(currentPosition + 1));
        rs.deleteRow();
        currentPosition = rs.getRow();
        rs.moveToInsertRow();
        rs.updateInt(1, currentPosition + 1000);
        rs.relative(2);
        SURTest.assertEquals((String)("CurrentPosition should be " + (currentPosition + 2)), (int)rs.getRow(), (int)(currentPosition + 2));
        rs.deleteRow();
        currentPosition = rs.getRow();
        rs.moveToInsertRow();
        rs.updateInt(1, currentPosition + 1000);
        rs.absolute(6);
        SURTest.assertEquals((String)"CurrentPosition should be 6", (int)rs.getRow(), (int)6);
        rs.deleteRow();
        currentPosition = rs.getRow();
        rs.moveToInsertRow();
        rs.updateInt(1, currentPosition + 1000);
        rs.previous();
        SURTest.assertEquals((String)("CurrentPosition should be " + (currentPosition - 1)), (int)rs.getRow(), (int)(currentPosition - 1));
        rs.deleteRow();
        currentPosition = rs.getRow();
        rs.moveToInsertRow();
        rs.updateInt(1, currentPosition + 1000);
        rs.first();
        SURTest.assertEquals((String)"CurrentPosition should be 1", (int)rs.getRow(), (int)1);
        SURTest.assertTrue((String)"isFirst() should return true", (boolean)rs.isFirst());
        rs.deleteRow();
        currentPosition = rs.getRow();
        rs.moveToInsertRow();
        rs.updateInt(1, currentPosition + 1000);
        rs.last();
        SURTest.assertEquals((String)("CurrentPosition should be " + lastRow), (int)rs.getRow(), (int)lastRow);
        SURTest.assertTrue((String)"isLast() should return true", (boolean)rs.isLast());
        rs.deleteRow();
        currentPosition = rs.getRow();
        rs.moveToInsertRow();
        rs.updateInt(1, currentPosition + 1000);
        rs.beforeFirst();
        SURTest.assertTrue((String)"isBeforeFirst() should return true", (boolean)rs.isBeforeFirst());
        rs.next();
        SURTest.assertEquals((String)"CurrentPosition should be 1", (int)rs.getRow(), (int)1);
        SURTest.assertTrue((String)"isFirst() should return true", (boolean)rs.isFirst());
        currentPosition = rs.getRow();
        rs.moveToInsertRow();
        rs.updateInt(1, currentPosition + 1000);
        rs.afterLast();
        SURTest.assertTrue((String)"isAfterLast() should return true", (boolean)rs.isAfterLast());
        rs.previous();
        SURTest.assertEquals((String)("CurrentPosition should be " + lastRow), (int)rs.getRow(), (int)lastRow);
        SURTest.assertTrue((String)"isLast() should return true", (boolean)rs.isLast());
        rs.previous();
        currentPosition = rs.getRow();
        rs.moveToInsertRow();
        rs.updateInt(1, currentPosition + 1000);
        rs.insertRow();
        rs.moveToCurrentRow();
        SURTest.assertEquals((String)("CurrentPosition should be " + currentPosition), (int)rs.getRow(), (int)currentPosition);
        try {
            rs.moveToInsertRow();
            rs.updateInt(1, currentPosition + 2000);
            rs.updateRow();
        }
        catch (SQLException se) {
            SURTest.assertEquals((String)"Expected exception", (String)se.getSQLState().substring(0, 5), (String)"24000");
        }
        try {
            rs.moveToInsertRow();
            rs.updateInt(1, currentPosition + 2000);
            rs.deleteRow();
        }
        catch (SQLException se) {
            SURTest.assertEquals((String)"Expected exception", (String)se.getSQLState().substring(0, 5), (String)"24000");
        }
        try {
            rs.moveToCurrentRow();
            rs.updateInt(1, currentPosition + 2000);
            rs.insertRow();
        }
        catch (SQLException se) {
            SURTest.assertEquals((String)"Expected exception", (String)se.getSQLState().substring(0, 5), (String)"XJ086");
        }
        rs.close();
        s.close();
    }

    public void testIndexedScrollInsensitiveUpdateCursorWithoutForUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 where a=1 or a=2");
        rs.next();
        rs.next();
        rs.previous();
        this.verifyTuple(rs);
        this.updateTuple(rs);
        s.close();
    }

    public void testIndexedScrollInsensitiveUpdateCursorWithForUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 where a=1 or a=2 for update");
        rs.next();
        rs.next();
        rs.previous();
        this.verifyTuple(rs);
        this.updateTuple(rs);
        rs.close();
        s.close();
    }

    public void testPrimaryKeyUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.last();
        rs.next();
        while (rs.previous()) {
            int key = rs.getInt(1);
            if (key % 2 != 0) continue;
            int newKey = -key;
            rs.updateInt(1, newKey);
            rs.updateRow();
        }
        PreparedStatement ps = this.prepareStatement("select * from t1 where id=?");
        for (int i = 0; i < this.recordCount; ++i) {
            int key = i % 2 == 0 ? -i : i;
            ps.setInt(1, key);
            ResultSet rs2 = ps.executeQuery();
            SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)rs2.next());
            SURTest.println("T1: Read Tuple:(" + rs2.getInt(1) + "," + rs2.getInt(2) + "," + rs2.getInt(3) + ")");
            SURTest.assertEquals((String)"Unexpected value of id", (int)key, (int)rs2.getInt(1));
            SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next returned another row", (!rs2.next() ? 1 : 0) != 0);
        }
        s.close();
        ps.close();
    }

    public void testOtherPrimaryKeyUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.last();
        int primaryKey = rs.getInt(1);
        PreparedStatement ps = this.prepareStatement("update t1 set id = ? where id= ?");
        ps.setInt(1, -primaryKey);
        ps.setInt(2, primaryKey);
        SURTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)ps.executeUpdate());
        rs.updateInt(2, -555);
        rs.updateInt(3, -777);
        rs.updateRow();
        PreparedStatement ps2 = this.prepareStatement("select * from t1 where id=?");
        ps2.setInt(1, -primaryKey);
        ResultSet rs2 = ps2.executeQuery();
        SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)rs2.next());
        SURTest.println("T1: Read Tuple:(" + rs2.getInt(1) + "," + rs2.getInt(2) + "," + rs2.getInt(3) + ")");
        SURTest.assertEquals((String)"Expected a=-555", (int)-555, (int)rs2.getInt(2));
        SURTest.assertEquals((String)"Expected b=-777", (int)-777, (int)rs2.getInt(3));
        SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next() returned another row", (!rs2.next() ? 1 : 0) != 0);
        s.close();
        ps.close();
        ps2.close();
    }

    public void testOtherAndOwnPrimaryKeyUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.last();
        int primaryKey = rs.getInt(1);
        PreparedStatement ps = this.prepareStatement("update t1 set id = ? where id= ?");
        ps.setInt(1, -primaryKey);
        ps.setInt(2, primaryKey);
        SURTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)ps.executeUpdate());
        rs.updateInt(1, primaryKey * 10);
        rs.updateInt(2, -555);
        rs.updateInt(3, -777);
        rs.updateRow();
        PreparedStatement ps2 = this.prepareStatement("select * from t1 where id=?");
        ps2.setInt(1, primaryKey * 10);
        ResultSet rs2 = ps2.executeQuery();
        SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)rs2.next());
        SURTest.println("T1: Read Tuple:(" + rs2.getInt(1) + "," + rs2.getInt(2) + "," + rs2.getInt(3) + ")");
        SURTest.assertEquals((String)"Expected a=-555", (int)-555, (int)rs2.getInt(2));
        SURTest.assertEquals((String)"Expected b=-777", (int)-777, (int)rs2.getInt(3));
        SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next() returned another row", (!rs2.next() ? 1 : 0) != 0);
        s.close();
        ps.close();
        ps2.close();
    }

    public void testMultipleKeyUpdates() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.last();
        int primaryKey = rs.getInt(1);
        PreparedStatement ps = s.getConnection().prepareStatement("update t1 set id = ? where id= ?");
        ps.setInt(1, -primaryKey);
        ps.setInt(2, primaryKey);
        SURTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)ps.executeUpdate());
        ps.close();
        rs.updateInt(1, primaryKey * 10);
        rs.updateInt(2, -555);
        rs.updateInt(3, -777);
        rs.updateRow();
        rs.first();
        rs.last();
        for (int i = 0; i < 10; ++i) {
            rs.first();
            rs.last();
            rs.next();
            rs.previous();
            rs.updateInt(1, primaryKey * 10 + i);
            rs.updateInt(2, -555 - i);
            rs.updateInt(3, -777 - i);
            rs.updateRow();
        }
        rs.close();
        s.close();
    }

    public void testSecondaryIndexKeyUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.last();
        rs.next();
        int newKey = 0;
        while (rs.previous()) {
            rs.updateInt(2, newKey--);
            rs.updateRow();
        }
        PreparedStatement ps = this.prepareStatement("select * from t1 where a=?");
        for (int i = 0; i < this.recordCount; ++i) {
            int key = -i;
            ps.setInt(1, key);
            ResultSet rs2 = ps.executeQuery();
            SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)rs2.next());
            SURTest.println("T1: Read Tuple:(" + rs2.getInt(1) + "," + rs2.getInt(2) + "," + rs2.getInt(3) + ")");
            SURTest.assertEquals((String)"Unexpected value of id", (int)key, (int)rs2.getInt(2));
            SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next returned another row", (!rs2.next() ? 1 : 0) != 0);
        }
        s.close();
        ps.close();
    }

    public void testOtherSecondaryKeyUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        rs.last();
        int indexedKey = rs.getInt(2);
        PreparedStatement ps = this.prepareStatement("update t1 set a = ? where a= ?");
        ps.setInt(1, -indexedKey);
        ps.setInt(2, indexedKey);
        SURTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)ps.executeUpdate());
        rs.updateInt(1, -555);
        rs.updateInt(3, -777);
        rs.updateRow();
        PreparedStatement ps2 = this.prepareStatement("select * from t1 where a=?");
        ps2.setInt(1, -indexedKey);
        ResultSet rs2 = ps2.executeQuery();
        SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)rs2.next());
        SURTest.println("T1: Read Tuple:(" + rs2.getInt(1) + "," + rs2.getInt(2) + "," + rs2.getInt(3) + ")");
        SURTest.assertEquals((String)"Expected id=-555", (int)-555, (int)rs2.getInt(1));
        SURTest.assertEquals((String)"Expected b=-777", (int)-777, (int)rs2.getInt(3));
        SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next() returned another row", (!rs2.next() ? 1 : 0) != 0);
        s.close();
        ps.close();
        ps2.close();
    }

    public void testScrollInsensitiveReadOnly1() throws SQLException {
        Statement s = this.createStatement(1004, 1007);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        this.scrollForward(rs);
        this.scrollBackward(rs);
        rs.close();
        s.close();
    }

    public void testForwardOnlyConcurUpdatableWithForUpdate1() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 for update");
        this.scrollForwardAndUpdate(rs);
        rs.close();
        s.close();
    }

    public void testForwardOnlyConcurUpdatableWithoutForUpdate1() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        this.scrollForwardAndUpdate(rs);
        rs.close();
        s.close();
    }

    public void testPositionedUpdateWithoutForUpdate1() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        s.setCursorName("MYCURSOR");
        ResultSet rs = s.executeQuery("select * from t1");
        this.scrollForwardAndUpdatePositioned(rs);
        rs.close();
        s.close();
    }

    public void testPositionedUpdateWithForUpdate1() throws SQLException {
        Statement s = this.createStatement();
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 for update");
        this.scrollForwardAndUpdatePositioned(rs);
        rs.close();
        s.close();
    }

    public void testScrollablePositionedUpdateWithForUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1007);
        s.setCursorName("MYCURSOR");
        ResultSet rs = s.executeQuery("select * from t1 for update");
        rs.next();
        int pKey = rs.getInt(1);
        rs.previous();
        rs.next();
        SURTest.assertEquals((String)"Expecting to be on the same row after previous() + next() ", (int)pKey, (int)rs.getInt(1));
        rs.next();
        rs.previous();
        SURTest.assertEquals((String)"Expecting to be on the same row after next() + previous()", (int)pKey, (int)rs.getInt(1));
        int previousA = rs.getInt(2);
        int previousB = rs.getInt(3);
        SURTest.println(rs.getCursorName());
        PreparedStatement ps = this.prepareStatement("update T1 set a=?,b=? where current of " + rs.getCursorName());
        ps.setInt(1, 666);
        ps.setInt(2, 777);
        ps.executeUpdate();
        rs.next();
        rs.previous();
        SURTest.assertEquals((String)"Expected to be on the same row after next() + previous()", (int)pKey, (int)rs.getInt(1));
        SURTest.assertEquals((String)"Expected row to be updated by own change,  however did not get updated value for column a", (int)666, (int)rs.getInt(2));
        SURTest.assertEquals((String)"Expected row to be updated by own change, however did not get updated value for column b", (int)777, (int)rs.getInt(3));
        rs.close();
        s.setCursorName(this.getNextCursorName());
        rs = s.executeQuery("select * from t1 order by b");
        while (rs.next()) {
            if (rs.getInt(1) == pKey) {
                SURTest.assertEquals((String)("Expected row with primary key = " + pKey + " to be updated"), (int)666, (int)rs.getInt(2));
                SURTest.assertEquals((String)("Expected row with primary key = " + pKey + " to be updated"), (int)777, (int)rs.getInt(3));
                continue;
            }
            SURTest.println("Got tuple (" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + "," + rs.getString(4) + ")");
        }
        s.close();
        ps.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithForUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 for update");
        this.scrollForwardAndUpdate(rs);
        rs.close();
        s.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithForUpdate2() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        SURTest.assertEquals((String)"Invalid resultset concurrency on statement", (int)1008, (int)s.getResultSetConcurrency());
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1 for update");
        SURTest.assertEquals((String)"Invalid resultset concurrency on resultset", (int)1008, (int)rs.getConcurrency());
        this.scrollForward(rs);
        this.scrollBackwardAndUpdate(rs);
        rs.close();
        s.close();
    }

    private void testScrollInsensistiveConurUpdatable3(ResultSet rs) throws SQLException {
        int a;
        int id;
        while (rs.next()) {
        }
        while (rs.previous()) {
            int a2 = rs.getInt(1);
            int b = rs.getInt(2);
            id = b - 17 - a2;
            int newA = 1000;
            int newB = id + newA + 17;
            rs.updateInt(1, newA);
            rs.updateInt(2, newB);
            rs.updateRow();
            SURTest.assertEquals((String)"Expected a to be 1000", (int)1000, (int)rs.getInt(1));
        }
        int count = 0;
        while (rs.next()) {
            a = rs.getInt(1);
            SURTest.assertEquals((String)("Incorrect row updated for row " + ++count), (int)1000, (int)a);
        }
        SURTest.assertEquals((String)"Expected count to be the same as number of records", (int)this.recordCount, (int)count);
        while (rs.previous()) {
            a = rs.getInt(1);
            SURTest.assertEquals((String)("Incorrect row updated for row " + --count), (int)1000, (int)a);
        }
        rs.close();
        Statement s = this.createStatement(1003, 1007);
        s.setCursorName(this.getNextCursorName());
        rs = s.executeQuery("select * from t1");
        while (rs.next()) {
            id = rs.getInt(1);
            int a3 = rs.getInt(2);
            int b = rs.getInt(3);
            SURTest.println("Updated tuple:" + id + "," + a3 + "," + b);
        }
        s.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithForUpdate3() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select a,b from t1 for update");
        this.testScrollInsensistiveConurUpdatable3(rs);
        s.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithoutForUpdate1() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        this.scrollForwardAndUpdate(rs);
        rs.close();
        s.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithoutForUpdate2() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select * from t1");
        this.scrollForward(rs);
        this.scrollBackwardAndUpdate(rs);
        rs.close();
        s.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithoutForUpdate3() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select a,b from t1");
        this.testScrollInsensistiveConurUpdatable3(rs);
        s.close();
    }

    public void testForUpdateWithColumnList() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select c from t1 for update of c");
        rs.next();
        rs.updateString(1, "foobar");
        rs.updateRow();
        rs.next();
        rs.previous();
        SURTest.assertEquals((String)"foobar", (String)rs.getString(1));
        rs.close();
        rs = s.executeQuery("select id from t1 for update of id");
        rs.next();
        rs.updateInt(1, 20);
        rs.updateRow();
        rs.next();
        rs.previous();
        SURTest.assertEquals((int)20, (int)rs.getInt(1));
        rs.close();
        rs = s.executeQuery("select * from t1 for update of id");
        rs.next();
        rs.updateInt(1, 20);
        rs.updateRow();
        rs.next();
        rs.previous();
        SURTest.assertEquals((int)20, (int)rs.getInt(1));
        rs.close();
        rs = s.executeQuery("SELECT * from t1 for update of c");
        rs.next();
        int id = rs.getInt(1);
        int a = rs.getInt(2);
        int b = rs.getInt(3);
        rs.updateString(4, "foobar");
        rs.updateRow();
        rs.next();
        rs.previous();
        SURTest.assertEquals((int)id, (int)rs.getInt(1));
        SURTest.assertEquals((int)a, (int)rs.getInt(2));
        SURTest.assertEquals((int)b, (int)rs.getInt(3));
        SURTest.assertEquals((String)"foobar", (String)rs.getString(4));
        rs.close();
        rs = s.executeQuery("SELECT * from t1 for update of id,a,b,c");
        rs.next();
        rs.updateInt(1, -20);
        rs.updateInt(2, 20);
        rs.updateInt(3, 21);
        rs.updateString(4, "foobar");
        rs.updateRow();
        rs.next();
        rs.previous();
        SURTest.assertEquals((int)-20, (int)rs.getInt(1));
        SURTest.assertEquals((int)20, (int)rs.getInt(2));
        SURTest.assertEquals((int)21, (int)rs.getInt(3));
        SURTest.assertEquals((String)"foobar", (String)rs.getString(4));
        rs.close();
        rs = s.executeQuery("SELECT * from t1 for update of id, a,b,c");
        rs.next();
        rs.updateInt(1, 20);
        rs.updateRow();
        rs.next();
        rs.previous();
        SURTest.assertEquals((int)20, (int)rs.getInt(1));
        rs.close();
        rs = s.executeQuery("SELECT id from t1 for update of id, c");
        String cursorname = rs.getCursorName();
        rs.next();
        Statement s2 = this.createStatement();
        s2.executeUpdate("update t1 set c='foobar' where current of " + cursorname);
        s2.close();
        rs.next();
        rs.previous();
        rs.getInt(1);
        rs.close();
        rs = s.executeQuery("SELECT id from t1 for update");
        cursorname = rs.getCursorName();
        rs.next();
        s2 = this.createStatement();
        s2.executeUpdate("update t1 set c='foobar' where current of " + cursorname);
        s2.close();
        rs.next();
        rs.previous();
        rs.getInt(1);
        rs.close();
        rs = s.executeQuery("SELECT id,a,id from t1");
        rs.next();
        rs.updateInt(1, 20);
        rs.updateRow();
        rs.next();
        rs.previous();
        SURTest.assertEquals((int)20, (int)rs.getInt(1));
        SURTest.assertEquals((int)20, (int)rs.getInt(3));
        rs.close();
        rs = s.executeQuery("SELECT id,a,id from t1 for update of id");
        rs.next();
        try {
            rs.updateInt(3, 20);
            SURTest.fail((String)"should fail");
        }
        catch (SQLException e) {
            String sqlState = SURTest.usingEmbedded() ? "42X31" : "XJ124";
            SURTest.assertSQLState(sqlState, e);
        }
        rs.close();
        rs = s.executeQuery("SELECT id,a,id from t1 for update");
        rs.next();
        rs.updateInt(3, 20);
        rs.updateRow();
        SURTest.assertEquals((int)20, (int)rs.getInt(1));
        SURTest.assertEquals((int)20, (int)rs.getInt(3));
        rs.next();
        rs.previous();
        SURTest.assertEquals((int)20, (int)rs.getInt(1));
        SURTest.assertEquals((int)20, (int)rs.getInt(3));
        rs.close();
        s.close();
    }

    private void checkDetectabilityCallsOutsideRow(ResultSet rs, String state) {
        boolean b;
        try {
            b = rs.rowUpdated();
            SURTest.fail((String)("rowUpdated while " + state + " did not throw exception: " + b));
        }
        catch (SQLException e) {
            SURTest.assertEquals((String)e.getSQLState(), (String)"24000");
        }
        try {
            b = rs.rowDeleted();
            SURTest.fail((String)("rowdeleted while " + state + " did not throw exception: " + b));
        }
        catch (SQLException e) {
            SURTest.assertEquals((String)e.getSQLState(), (String)"24000");
        }
        try {
            b = rs.rowInserted();
            SURTest.fail((String)("rowInserted while " + state + " did not throw exception: " + b));
        }
        catch (SQLException e) {
            SURTest.assertEquals((String)e.getSQLState(), (String)"24000");
        }
    }

    public void testRowUpdatedAndRowDeleted() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.getNextCursorName());
        ResultSet rs = s.executeQuery("select a,b from t1");
        rs.next();
        rs.updateInt(1, rs.getInt(1) + 2 * this.recordCount);
        rs.updateRow();
        SURTest.assertTrue((String)"Expected rowUpdated() to return true", (boolean)rs.rowUpdated());
        rs.deleteRow();
        rs.next();
        rs.previous();
        SURTest.assertTrue((String)"Expected rowUpdated() to return true", (boolean)rs.rowUpdated());
        SURTest.assertTrue((String)"Expected rowDeleted() to return true", (boolean)rs.rowDeleted());
        rs.next();
        SURTest.assertFalse((String)"Expected rowUpdated() to return false", (boolean)rs.rowUpdated());
        SURTest.assertFalse((String)"Expected rowDeleted() to return false", (boolean)rs.rowDeleted());
        rs.previous();
        SURTest.assertTrue((String)"Expected rowUpdated() to return true", (boolean)rs.rowUpdated());
        SURTest.assertTrue((String)"Expected rowDeleted() to return true", (boolean)rs.rowDeleted());
        rs.close();
        s.close();
    }

    public void testDetectabilityExceptions() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        this.checkDetectabilityCallsOutsideRow(rs, "before positioning");
        rs.moveToInsertRow();
        this.checkDetectabilityCallsOutsideRow(rs, "on insertRow before positioning");
        rs.next();
        rs.moveToInsertRow();
        this.checkDetectabilityCallsOutsideRow(rs, "on insertRow");
        rs.moveToCurrentRow();
        rs.beforeFirst();
        this.checkDetectabilityCallsOutsideRow(rs, "on beforeFirst row");
        rs.afterLast();
        this.checkDetectabilityCallsOutsideRow(rs, "on afterLast row");
        rs.first();
        rs.deleteRow();
        this.checkDetectabilityCallsOutsideRow(rs, "after deleteRow");
        rs.last();
        rs.deleteRow();
        this.checkDetectabilityCallsOutsideRow(rs, "after deleteRow of last row");
        rs.close();
        s.close();
        s = this.createStatement(1003, 1008);
        rs = s.executeQuery("select * from t1");
        this.checkDetectabilityCallsOutsideRow(rs, "before FO positioning");
        rs.moveToInsertRow();
        this.checkDetectabilityCallsOutsideRow(rs, "on insertRow before FO positioning");
        rs.next();
        rs.moveToInsertRow();
        this.checkDetectabilityCallsOutsideRow(rs, "on FO insertRow");
        rs.next();
        rs.updateInt(2, 666);
        rs.updateRow();
        this.checkDetectabilityCallsOutsideRow(rs, "after FO updateRow");
        rs.next();
        rs.deleteRow();
        this.checkDetectabilityCallsOutsideRow(rs, "after FO deleteRow");
        while (rs.next()) {
        }
        this.checkDetectabilityCallsOutsideRow(rs, "after FO emptied out");
        rs.close();
        s.close();
    }

    public void testDowngradeToScrollReadOnly() throws SQLException {
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select * from t1 order by b");
        this.assertWarning(rs.getWarnings(), "01J06");
        rs.next();
        rs.next();
        rs.previous();
        rs.relative(1);
        rs.absolute(3);
        rs.relative(-1);
        rs.first();
        rs.last();
        rs.beforeFirst();
        rs.afterLast();
        rs.close();
        s.close();
    }

    private final String getNextCursorName() {
        return "MYCURSOR";
    }

    public static Test suite() {
        BaseTestSuite mainSuite = new BaseTestSuite("SURTest");
        mainSuite.addTest(SURTest.baseSuite("SURTest:embedded"));
        mainSuite.addTest(TestConfiguration.clientServerDecorator(SURTest.baseSuite("SURTest:client")));
        return mainSuite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite mainSuite = new BaseTestSuite(name);
        for (SURDataModelSetup.SURDataModel model : SURDataModelSetup.SURDataModel.values()) {
            BaseTestSuite suite = new BaseTestSuite(SURTest.class);
            SURDataModelSetup decorator = new SURDataModelSetup((Test)suite, model);
            mainSuite.addTest((Test)decorator);
        }
        return mainSuite;
    }
}

