/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class AggregateClassLoadingTest
extends BaseJDBCTestCase {
    public AggregateClassLoadingTest(String name) {
        super(name);
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        return SecurityManagerSetup.noSecurityManager((Test)new CleanDatabaseTestSetup((Test)new BaseTestSuite(AggregateClassLoadingTest.class, "AggregateClassLoadingTest")){
            private ClassLoader originalLoader;

            @Override
            protected void setUp() throws Exception {
                this.originalLoader = Thread.currentThread().getContextClassLoader();
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                Thread.currentThread().setContextClassLoader(this.originalLoader);
                super.tearDown();
            }

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table t (i int)");
                s.execute("insert into t values 1,2,3,4,5,6,null,4,5,456,2,4,6,7,2144,44,2,-2,4");
                URL derbyURL = s.getConnection().getClass().getProtectionDomain().getCodeSource().getLocation();
                URLClassLoader cl = new URLClassLoader(new URL[]{derbyURL}, null);
                Thread.currentThread().setContextClassLoader(cl);
                super.decorateSQL(s);
            }
        });
    }

    public void testAggregateMAX() throws SQLException {
        this.testAggregate("select MAX(i) from t");
    }

    public void testAggregateMIN() throws SQLException {
        this.testAggregate("select MIN(i) from t");
    }

    public void testAggregateAVG() throws SQLException {
        this.testAggregate("select AVG(i) from t");
    }

    public void testAggregateCOUNT() throws SQLException {
        this.testAggregate("select COUNT(i) from t");
    }

    public void testAggregateCOUNT2() throws SQLException {
        this.testAggregate("select COUNT(*) from t");
    }

    private void testAggregate(String query) throws SQLException {
        Statement s = this.createStatement();
        JDBC.assertDrainResults(s.executeQuery(query), 1);
        s.close();
    }
}

