/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class GetPropertyInfoTest {
    static String protocol = "jdbc:derby:";
    static String url = "EncryptedDB;create=true;dataEncryption=true";
    static String driver = "org.apache.derby.jdbc.EmbeddedDriver";

    public static void main(String[] args) throws SQLException, InterruptedException, Exception {
        boolean passed = true;
        String provider = System.getProperty("testEncryptionProvider");
        if (provider != null) {
            url = "EncryptedDB;create=true;dataEncryption=true;encryptionProvider=" + provider;
        }
        System.out.println("Test GetPropertyInfoTest starting");
        try {
            int k;
            String[] choices;
            int j;
            DriverPropertyInfo[] attributes;
            int i;
            Properties info = new Properties();
            Class<?> clazz = Class.forName(driver);
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Driver cDriver = DriverManager.getDriver(protocol);
            boolean canConnect = false;
            for (i = 0; i < 2; ++i) {
                attributes = cDriver.getPropertyInfo(protocol + url, info);
                if (attributes.length == 0) {
                    canConnect = true;
                    break;
                }
                for (j = 0; j < attributes.length; ++j) {
                    System.out.print(attributes[j].name + " - value: " + attributes[j].value);
                    choices = attributes[j].choices;
                    System.out.print(" - description: " + attributes[j].description + " - required " + attributes[j].required);
                    if (choices != null) {
                        for (k = 0; k < choices.length; ++k) {
                            System.out.print("     - choices [" + k + "] : " + choices[k]);
                        }
                        System.out.print("\n");
                        continue;
                    }
                    System.out.print(" - choices null \n");
                }
                url = url + ";bootPassword=db2everyplace";
            }
            if (!canConnect) {
                System.out.println("More attributes are required to connect to the database");
                passed = false;
            } else {
                Connection conn = DriverManager.getConnection(protocol + url, info);
                conn.close();
            }
            canConnect = false;
            info.put("create", "true");
            info.put("dataEncryption", "true");
            info.put("bootPassword", "db2everyplace");
            if (provider != null) {
                info.put("encryptionProvider", provider);
            }
            for (i = 0; i < 2; ++i) {
                attributes = cDriver.getPropertyInfo(protocol, info);
                if (attributes.length == 0) {
                    canConnect = true;
                    break;
                }
                for (j = 0; j < attributes.length; ++j) {
                    System.out.print(attributes[j].name + " - value: " + attributes[j].value);
                    choices = attributes[j].choices;
                    System.out.print(" - description: " + attributes[j].description + " - required " + attributes[j].required);
                    if (choices != null) {
                        for (k = 0; k < choices.length; ++k) {
                            System.out.print("     - choices [" + k + "] : " + choices[k]);
                        }
                        System.out.print("\n");
                        continue;
                    }
                    System.out.print(" - choices null \n");
                }
                info.put("databaseName", "EncryptedDB1");
            }
            if (!canConnect) {
                System.out.println("More attributes are required to connect to the database");
                passed = false;
            } else {
                Connection conn1 = DriverManager.getConnection(protocol, info);
                conn1.close();
            }
        }
        catch (SQLException sqle) {
            passed = false;
            do {
                System.out.println(sqle.getSQLState() + ":" + sqle.getMessage());
            } while ((sqle = sqle.getNextException()) != null);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception caught in main():\n");
            System.out.println(e.getMessage());
            e.printStackTrace();
            passed = false;
        }
        if (passed) {
            System.out.println("Test GetPropertyInfoTest finished");
        } else {
            System.out.println("Test GetPropertyInfoTest failed");
        }
    }
}

