/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import junit.framework.AssertionFailedError;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.DataSourceConnector;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectionPoolDataSourceConnector
implements Connector {
    private TestConfiguration config;
    private ConnectionPoolDataSource ds;

    @Override
    public void setConfiguration(TestConfiguration config) {
        this.config = config;
        this.ds = J2EEDataSource.getConnectionPoolDataSource(config, null);
        ConnectionPoolDataSourceConnector.enableStatementPooling(this.ds);
    }

    private static void enableStatementPooling(ConnectionPoolDataSource ds) {
        try {
            J2EEDataSource.setBeanProperty(ds, "maxStatements", 2);
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    @Override
    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getPooledConnection().getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getPooledConnection().getConnection();
        }
    }

    @Override
    public Connection openConnection(String databaseName) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getPooledConnection().getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            ConnectionPoolDataSource tmpDs = this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config));
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getPooledConnection().getConnection();
        }
    }

    @Override
    public Connection openConnection(String user, String password) throws SQLException {
        try {
            return this.ds.getPooledConnection(user, password).getConnection();
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getPooledConnection(user, password).getConnection();
        }
    }

    @Override
    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        return this.openConnection(databaseName, user, password, null);
    }

    @Override
    public Connection openConnection(String databaseName, String user, String password, Properties connectionProperties) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getPooledConnection(user, password).getConnection();
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            HashMap<String, Object> hm = DataSourceConnector.makeCreateDBAttributes(this.config);
            DataSourceConnector.copyProperties(connectionProperties, hm);
            ConnectionPoolDataSource tmpDs = this.singleUseDS(hm);
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getPooledConnection(user, password).getConnection();
        }
    }

    @Override
    public void shutDatabase() throws SQLException {
        this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config)).getPooledConnection().getConnection();
        this.config.waitForShutdownComplete(this.getDatabaseName());
    }

    @Override
    public void shutEngine(boolean deregisterDriver) throws SQLException {
        SanityManager.ASSERT((boolean)deregisterDriver);
        ConnectionPoolDataSource tmpDs = this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config));
        JDBCDataSource.setBeanProperty(tmpDs, "databaseName", "");
        tmpDs.getPooledConnection();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public String getDatabaseName() {
        String databaseName = null;
        try {
            databaseName = (String)JDBCDataSource.getBeanProperty(this.ds, "databaseName");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return databaseName;
    }

    private ConnectionPoolDataSource singleUseDS(HashMap hm) throws SQLException {
        ConnectionPoolDataSource sds = J2EEDataSource.getConnectionPoolDataSource(this.config, hm);
        ConnectionPoolDataSourceConnector.enableStatementPooling(sds);
        return sds;
    }
}

