/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.i18n.MessageService;

public class CloseFilterInputStream
extends FilterInputStream {
    private static final String MESSAGE = MessageService.getTextMessage("J104", new Object[0]);
    private boolean closed;

    public CloseFilterInputStream(InputStream in) {
        super(in);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    @Override
    public int available() throws IOException {
        this.checkIfClosed();
        return super.available();
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkIfClosed();
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkIfClosed();
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkIfClosed();
        return super.skip(n);
    }

    private void checkIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException(MESSAGE);
        }
    }
}

