/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class ScrollInsensitiveResultSetNode
extends SingleChildResultSetNode {
    ScrollInsensitiveResultSetNode(ResultSetNode childResult, ResultColumnList rcl, Properties tableProperties, ContextManager cm) {
        super(childResult, tableProperties, cm);
        this.setResultColumns(rcl);
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.getResultColumns() != null, "Tree structure bad");
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        int erdNumber = acb.addItem(this.makeResultDescription());
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.getResultSetNumber());
        mb.push(this.getResultColumns().size());
        mb.pushThis();
        mb.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getScrollable", "boolean", 0);
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, "getScrollInsensitiveResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 7);
    }
}

